/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.input;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.input.InputField;

public class LargeSelectInput
extends InputField {
    private static ResourceBundle langPack = null;
    private int optionIdx = 0;
    private Option[] options;

    public Option[] getOptions() {
        return this.options;
    }

    public void setOptions(Option[] options) {
        this.options = options;
    }

    public Option getNewOption() {
        return new Option();
    }

    public void setValue(String dir) {
        this.setInputResult(dir);
    }

    public boolean validate(InstallerContext cxt) throws ValidationException {
        if (this.getInputResult() == null) {
            return false;
        }
        String value = this.getInputResult();
        boolean ok = false;
        for (int i = 0; i < this.options.length; ++i) {
            ok |= this.options[i].value.equals(value);
        }
        return ok;
    }

    public boolean validateObject() {
        if (this.getDisplayText() == null) {
            System.out.println("LargeSelect:displayText must be set");
            return false;
        }
        if (this.getProperty() == null) {
            System.out.println("LargeSelect:property must be set");
            return false;
        }
        if (this.getDefaultValue() == null) {
            System.out.println("LargeSelect:defaultValue must be set");
            return false;
        }
        if (this.getOptions() == null) {
            System.out.println("LargeSelect:option must have at least two options");
            return false;
        }
        if (this.getOptions().length < 2) {
            System.out.println("LargeSelect:option must have at least two options");
            return false;
        }
        for (int i = 0; i < this.getOptions().length; ++i) {
            Option o = this.getOptions()[i];
            if (o.getText() == null) {
                System.out.println("LargeSelect:option:text must be set");
                return false;
            }
            if (o.value != null) continue;
            System.out.println("LargeSelect:option:value must be set");
            return false;
        }
        boolean defaultExists = false;
        for (int i = 0; i < this.getOptions().length; ++i) {
            Option o = this.getOptions()[i];
            if (!o.value.equals(this.getDefaultValue())) continue;
            defaultExists = true;
        }
        if (!defaultExists) {
            System.out.println("LargeSelect:option:Default must be one of the options");
            return false;
        }
        return true;
    }

    static {
        try {
            langPack = ResourceBundle.getBundle("resources.LanguagePack");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    public class Option {
        private int idx;
        private String text;
        public String value;

        public Option() {
            this.idx = ++LargeSelectInput.this.optionIdx;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getText() {
            if (langPack != null) {
                return langPack.getString(LargeSelectInput.this.getProperty() + "." + this.idx + ".displayText");
            }
            return this.text;
        }
    }
}

