/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime;

import java.io.File;
import java.util.ResourceBundle;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.renderer.MessageRenderer;
import org.tp23.antinstaller.runtime.TextRunner;
import org.tp23.antinstaller.runtime.exe.ExecuteFilter;
import org.tp23.antinstaller.runtime.exe.ExecuteRunnerFilter;
import org.tp23.antinstaller.runtime.exe.FilterChain;
import org.tp23.antinstaller.runtime.exe.FilterFactory;
import org.tp23.antinstaller.runtime.exe.FinalizerFilter;
import org.tp23.antinstaller.selfextract.SelfExtractor;

public class ExecInstall {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.Res");
    public static final String CONFIG_RESOURCE = "/org/tp23/antinstaller/runtime/exe/script.fconfig";
    private final InstallerContext ctx = new InstallerContext();
    private FilterChain chain;

    public ExecInstall(FilterChain chain) {
        this.chain = chain;
    }

    public void exec() {
        ExecuteFilter[] filters = null;
        try {
            this.chain.init(this.ctx);
            filters = this.chain.getFilters();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        for (int i = 0; i < filters.length; ++i) {
            try {
                this.ctx.log("Filter: " + filters[i].getClass().getName());
                filters[i].exec(this.ctx);
                continue;
            }
            catch (ExecuteRunnerFilter.AbortException abort) {
                MessageRenderer vLogger = this.ctx.getMessageRenderer();
                vLogger.printMessage(abort.getMessage());
                this.ctx.log("Aborted");
                FinalizerFilter ff = (FinalizerFilter)filters[filters.length - 1];
                ff.exec(this.ctx);
                System.exit(1);
                continue;
            }
            catch (Exception ex) {
                MessageRenderer vLogger;
                this.ctx.log("Installation error: " + ex.getMessage() + ": " + ex.getClass().toString());
                boolean verbose = true;
                if (this.ctx.getInstaller() != null) {
                    verbose = this.ctx.getInstaller().isVerbose();
                }
                this.ctx.log(verbose, ex);
                if (this.ctx.getRunner() instanceof TextRunner) {
                    if (verbose) {
                        ex.printStackTrace();
                    }
                } else if (verbose) {
                    ex.printStackTrace(System.err);
                }
                if ((vLogger = this.ctx.getMessageRenderer()) != null) {
                    vLogger.printMessage(res.getString("installationFailed") + "\n" + ex.getMessage());
                } else {
                    System.err.println(res.getString("installationFailed") + ex.getClass().getName());
                    System.err.println(ex.getMessage());
                }
                if (this.ctx.getRunner() != null) {
                    this.ctx.getRunner().fatalError();
                    break;
                }
                System.exit(1);
            }
        }
    }

    public static void main(String[] args) {
        try {
            FilterChain chain = FilterFactory.factory(CONFIG_RESOURCE);
            ExecInstall installExec = new ExecInstall(chain);
            if (installExec.parseArgs(args, true)) {
                installExec.exec();
            }
        }
        catch (InstallException e) {
            System.out.println("Cant load filter chain:/org/tp23/antinstaller/runtime/exe/script.fconfig");
            e.printStackTrace();
        }
    }

    public boolean parseArgs(String[] args, boolean requiresRootDir) {
        String uiOverride = null;
        String installType = null;
        String installRoot = null;
        int i = 0;
        if (args.length > i && !args[i].startsWith("-")) {
            uiOverride = args[i];
            ++i;
            this.ctx.setUIOverride(uiOverride);
        }
        if (requiresRootDir) {
            if (args.length > i && !args[i].startsWith("-")) {
                installRoot = args[i];
                ++i;
                this.ctx.setFileRoot(new File(installRoot));
            } else {
                ExecInstall.printUsage();
                return false;
            }
        }
        while (i < args.length) {
            if ("-type".equals(args[i]) && args.length > i + 1) {
                installType = args[i + 1];
                ++i;
                String configFileName = "antinstall-config-" + installType + ".xml";
                String buildFileName = "build-" + installType + ".xml";
                this.ctx.setInstallerConfigFile(configFileName);
                this.ctx.setAntBuildFile(buildFileName);
            }
            ++i;
        }
        return true;
    }

    private static void printUsage() {
        System.out.println("Usage java -cp $CLASSPATH org.tp23.antinstaller.ExecInstall [text|swing|default] [install root] (-type [buildtype])");
    }

    public void setInstallRoot(File installRoot) {
        this.ctx.setFileRoot(installRoot);
    }

    public void setTempRoot(File tempDir) {
        this.addShutdownHook(tempDir);
    }

    private void addShutdownHook(final File tempDir) {
        Runnable hook = new Runnable(){

            public void run() {
                if (ExecInstall.this.ctx.getInstaller() != null && ExecInstall.this.ctx.getInstaller().isDebug()) {
                    return;
                }
                if (tempDir != null && tempDir.exists() && tempDir.isDirectory()) {
                    SelfExtractor.deleteRecursive(tempDir);
                }
            }
        };
        Thread cleanUp = new Thread(hook);
        cleanUp.setDaemon(true);
        Runtime.getRuntime().addShutdownHook(cleanUp);
    }
}

