/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jetspeed.factory;

import javax.portlet.filter.FilterConfig;
import javax.portlet.filter.PortletFilter;

import org.apache.jetspeed.om.portlet.Filter;

/**
 * PortletFilterInstance
 * 
 * @version $Id: PortletFilterInstance.java 757407 2009-03-23 15:09:19Z woonsan $
 *
 */
public interface PortletFilterInstance extends PortletFilter
{
    boolean isInitialized();
    Filter getFilter();
    FilterConfig getFilterConfig();
    PortletFilter getRealPortletFilter();
}