/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.user.connection.limits.config;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Locale;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.user.connection.limits.config.Rule;
import org.apache.qpid.server.user.connection.limits.config.RulePredicates;
import org.apache.qpid.server.user.connection.limits.config.RuleSetCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileParser.class);
    private static final Character COMMENT = Character.valueOf('#');
    private static final Character CONTINUATION = Character.valueOf('\\');
    private static final Pattern NUMBER = Pattern.compile("\\s*(\\d+)\\s*");
    private static final String ACCESS_CONTROL = "acl";
    public static final String CONNECTION_LIMIT = "clt";
    private static final String CONFIG = "config";
    public static final String DEFAULT_FREQUENCY_PERIOD = "default_frequency_period";
    public static final String DEFAULT_FREQUENCY_PERIOD_ALTERNATIVE = "defaultfrequencyperiod";
    private static final String LOG_ALL = "log_all";
    private static final String LOG_ALL_ALTERNATIVE = "logall";
    public static final String BLOCK = "BLOCK";
    static final String UNRECOGNISED_INITIAL_TOKEN = "Unrecognised initial token '%s' at line %d";
    static final String NOT_ENOUGH_TOKENS = "Not enough tokens at line %d";
    static final String NUMBER_NOT_ALLOWED = "Number not allowed before '%s' at line %d";
    static final String CANNOT_LOAD_CONFIGURATION = "I/O Error while reading configuration";
    static final String PREMATURE_CONTINUATION = "Premature continuation character at line %d";
    static final String PARSE_TOKEN_FAILED = "Failed to parse token at line %d";
    static final String UNKNOWN_CLT_PROPERTY_MSG = "Unknown connection limit property: %s at line %d";
    static final String PROPERTY_KEY_ONLY_MSG = "Incomplete property (key only) at line %d";
    static final String PROPERTY_NO_EQUALS_MSG = "Incomplete property (no equals) at line %d";
    static final String PROPERTY_NO_VALUE_MSG = "Incomplete property (no value) at line %d";

    public static RuleSetCreator parse(String name) {
        return new FileParser().readAndParse(name);
    }

    public RuleSetCreator readAndParse(String name) {
        return this.readAndParse(this.getReaderFromURLString(name));
    }

    RuleSetCreator readAndParse(Reader reader) {
        RuleSetCreator ruleSetCreator = new RuleSetCreator();
        int line = 0;
        try (BufferedReader fileReader = new BufferedReader(reader);){
            int current;
            LOGGER.debug("About to load connection limit file");
            StreamTokenizer tokenizer = new StreamTokenizer(fileReader);
            tokenizer.resetSyntax();
            tokenizer.commentChar(COMMENT.charValue());
            tokenizer.eolIsSignificant(true);
            tokenizer.ordinaryChar(61);
            tokenizer.ordinaryChar(CONTINUATION.charValue());
            tokenizer.quoteChar(34);
            tokenizer.quoteChar(39);
            tokenizer.whitespaceChars(0, 32);
            tokenizer.wordChars(97, 122);
            tokenizer.wordChars(65, 90);
            tokenizer.wordChars(48, 57);
            tokenizer.wordChars(95, 95);
            tokenizer.wordChars(45, 45);
            tokenizer.wordChars(46, 46);
            tokenizer.wordChars(42, 42);
            tokenizer.wordChars(64, 64);
            tokenizer.wordChars(58, 58);
            tokenizer.wordChars(43, 43);
            tokenizer.wordChars(47, 47);
            ArrayDeque<String> stack = new ArrayDeque<String>();
            do {
                current = tokenizer.nextToken();
                line = tokenizer.lineno() - 1;
                switch (current) {
                    case -1: 
                    case 10: {
                        this.processLine(ruleSetCreator, line, stack);
                        break;
                    }
                    case -3: {
                        this.addLast(stack, tokenizer.sval);
                        break;
                    }
                    default: {
                        this.parseToken(tokenizer, stack);
                    }
                }
            } while (current != -1);
        }
        catch (IllegalConfigurationException ice) {
            throw ice;
        }
        catch (IOException ioe) {
            throw new IllegalConfigurationException(CANNOT_LOAD_CONFIGURATION, (Throwable)ioe);
        }
        catch (RuntimeException re) {
            throw new IllegalConfigurationException(String.format(PARSE_TOKEN_FAILED, line), (Throwable)re);
        }
        return ruleSetCreator;
    }

    private void processLine(RuleSetCreator ruleSetCreator, int line, Queue<String> stack) {
        if (stack.isEmpty()) {
            return;
        }
        String first = stack.poll();
        if (first == null || stack.isEmpty()) {
            throw new IllegalConfigurationException(String.format(NOT_ENOUGH_TOKENS, line));
        }
        Matcher matcher = NUMBER.matcher(first);
        if (matcher.matches()) {
            String commandType = stack.poll();
            if (ACCESS_CONTROL.equalsIgnoreCase(commandType)) {
                this.parseAccessControl(stack, ruleSetCreator, line);
                stack.clear();
                return;
            }
            throw new IllegalConfigurationException(String.format(NUMBER_NOT_ALLOWED, commandType, line));
        }
        if (CONNECTION_LIMIT.equalsIgnoreCase(first)) {
            this.parseConnectionLimit(stack, ruleSetCreator, line);
        } else if (CONFIG.equalsIgnoreCase(first)) {
            FileParser.parseConfig(stack, ruleSetCreator, line);
        } else if (ACCESS_CONTROL.equalsIgnoreCase(first)) {
            this.parseAccessControl(stack, ruleSetCreator, line);
        } else {
            throw new IllegalConfigurationException(String.format(UNRECOGNISED_INITIAL_TOKEN, first, line));
        }
        stack.clear();
    }

    private void parseToken(StreamTokenizer tokenizer, Queue<String> stack) throws IOException {
        if (tokenizer.ttype == CONTINUATION.charValue()) {
            if (tokenizer.nextToken() != 10) {
                throw new IllegalConfigurationException(String.format(PREMATURE_CONTINUATION, tokenizer.lineno()));
            }
        } else if (tokenizer.ttype == 39 || tokenizer.ttype == 34) {
            this.addLast(stack, tokenizer.sval);
        } else if (!Character.isWhitespace(tokenizer.ttype)) {
            this.addLast(stack, Character.toString((char)tokenizer.ttype));
        }
    }

    private void addLast(Queue<String> queue, String value) {
        if (value != null) {
            queue.add(value);
        }
    }

    private void parseConnectionLimit(Queue<String> args, RuleSetCreator ruleSetCreator, int line) {
        String identity = args.poll();
        RulePredicates predicates = new RulePredicates();
        Iterator<String> i = args.iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (BLOCK.equalsIgnoreCase(key)) {
                predicates.setBlockedUser();
                continue;
            }
            if (predicates.parse(key, FileParser.readValue(i, line)) != null) continue;
            throw new IllegalConfigurationException(String.format(UNKNOWN_CLT_PROPERTY_MSG, key, line));
        }
        if (!predicates.isEmpty()) {
            ruleSetCreator.add(Rule.newInstance(identity, predicates));
        }
    }

    private void parseAccessControl(Queue<String> args, RuleSetCreator ruleSetCreator, int line) {
        if (args.size() < 4) {
            return;
        }
        args.poll();
        String identity = args.poll();
        args.poll();
        args.poll();
        RulePredicates predicates = new RulePredicates();
        Iterator<String> i = args.iterator();
        while (i.hasNext()) {
            predicates.parse((String)i.next(), FileParser.readValue(i, line));
        }
        if (!predicates.isEmpty()) {
            ruleSetCreator.add(Rule.newInstance(identity, predicates));
        }
    }

    private static void parseConfig(Queue<String> args, RuleSetCreator ruleSetCreator, int line) {
        Iterator<String> i = args.iterator();
        while (i.hasNext()) {
            String key = ((String)i.next()).replace("-", "_").toLowerCase(Locale.ENGLISH);
            String value = FileParser.readValue(i, line);
            switch (key) {
                case "log_all": 
                case "logall": {
                    ruleSetCreator.setLogAllMessages(Boolean.parseBoolean(value));
                    break;
                }
                case "default_frequency_period": 
                case "defaultfrequencyperiod": {
                    ruleSetCreator.setDefaultFrequencyPeriod(Long.parseLong(value));
                    break;
                }
            }
        }
    }

    private static String readValue(Iterator<String> i, int line) {
        if (!i.hasNext()) {
            throw new IllegalConfigurationException(String.format(PROPERTY_KEY_ONLY_MSG, line));
        }
        if (!"=".equals(i.next())) {
            throw new IllegalConfigurationException(String.format(PROPERTY_NO_EQUALS_MSG, line));
        }
        if (!i.hasNext()) {
            throw new IllegalConfigurationException(String.format(PROPERTY_NO_VALUE_MSG, line));
        }
        return i.next();
    }

    private Reader getReaderFromURLString(String urlString) {
        try {
            return new InputStreamReader(new URL(urlString).openStream(), StandardCharsets.UTF_8);
        }
        catch (MalformedURLException e) {
            return this.getReaderFromPath(urlString);
        }
        catch (IOException | RuntimeException e) {
            throw FileParser.createReaderError(urlString, e);
        }
    }

    private Reader getReaderFromPath(String path) {
        try {
            return new InputStreamReader(Paths.get(path, new String[0]).toUri().toURL().openStream(), StandardCharsets.UTF_8);
        }
        catch (IOException | RuntimeException e) {
            throw FileParser.createReaderError(path, e);
        }
    }

    private static IllegalConfigurationException createReaderError(String urlString, Exception e) {
        return new IllegalConfigurationException("Cannot convert " + urlString + " to a readable resource", (Throwable)e);
    }
}

