/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.DerivedAttribute;
import org.apache.qpid.server.model.KeyStore;
import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedOperation;
import org.apache.qpid.server.model.Param;

@ManagedObject(category=false, type="AutoGeneratedSelfSigned")
public interface AutoGeneratedSelfSignedKeyStore<X extends AutoGeneratedSelfSignedKeyStore<X>>
extends KeyStore<X> {
    public static final String ENCODED_CERTIFICATE = "encodedCertificate";
    public static final String ENCODED_PRIVATE_KEY = "encodedPrivateKey";

    @ManagedAttribute(defaultValue="RSA", immutable=true)
    public String getKeyAlgorithm();

    @ManagedAttribute(defaultValue="SHA256WithRSA", immutable=true)
    public String getSignatureAlgorithm();

    @ManagedAttribute(defaultValue="2048", immutable=true)
    public int getKeyLength();

    @ManagedAttribute(defaultValue="12", immutable=true)
    public int getDurationInMonths();

    @DerivedAttribute(persist=true)
    public String getEncodedCertificate();

    @DerivedAttribute(persist=true, secure=true)
    public String getEncodedPrivateKey();

    @ManagedOperation(description="create a new private key and a new certificate", changesConfiguredObjectState=true)
    public void regenerateCertificate();

    @ManagedOperation(nonModifying=true, description="Extract a Java KeyStore containing the certificate for the autogenerated key.  The KeyStore can be used as a trust store by JMS client connecting to the broker", changesConfiguredObjectState=false)
    public Content getClientTrustStore(@Param(name="password", defaultValue="", description="The password to use to secure the keystore (by default the empty string is used).") String var1);

    @ManagedOperation(nonModifying=true, description="Extract a PEM file containing the certificate for the autogenerated key.", changesConfiguredObjectState=false)
    public Content getCertificate();
}

