/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.jms.Connection;
import org.apache.qpid.QpidException;
import org.apache.qpid.client.AMQConnection;
import org.apache.qpid.client.BrokerDetails;
import org.apache.qpid.client.ConnectionExtension;
import org.apache.qpid.jms.ConnectionURL;

public class ExtensibleConnectionURL
implements ConnectionURL {
    private final ConnectionURL _connectionURL;
    private final Map<ConnectionExtension, BiFunction<Connection, URI, Object>> _extensions;
    private final URI _connectionURI;
    private volatile Supplier<AMQConnection> _connectionSupplier;

    ExtensibleConnectionURL(ConnectionURL connectionURL, Map<ConnectionExtension, BiFunction<Connection, URI, Object>> extensions) throws QpidException {
        this(connectionURL, extensions, () -> null);
    }

    ExtensibleConnectionURL(ConnectionURL connectionURL, Map<ConnectionExtension, BiFunction<Connection, URI, Object>> extensions, Supplier<AMQConnection> connectionSupplier) throws QpidException {
        this._connectionURL = connectionURL;
        this._extensions = extensions;
        this._connectionSupplier = connectionSupplier;
        try {
            this._connectionURI = new URI(this._connectionURL.getURL());
        }
        catch (URISyntaxException e) {
            throw new QpidException("Unexpected connection URL", e);
        }
    }

    @Override
    public String getURL() {
        return this._connectionURL.getURL();
    }

    @Override
    public String getFailoverMethod() {
        return this._connectionURL.getFailoverMethod();
    }

    @Override
    public String getFailoverOption(String key) {
        return this._connectionURL.getFailoverOption(key);
    }

    @Override
    public int getBrokerCount() {
        return this._connectionURL.getBrokerCount();
    }

    @Override
    public BrokerDetails getBrokerDetails(int index) {
        return this._connectionURL.getBrokerDetails(index);
    }

    @Override
    public void addBrokerDetails(BrokerDetails broker) {
        this._connectionURL.addBrokerDetails(broker);
    }

    @Override
    public void setBrokerDetails(List<BrokerDetails> brokers) {
        this._connectionURL.setBrokerDetails(brokers);
    }

    @Override
    public List<BrokerDetails> getAllBrokerDetails() {
        return this._connectionURL.getAllBrokerDetails();
    }

    @Override
    public String getClientName() {
        return this._connectionURL.getClientName();
    }

    @Override
    public void setClientName(String clientName) {
        this._connectionURL.setClientName(clientName);
    }

    @Override
    public String getUsername() {
        if (this._extensions.containsKey((Object)ConnectionExtension.USERNAME_OVERRIDE)) {
            BiFunction<Connection, URI, Object> extension = this._extensions.get((Object)ConnectionExtension.USERNAME_OVERRIDE);
            Object userName = extension.apply(this._connectionSupplier.get(), this._connectionURI);
            return userName == null ? null : String.valueOf(userName);
        }
        return this._connectionURL.getUsername();
    }

    @Override
    public void setUsername(String username) {
        this._connectionURL.setUsername(username);
    }

    @Override
    public String getPassword() {
        if (this._extensions.containsKey((Object)ConnectionExtension.PASSWORD_OVERRIDE)) {
            BiFunction<Connection, URI, Object> extension = this._extensions.get((Object)ConnectionExtension.PASSWORD_OVERRIDE);
            Object password = extension.apply(this._connectionSupplier.get(), this._connectionURI);
            return password == null ? null : String.valueOf(password);
        }
        return this._connectionURL.getPassword();
    }

    @Override
    public void setPassword(String password) {
        this._connectionURL.setPassword(password);
    }

    @Override
    public String getVirtualHost() {
        return this._connectionURL.getVirtualHost();
    }

    @Override
    public void setVirtualHost(String virtualHost) {
        this._connectionURL.setVirtualHost(virtualHost);
    }

    @Override
    public String getOption(String key) {
        return this._connectionURL.getOption(key);
    }

    @Override
    public void setOption(String key, String value) {
        this._connectionURL.setOption(key, value);
    }

    @Override
    public String getDefaultQueueExchangeName() {
        return this._connectionURL.getDefaultQueueExchangeName();
    }

    @Override
    public String getDefaultTopicExchangeName() {
        return this._connectionURL.getDefaultTopicExchangeName();
    }

    @Override
    public String getTemporaryQueueExchangeName() {
        return this._connectionURL.getTemporaryQueueExchangeName();
    }

    @Override
    public String getTemporaryTopicExchangeName() {
        return this._connectionURL.getTemporaryTopicExchangeName();
    }

    public String toString() {
        return this._connectionURL.toString();
    }

    void setConnectionSupplier(Supplier<AMQConnection> connectionSupplier) {
        this._connectionSupplier = connectionSupplier;
    }
}

