/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.security;

import java.security.Provider;
import java.util.Map;
import javax.security.sasl.SaslClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCAProvider
extends Provider {
    private static final long serialVersionUID = 1L;
    static final String QPID_CLIENT_SASL_PROVIDER_NAME = "AMQSASLProvider-Client";
    static final String QPID_CLIENT_SASL_PROVIDER_INFO = "A JCA provider that registers all AMQ SASL providers that want to be registered";
    static final double QPID_CLIENT_SASL_PROVIDER_VERSION = 1.0;
    private static final Logger log = LoggerFactory.getLogger(JCAProvider.class);

    public JCAProvider(Map<String, Class<? extends SaslClientFactory>> providerMap) {
        super(QPID_CLIENT_SASL_PROVIDER_NAME, 1.0, QPID_CLIENT_SASL_PROVIDER_INFO);
        this.register(providerMap);
    }

    private void register(Map<String, Class<? extends SaslClientFactory>> providerMap) {
        for (Map.Entry<String, Class<? extends SaslClientFactory>> me : providerMap.entrySet()) {
            this.put("SaslClientFactory." + me.getKey(), me.getValue().getName());
            log.debug("Recording SASL Client factory for " + me.getKey() + " as " + me.getValue().getName());
        }
    }
}

