/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.store.CommitLog;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.MessageExtBrokerInner;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.dledger.DLedgerCommitLog;

public class MultiDispatch {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger((String)"RocketmqStore");
    private final StringBuilder keyBuilder = new StringBuilder();
    private final DefaultMessageStore messageStore;
    private final CommitLog commitLog;
    private boolean isDLedger;

    public MultiDispatch(DefaultMessageStore messageStore, CommitLog commitLog) {
        this.messageStore = messageStore;
        this.commitLog = commitLog;
        this.isDLedger = commitLog instanceof DLedgerCommitLog;
    }

    public boolean isMultiDispatchMsg(MessageExtBrokerInner msg) {
        if (!this.messageStore.getMessageStoreConfig().isEnableMultiDispatch()) {
            return false;
        }
        return !StringUtils.isBlank((CharSequence)msg.getProperty("INNER_MULTI_DISPATCH"));
    }

    public String queueKey(String queueName, MessageExtBrokerInner msgInner) {
        this.keyBuilder.setLength(0);
        this.keyBuilder.append(queueName);
        this.keyBuilder.append('-');
        int queueId = msgInner.getQueueId();
        if (this.messageStore.getMessageStoreConfig().isEnableLmq() && MixAll.isLmq((String)queueName)) {
            queueId = 0;
        }
        this.keyBuilder.append(queueId);
        return this.keyBuilder.toString();
    }

    public boolean wrapMultiDispatch(MessageExtBrokerInner msgInner) {
        if (!this.messageStore.getMessageStoreConfig().isEnableMultiDispatch()) {
            return true;
        }
        String multiDispatchQueue = msgInner.getProperty("INNER_MULTI_DISPATCH");
        if (StringUtils.isBlank((CharSequence)multiDispatchQueue)) {
            return true;
        }
        String[] queues = multiDispatchQueue.split(",");
        Object[] queueOffsets = new Long[queues.length];
        for (int i = 0; i < queues.length; ++i) {
            Long queueOffset;
            String key = this.queueKey(queues[i], msgInner);
            try {
                queueOffset = this.getTopicQueueOffset(key);
            }
            catch (Exception e) {
                return false;
            }
            if (null == queueOffset) {
                queueOffset = 0L;
                if (this.messageStore.getMessageStoreConfig().isEnableLmq() && MixAll.isLmq((String)key)) {
                    this.commitLog.getLmqTopicQueueTable().put(key, queueOffset);
                } else {
                    this.commitLog.getTopicQueueTable().put(key, queueOffset);
                }
            }
            queueOffsets[i] = queueOffset;
        }
        MessageAccessor.putProperty((Message)msgInner, (String)"INNER_MULTI_QUEUE_OFFSET", (String)StringUtils.join((Object[])queueOffsets, (String)","));
        this.removeWaitStorePropertyString(msgInner);
        if (this.isDLedger) {
            return true;
        }
        return this.rebuildMsgInner(msgInner);
    }

    private void removeWaitStorePropertyString(MessageExtBrokerInner msgInner) {
        if (msgInner.getProperties().containsKey("WAIT")) {
            String waitStoreMsgOKValue = (String)msgInner.getProperties().remove("WAIT");
            msgInner.setPropertiesString(MessageDecoder.messageProperties2String((Map)msgInner.getProperties()));
            msgInner.getProperties().put("WAIT", waitStoreMsgOKValue);
        } else {
            msgInner.setPropertiesString(MessageDecoder.messageProperties2String((Map)msgInner.getProperties()));
        }
    }

    public void updateMaxMessageSize(CommitLog.PutMessageThreadLocal putMessageThreadLocal) {
        int newMaxMessageSize = this.messageStore.getMessageStoreConfig().getMaxMessageSize();
        if (newMaxMessageSize >= 10 && putMessageThreadLocal.getEncoder().getMaxMessageBodySize() != newMaxMessageSize) {
            putMessageThreadLocal.getEncoder().updateEncoderBufferCapacity(newMaxMessageSize);
        }
    }

    private boolean rebuildMsgInner(MessageExtBrokerInner msgInner) {
        CommitLog.PutMessageThreadLocal putMessageThreadLocal = this.commitLog.getPutMessageThreadLocal().get();
        this.updateMaxMessageSize(putMessageThreadLocal);
        CommitLog.MessageExtEncoder encoder = putMessageThreadLocal.getEncoder();
        PutMessageResult encodeResult = encoder.encode(msgInner);
        if (encodeResult != null) {
            LOGGER.error("rebuild msgInner for multiDispatch", (Object)encodeResult);
            return false;
        }
        msgInner.setEncodedBuff(encoder.getEncoderBuffer());
        return true;
    }

    public void updateMultiQueueOffset(MessageExtBrokerInner msgInner) {
        String[] queueOffsets;
        if (!this.messageStore.getMessageStoreConfig().isEnableMultiDispatch()) {
            return;
        }
        String multiDispatchQueue = msgInner.getProperty("INNER_MULTI_DISPATCH");
        if (StringUtils.isBlank((CharSequence)multiDispatchQueue)) {
            return;
        }
        String multiQueueOffset = msgInner.getProperty("INNER_MULTI_QUEUE_OFFSET");
        if (StringUtils.isBlank((CharSequence)multiQueueOffset)) {
            LOGGER.error("[bug] no multiQueueOffset when updating {}", (Object)msgInner.getTopic());
            return;
        }
        String[] queues = multiDispatchQueue.split(",");
        if (queues.length != (queueOffsets = multiQueueOffset.split(",")).length) {
            LOGGER.error("[bug] num is not equal when updateMultiQueueOffset {}", (Object)msgInner.getTopic());
            return;
        }
        for (int i = 0; i < queues.length; ++i) {
            String key = this.queueKey(queues[i], msgInner);
            long queueOffset = Long.parseLong(queueOffsets[i]);
            if (this.messageStore.getMessageStoreConfig().isEnableLmq() && MixAll.isLmq((String)key)) {
                this.commitLog.getLmqTopicQueueTable().put(key, ++queueOffset);
                continue;
            }
            this.commitLog.getTopicQueueTable().put(key, ++queueOffset);
        }
    }

    private Long getTopicQueueOffset(String key) throws Exception {
        Long offset = null;
        if (this.messageStore.getMessageStoreConfig().isEnableLmq() && MixAll.isLmq((String)key)) {
            Long queueNextOffset = this.commitLog.getLmqTopicQueueTable().get(key);
            if (queueNextOffset != null) {
                offset = queueNextOffset;
            }
        } else {
            offset = this.commitLog.getTopicQueueTable().get(key);
        }
        return offset;
    }
}

