/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.admin;

import com.alibaba.fastjson.JSON;
import java.io.UnsupportedEncodingException;
import java.net.SocketAddress;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.ClientConfig;
import org.apache.rocketmq.client.QueryResult;
import org.apache.rocketmq.client.admin.MQAdminExtInner;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.impl.MQClientManager;
import org.apache.rocketmq.client.impl.factory.MQClientInstance;
import org.apache.rocketmq.common.AclConfig;
import org.apache.rocketmq.common.KeyBuilder;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.PlainAccessConfig;
import org.apache.rocketmq.common.ServiceState;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.constant.PermName;
import org.apache.rocketmq.common.help.FAQUrl;
import org.apache.rocketmq.common.message.MessageClientExt;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.message.MessageRequestMode;
import org.apache.rocketmq.common.topic.TopicValidator;
import org.apache.rocketmq.common.utils.NetworkUtil;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.exception.RemotingConnectException;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.rocketmq.remoting.exception.RemotingSendRequestException;
import org.apache.rocketmq.remoting.exception.RemotingTimeoutException;
import org.apache.rocketmq.remoting.protocol.admin.ConsumeStats;
import org.apache.rocketmq.remoting.protocol.admin.OffsetWrapper;
import org.apache.rocketmq.remoting.protocol.admin.RollbackStats;
import org.apache.rocketmq.remoting.protocol.admin.TopicOffset;
import org.apache.rocketmq.remoting.protocol.admin.TopicStatsTable;
import org.apache.rocketmq.remoting.protocol.body.BrokerReplicasInfo;
import org.apache.rocketmq.remoting.protocol.body.BrokerStatsData;
import org.apache.rocketmq.remoting.protocol.body.ClusterAclVersionInfo;
import org.apache.rocketmq.remoting.protocol.body.ClusterInfo;
import org.apache.rocketmq.remoting.protocol.body.ConsumeMessageDirectlyResult;
import org.apache.rocketmq.remoting.protocol.body.ConsumeStatsList;
import org.apache.rocketmq.remoting.protocol.body.ConsumerConnection;
import org.apache.rocketmq.remoting.protocol.body.ConsumerRunningInfo;
import org.apache.rocketmq.remoting.protocol.body.EpochEntryCache;
import org.apache.rocketmq.remoting.protocol.body.GroupList;
import org.apache.rocketmq.remoting.protocol.body.HARuntimeInfo;
import org.apache.rocketmq.remoting.protocol.body.KVTable;
import org.apache.rocketmq.remoting.protocol.body.ProducerConnection;
import org.apache.rocketmq.remoting.protocol.body.ProducerTableInfo;
import org.apache.rocketmq.remoting.protocol.body.QueryConsumeQueueResponseBody;
import org.apache.rocketmq.remoting.protocol.body.QueueTimeSpan;
import org.apache.rocketmq.remoting.protocol.body.SubscriptionGroupWrapper;
import org.apache.rocketmq.remoting.protocol.body.TopicConfigSerializeWrapper;
import org.apache.rocketmq.remoting.protocol.body.TopicList;
import org.apache.rocketmq.remoting.protocol.header.UpdateConsumerOffsetRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.UpdateGroupForbiddenRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.ElectMasterResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.GetMetaDataResponseHeader;
import org.apache.rocketmq.remoting.protocol.heartbeat.MessageModel;
import org.apache.rocketmq.remoting.protocol.heartbeat.SubscriptionData;
import org.apache.rocketmq.remoting.protocol.route.BrokerData;
import org.apache.rocketmq.remoting.protocol.route.QueueData;
import org.apache.rocketmq.remoting.protocol.route.TopicRouteData;
import org.apache.rocketmq.remoting.protocol.statictopic.TopicConfigAndQueueMapping;
import org.apache.rocketmq.remoting.protocol.statictopic.TopicQueueMappingDetail;
import org.apache.rocketmq.remoting.protocol.subscription.GroupForbidden;
import org.apache.rocketmq.remoting.protocol.subscription.SubscriptionGroupConfig;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.admin.MQAdminExt;
import org.apache.rocketmq.tools.admin.MQAdminUtils;
import org.apache.rocketmq.tools.admin.api.BrokerOperatorResult;
import org.apache.rocketmq.tools.admin.api.MessageTrack;
import org.apache.rocketmq.tools.admin.api.TrackType;
import org.apache.rocketmq.tools.admin.common.AdminToolHandler;
import org.apache.rocketmq.tools.admin.common.AdminToolResult;
import org.apache.rocketmq.tools.admin.common.AdminToolsResultCodeEnum;
import org.apache.rocketmq.tools.command.CommandUtil;

public class DefaultMQAdminExtImpl
implements MQAdminExt,
MQAdminExtInner {
    private static final String SOCKS_PROXY_JSON = "socksProxyJson";
    private static final Set<String> SYSTEM_GROUP_SET = new HashSet<String>();
    private final Logger logger = LoggerFactory.getLogger(DefaultMQAdminExtImpl.class);
    private final DefaultMQAdminExt defaultMQAdminExt;
    private ServiceState serviceState = ServiceState.CREATE_JUST;
    private MQClientInstance mqClientInstance;
    private RPCHook rpcHook;
    private long timeoutMillis = 20000L;
    private Random random = new Random();
    protected final List<String> kvNamespaceToDeleteList = Arrays.asList("ORDER_TOPIC_CONFIG");
    protected ThreadPoolExecutor threadPoolExecutor;

    public DefaultMQAdminExtImpl(DefaultMQAdminExt defaultMQAdminExt, long timeoutMillis) {
        this(defaultMQAdminExt, null, timeoutMillis);
    }

    public DefaultMQAdminExtImpl(DefaultMQAdminExt defaultMQAdminExt, RPCHook rpcHook, long timeoutMillis) {
        this.defaultMQAdminExt = defaultMQAdminExt;
        this.rpcHook = rpcHook;
        this.timeoutMillis = timeoutMillis;
    }

    @Override
    public void start() throws MQClientException {
        switch (this.serviceState) {
            case CREATE_JUST: {
                this.serviceState = ServiceState.START_FAILED;
                this.defaultMQAdminExt.changeInstanceNameToPID();
                if ("{}".equals(this.defaultMQAdminExt.getSocksProxyConfig())) {
                    String proxyConfig = System.getenv(SOCKS_PROXY_JSON);
                    this.defaultMQAdminExt.setSocksProxyConfig(StringUtils.isNotEmpty((CharSequence)proxyConfig) ? proxyConfig : "{}");
                }
                this.mqClientInstance = MQClientManager.getInstance().getOrCreateMQClientInstance((ClientConfig)this.defaultMQAdminExt, this.rpcHook);
                boolean registerOK = this.mqClientInstance.registerAdminExt(this.defaultMQAdminExt.getAdminExtGroup(), (MQAdminExtInner)this);
                if (!registerOK) {
                    this.serviceState = ServiceState.CREATE_JUST;
                    throw new MQClientException("The adminExt group[" + this.defaultMQAdminExt.getAdminExtGroup() + "] has created already, specified another name please." + FAQUrl.suggestTodo((String)"https://rocketmq.apache.org/docs/bestPractice/06FAQ"), null);
                }
                this.mqClientInstance.start();
                this.logger.info("the adminExt [{}] start OK", (Object)this.defaultMQAdminExt.getAdminExtGroup());
                this.serviceState = ServiceState.RUNNING;
                int threadPoolCoreSize = Integer.parseInt(System.getProperty("rocketmq.admin.threadpool.coresize", "20"));
                this.threadPoolExecutor = new ThreadPoolExecutor(threadPoolCoreSize, 100, 5L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new ThreadFactoryImpl("DefaultMQAdminExtImpl_"));
                break;
            }
            case RUNNING: 
            case START_FAILED: 
            case SHUTDOWN_ALREADY: {
                throw new MQClientException("The AdminExt service state not OK, maybe started once, " + this.serviceState + FAQUrl.suggestTodo((String)"https://rocketmq.apache.org/docs/bestPractice/06FAQ"), null);
            }
        }
    }

    @Override
    public void shutdown() {
        switch (this.serviceState) {
            case CREATE_JUST: {
                break;
            }
            case RUNNING: {
                this.mqClientInstance.unregisterAdminExt(this.defaultMQAdminExt.getAdminExtGroup());
                this.mqClientInstance.shutdown();
                this.logger.info("the adminExt [{}] shutdown OK", (Object)this.defaultMQAdminExt.getAdminExtGroup());
                this.serviceState = ServiceState.SHUTDOWN_ALREADY;
                this.threadPoolExecutor.shutdown();
                break;
            }
            case SHUTDOWN_ALREADY: {
                break;
            }
        }
    }

    @Override
    public void addBrokerToContainer(String brokerContainerAddr, String brokerConfig) throws InterruptedException, MQBrokerException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException {
        this.mqClientInstance.getMQClientAPIImpl().addBroker(brokerContainerAddr, brokerConfig, 20000L);
    }

    @Override
    public void removeBrokerFromContainer(String brokerContainerAddr, String clusterName, String brokerName, long brokerId) throws InterruptedException, MQBrokerException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException {
        this.mqClientInstance.getMQClientAPIImpl().removeBroker(brokerContainerAddr, clusterName, brokerName, brokerId, 20000L);
    }

    public AdminToolResult adminToolExecute(AdminToolHandler handler) {
        try {
            return handler.doExecute();
        }
        catch (RemotingException e) {
            this.logger.error("", (Throwable)e);
            return AdminToolResult.failure(AdminToolsResultCodeEnum.REMOTING_ERROR, e.getMessage());
        }
        catch (MQClientException e) {
            if (17 == e.getResponseCode()) {
                return AdminToolResult.failure(AdminToolsResultCodeEnum.TOPIC_ROUTE_INFO_NOT_EXIST, e.getErrorMessage());
            }
            return AdminToolResult.failure(AdminToolsResultCodeEnum.MQ_CLIENT_ERROR, e.getMessage());
        }
        catch (InterruptedException e) {
            return AdminToolResult.failure(AdminToolsResultCodeEnum.INTERRUPT_ERROR, e.getMessage());
        }
        catch (Exception e) {
            return AdminToolResult.failure(AdminToolsResultCodeEnum.MQ_BROKER_ERROR, e.getMessage());
        }
    }

    @Override
    public void updateBrokerConfig(String brokerAddr, Properties properties) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, UnsupportedEncodingException, InterruptedException, MQBrokerException, MQClientException {
        this.mqClientInstance.getMQClientAPIImpl().updateBrokerConfig(brokerAddr, properties, this.timeoutMillis);
    }

    @Override
    public Properties getBrokerConfig(String brokerAddr) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, UnsupportedEncodingException, InterruptedException, MQBrokerException {
        return this.mqClientInstance.getMQClientAPIImpl().getBrokerConfig(brokerAddr, this.timeoutMillis);
    }

    @Override
    public void createAndUpdateTopicConfig(String addr, TopicConfig config) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        this.mqClientInstance.getMQClientAPIImpl().createTopic(addr, this.defaultMQAdminExt.getCreateTopicKey(), config, this.timeoutMillis);
    }

    @Override
    public void createAndUpdatePlainAccessConfig(String addr, PlainAccessConfig config) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        this.mqClientInstance.getMQClientAPIImpl().createPlainAccessConfig(addr, config, this.timeoutMillis);
    }

    @Override
    public void deletePlainAccessConfig(String addr, String accessKey) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        this.mqClientInstance.getMQClientAPIImpl().deleteAccessConfig(addr, accessKey, this.timeoutMillis);
    }

    @Override
    public void updateGlobalWhiteAddrConfig(String addr, String globalWhiteAddrs) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        this.mqClientInstance.getMQClientAPIImpl().updateGlobalWhiteAddrsConfig(addr, globalWhiteAddrs, null, this.timeoutMillis);
    }

    @Override
    public void updateGlobalWhiteAddrConfig(String addr, String globalWhiteAddrs, String aclFileFullPath) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        this.mqClientInstance.getMQClientAPIImpl().updateGlobalWhiteAddrsConfig(addr, globalWhiteAddrs, aclFileFullPath, this.timeoutMillis);
    }

    @Override
    public ClusterAclVersionInfo examineBrokerClusterAclVersionInfo(String addr) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        return this.mqClientInstance.getMQClientAPIImpl().getBrokerClusterAclInfo(addr, this.timeoutMillis);
    }

    @Override
    public AclConfig examineBrokerClusterAclConfig(String addr) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        return this.mqClientInstance.getMQClientAPIImpl().getBrokerClusterConfig(addr, this.timeoutMillis);
    }

    @Override
    public void createAndUpdateSubscriptionGroupConfig(String addr, SubscriptionGroupConfig config) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        this.mqClientInstance.getMQClientAPIImpl().createSubscriptionGroup(addr, config, this.timeoutMillis);
    }

    @Override
    public SubscriptionGroupConfig examineSubscriptionGroupConfig(String addr, String group) throws InterruptedException, RemotingException, MQClientException, MQBrokerException {
        SubscriptionGroupWrapper wrapper = this.mqClientInstance.getMQClientAPIImpl().getAllSubscriptionGroup(addr, this.timeoutMillis);
        return (SubscriptionGroupConfig)wrapper.getSubscriptionGroupTable().get(group);
    }

    @Override
    public TopicConfig examineTopicConfig(String addr, String topic) throws InterruptedException, MQBrokerException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException {
        return this.mqClientInstance.getMQClientAPIImpl().getTopicConfig(addr, topic, this.timeoutMillis);
    }

    @Override
    public TopicStatsTable examineTopicStats(String topic) throws RemotingException, MQClientException, InterruptedException, MQBrokerException {
        TopicRouteData topicRouteData = this.examineTopicRouteInfo(topic);
        TopicStatsTable topicStatsTable = new TopicStatsTable();
        for (BrokerData bd : topicRouteData.getBrokerDatas()) {
            String addr = bd.selectBrokerAddr();
            if (addr == null) continue;
            TopicStatsTable tst = this.mqClientInstance.getMQClientAPIImpl().getTopicStatsInfo(addr, topic, this.timeoutMillis);
            topicStatsTable.getOffsetTable().putAll(tst.getOffsetTable());
        }
        Map<String, TopicConfigAndQueueMapping> brokerConfigMap = MQAdminUtils.examineTopicConfigFromRoute(topic, topicRouteData, this.defaultMQAdminExt);
        MQAdminUtils.convertPhysicalTopicStats(topic, brokerConfigMap, topicStatsTable);
        if (topicStatsTable.getOffsetTable().isEmpty()) {
            throw new MQClientException("Not found the topic stats info", null);
        }
        return topicStatsTable;
    }

    @Override
    public AdminToolResult<TopicStatsTable> examineTopicStatsConcurrent(final String topic) {
        return this.adminToolExecute(new AdminToolHandler(){

            @Override
            public AdminToolResult doExecute() throws Exception {
                final TopicStatsTable topicStatsTable = new TopicStatsTable();
                TopicRouteData topicRouteData = DefaultMQAdminExtImpl.this.examineTopicRouteInfo(topic);
                if (topicRouteData == null || CollectionUtils.isEmpty((Collection)topicRouteData.getBrokerDatas())) {
                    return AdminToolResult.success(topicStatsTable);
                }
                final CountDownLatch latch = new CountDownLatch(topicRouteData.getBrokerDatas().size());
                for (final BrokerData bd : topicRouteData.getBrokerDatas()) {
                    DefaultMQAdminExtImpl.this.threadPoolExecutor.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                String addr = bd.selectBrokerAddr();
                                if (addr != null) {
                                    TopicStatsTable tst = DefaultMQAdminExtImpl.this.mqClientInstance.getMQClientAPIImpl().getTopicStatsInfo(addr, topic, DefaultMQAdminExtImpl.this.timeoutMillis);
                                    topicStatsTable.getOffsetTable().putAll(tst.getOffsetTable());
                                }
                            }
                            catch (Exception e) {
                                DefaultMQAdminExtImpl.this.logger.error("getTopicStatsInfo error. topic={}", (Object)topic, (Object)e);
                            }
                            finally {
                                latch.countDown();
                            }
                        }
                    });
                }
                latch.await(DefaultMQAdminExtImpl.this.timeoutMillis, TimeUnit.MILLISECONDS);
                return AdminToolResult.success(topicStatsTable);
            }
        });
    }

    @Override
    public TopicStatsTable examineTopicStats(String brokerAddr, String topic) throws RemotingException, MQClientException, InterruptedException, MQBrokerException {
        return this.mqClientInstance.getMQClientAPIImpl().getTopicStatsInfo(brokerAddr, topic, this.timeoutMillis);
    }

    @Override
    public TopicList fetchAllTopicList() throws RemotingException, MQClientException, InterruptedException {
        return this.mqClientInstance.getMQClientAPIImpl().getTopicListFromNameServer(this.timeoutMillis);
    }

    @Override
    public TopicList fetchTopicsByCLuster(String clusterName) throws RemotingException, MQClientException, InterruptedException {
        return this.mqClientInstance.getMQClientAPIImpl().getTopicsByCluster(clusterName, this.timeoutMillis);
    }

    @Override
    public KVTable fetchBrokerRuntimeStats(String brokerAddr) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQBrokerException {
        return this.mqClientInstance.getMQClientAPIImpl().getBrokerRuntimeInfo(brokerAddr, this.timeoutMillis);
    }

    @Override
    public ConsumeStats examineConsumeStats(String consumerGroup) throws RemotingException, MQClientException, InterruptedException, MQBrokerException {
        return this.examineConsumeStats(consumerGroup, null);
    }

    @Override
    public ConsumeStats examineConsumeStats(String consumerGroup, String topic) throws RemotingException, MQClientException, InterruptedException, MQBrokerException {
        TopicRouteData topicRouteData = null;
        ArrayList<String> routeTopics = new ArrayList<String>();
        routeTopics.add(MixAll.getRetryTopic((String)consumerGroup));
        if (topic != null) {
            routeTopics.add(topic);
            routeTopics.add(KeyBuilder.buildPopRetryTopic((String)topic, (String)consumerGroup));
        }
        for (int i = 0; i < routeTopics.size(); ++i) {
            try {
                topicRouteData = this.examineTopicRouteInfo((String)routeTopics.get(i));
                if (topicRouteData == null) continue;
                break;
            }
            catch (Throwable e) {
                if (i != routeTopics.size() - 1) continue;
                throw e;
            }
        }
        ConsumeStats result = new ConsumeStats();
        for (Object bd : topicRouteData.getBrokerDatas()) {
            String addr = bd.selectBrokerAddr();
            if (addr == null) continue;
            ConsumeStats consumeStats = this.mqClientInstance.getMQClientAPIImpl().getConsumeStats(addr, consumerGroup, topic, this.timeoutMillis * 3L);
            result.getOffsetTable().putAll(consumeStats.getOffsetTable());
            double value = result.getConsumeTps() + consumeStats.getConsumeTps();
            result.setConsumeTps(value);
        }
        HashSet<String> topics = new HashSet<String>();
        for (Object messageQueue : result.getOffsetTable().keySet()) {
            topics.add(messageQueue.getTopic());
        }
        ConsumeStats staticResult = new ConsumeStats();
        staticResult.setConsumeTps(result.getConsumeTps());
        for (String currentTopic : topics) {
            TopicRouteData currentRoute = this.examineTopicRouteInfo(currentTopic);
            if (currentRoute.getTopicQueueMappingByBroker() == null || currentRoute.getTopicQueueMappingByBroker().isEmpty()) {
                for (Map.Entry entry : result.getOffsetTable().entrySet()) {
                    if (!((MessageQueue)entry.getKey()).getTopic().equals(currentTopic)) continue;
                    staticResult.getOffsetTable().put(entry.getKey(), entry.getValue());
                }
            }
            Map<String, TopicConfigAndQueueMapping> brokerConfigMap = MQAdminUtils.examineTopicConfigFromRoute(currentTopic, currentRoute, this.defaultMQAdminExt);
            ConsumeStats consumeStats = MQAdminUtils.convertPhysicalConsumeStats(brokerConfigMap, result);
            staticResult.getOffsetTable().putAll(consumeStats.getOffsetTable());
        }
        if (staticResult.getOffsetTable().isEmpty()) {
            ConsumerConnection connection;
            try {
                connection = this.examineConsumerConnectionInfo(consumerGroup);
            }
            catch (Exception e) {
                throw new MQClientException(206, "Not found the consumer group consume stats, because return offset table is empty, maybe the consumer not online");
            }
            if (connection.getMessageModel().equals((Object)MessageModel.BROADCASTING)) {
                throw new MQClientException(213, "Not found the consumer group consume stats, because return offset table is empty, the consumer is under the broadcast mode");
            }
        }
        return staticResult;
    }

    @Override
    public ConsumeStats examineConsumeStats(String brokerAddr, String consumerGroup, String topicName, long timeoutMillis) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQBrokerException {
        return this.mqClientInstance.getMQClientAPIImpl().getConsumeStats(brokerAddr, consumerGroup, topicName, timeoutMillis);
    }

    @Override
    public AdminToolResult<ConsumeStats> examineConsumeStatsConcurrent(final String consumerGroup, final String topic) {
        return this.adminToolExecute(new AdminToolHandler(){

            @Override
            public AdminToolResult doExecute() throws Exception {
                TopicRouteData topicRouteData = null;
                ArrayList<String> routeTopics = new ArrayList<String>();
                routeTopics.add(MixAll.getRetryTopic((String)consumerGroup));
                if (topic != null) {
                    routeTopics.add(topic);
                    routeTopics.add(KeyBuilder.buildPopRetryTopic((String)topic, (String)consumerGroup));
                }
                for (int i = 0; i < routeTopics.size(); ++i) {
                    try {
                        topicRouteData = DefaultMQAdminExtImpl.this.examineTopicRouteInfo((String)routeTopics.get(i));
                        if (topicRouteData == null) continue;
                        break;
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                if (topicRouteData == null || CollectionUtils.isEmpty((Collection)topicRouteData.getBrokerDatas())) {
                    return AdminToolResult.failure(AdminToolsResultCodeEnum.TOPIC_ROUTE_INFO_NOT_EXIST, "topic router info not found");
                }
                final ConsumeStats result = new ConsumeStats();
                final CountDownLatch latch = new CountDownLatch(topicRouteData.getBrokerDatas().size());
                final ConcurrentHashMap consumerTpsMap = new ConcurrentHashMap(topicRouteData.getBrokerDatas().size());
                for (final BrokerData bd : topicRouteData.getBrokerDatas()) {
                    DefaultMQAdminExtImpl.this.threadPoolExecutor.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                String addr = bd.selectBrokerAddr();
                                if (addr != null) {
                                    ConsumeStats consumeStats = DefaultMQAdminExtImpl.this.mqClientInstance.getMQClientAPIImpl().getConsumeStats(addr, consumerGroup, topic, DefaultMQAdminExtImpl.this.timeoutMillis);
                                    result.getOffsetTable().putAll(consumeStats.getOffsetTable());
                                    consumerTpsMap.put(addr, consumeStats.getConsumeTps());
                                }
                            }
                            catch (Exception e) {
                                DefaultMQAdminExtImpl.this.logger.error("getConsumeStats error. topic={}, consumerGroup={}", new Object[]{topic, consumerGroup, e});
                            }
                            finally {
                                latch.countDown();
                            }
                        }
                    });
                }
                latch.await(DefaultMQAdminExtImpl.this.timeoutMillis, TimeUnit.MILLISECONDS);
                for (Double tps : consumerTpsMap.values()) {
                    result.setConsumeTps(result.getConsumeTps() + tps);
                }
                if (result.getOffsetTable().isEmpty()) {
                    ConsumerConnection connection;
                    try {
                        connection = DefaultMQAdminExtImpl.this.examineConsumerConnectionInfo(consumerGroup);
                    }
                    catch (Exception e) {
                        return AdminToolResult.failure(AdminToolsResultCodeEnum.CONSUMER_NOT_ONLINE, "Not found the consumer group consume stats, because return offset table is empty, maybe the consumer not consume any message");
                    }
                    if (connection.getMessageModel().equals((Object)MessageModel.BROADCASTING)) {
                        return AdminToolResult.failure(AdminToolsResultCodeEnum.BROADCAST_CONSUMPTION, "Not found the consumer group consume stats, because return offset table is empty, the consumer is under the broadcast mode");
                    }
                }
                return AdminToolResult.success(result);
            }
        });
    }

    @Override
    public ClusterInfo examineBrokerClusterInfo() throws InterruptedException, MQBrokerException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException {
        return this.mqClientInstance.getMQClientAPIImpl().getBrokerClusterInfo(this.timeoutMillis);
    }

    @Override
    public TopicRouteData examineTopicRouteInfo(String topic) throws RemotingException, MQClientException, InterruptedException {
        return this.mqClientInstance.getMQClientAPIImpl().getTopicRouteInfoFromNameServer(topic, this.timeoutMillis);
    }

    public MessageExt viewMessage(String topic, String msgId) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        try {
            MessageDecoder.decodeMessageId((String)msgId);
            return this.viewMessage(msgId);
        }
        catch (Exception e) {
            this.logger.warn("the msgId maybe created by new client. msgId={}", (Object)msgId, (Object)e);
            return this.mqClientInstance.getMQAdminImpl().queryMessageByUniqKey(topic, msgId);
        }
    }

    @Override
    public MessageExt queryMessage(String clusterName, String topic, String msgId) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        try {
            MessageDecoder.decodeMessageId((String)msgId);
            return this.viewMessage(msgId);
        }
        catch (Exception e) {
            this.logger.warn("the msgId maybe created by new client. msgId={}", (Object)msgId, (Object)e);
            return this.mqClientInstance.getMQAdminImpl().queryMessageByUniqKey(clusterName, topic, msgId);
        }
    }

    @Override
    public ConsumerConnection examineConsumerConnectionInfo(String consumerGroup) throws InterruptedException, MQBrokerException, RemotingException, MQClientException {
        ConsumerConnection result = new ConsumerConnection();
        String topic = MixAll.getRetryTopic((String)consumerGroup);
        List brokers = this.examineTopicRouteInfo(topic).getBrokerDatas();
        BrokerData brokerData = (BrokerData)brokers.get(this.random.nextInt(brokers.size()));
        String addr = null;
        if (brokerData != null && StringUtils.isNotBlank((CharSequence)(addr = brokerData.selectBrokerAddr()))) {
            result = this.mqClientInstance.getMQClientAPIImpl().getConsumerConnectionList(addr, consumerGroup, this.timeoutMillis);
        }
        if (result.getConnectionSet().isEmpty()) {
            this.logger.warn("the consumer group not online. brokerAddr={}, group={}", (Object)addr, (Object)consumerGroup);
            throw new MQClientException(206, "Not found the consumer group connection");
        }
        return result;
    }

    @Override
    public ConsumerConnection examineConsumerConnectionInfo(String consumerGroup, String brokerAddr) throws InterruptedException, MQBrokerException, RemotingException, MQClientException {
        ConsumerConnection result = this.mqClientInstance.getMQClientAPIImpl().getConsumerConnectionList(brokerAddr, consumerGroup, this.timeoutMillis);
        if (result.getConnectionSet().isEmpty()) {
            this.logger.warn("the consumer group not online. brokerAddr={}, group={}", (Object)brokerAddr, (Object)consumerGroup);
            throw new MQClientException(206, "Not found the consumer group connection");
        }
        return result;
    }

    @Override
    public ProducerConnection examineProducerConnectionInfo(String producerGroup, String topic) throws RemotingException, MQClientException, InterruptedException, MQBrokerException {
        ProducerConnection result = new ProducerConnection();
        List brokers = this.examineTopicRouteInfo(topic).getBrokerDatas();
        BrokerData brokerData = (BrokerData)brokers.get(this.random.nextInt(brokers.size()));
        String addr = null;
        if (brokerData != null && StringUtils.isNotBlank((CharSequence)(addr = brokerData.selectBrokerAddr()))) {
            result = this.mqClientInstance.getMQClientAPIImpl().getProducerConnectionList(addr, producerGroup, this.timeoutMillis);
        }
        if (result.getConnectionSet().isEmpty()) {
            this.logger.warn("the producer group not online. brokerAddr={}, group={}", (Object)addr, (Object)producerGroup);
            throw new MQClientException("Not found the producer group connection", null);
        }
        return result;
    }

    @Override
    public ProducerTableInfo getAllProducerInfo(String brokerAddr) throws RemotingException, MQClientException, InterruptedException, MQBrokerException {
        return this.mqClientInstance.getMQClientAPIImpl().getAllProducerInfo(brokerAddr, this.timeoutMillis);
    }

    @Override
    public List<String> getNameServerAddressList() {
        return this.mqClientInstance.getMQClientAPIImpl().getNameServerAddressList();
    }

    @Override
    public int wipeWritePermOfBroker(String namesrvAddr, String brokerName) throws RemotingCommandException, RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQClientException {
        return this.mqClientInstance.getMQClientAPIImpl().wipeWritePermOfBroker(namesrvAddr, brokerName, this.timeoutMillis);
    }

    @Override
    public int addWritePermOfBroker(String namesrvAddr, String brokerName) throws RemotingCommandException, RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQClientException {
        return this.mqClientInstance.getMQClientAPIImpl().addWritePermOfBroker(namesrvAddr, brokerName, this.timeoutMillis);
    }

    @Override
    public void putKVConfig(String namespace, String key, String value) {
    }

    @Override
    public String getKVConfig(String namespace, String key) throws RemotingException, MQClientException, InterruptedException {
        return this.mqClientInstance.getMQClientAPIImpl().getKVConfigValue(namespace, key, this.timeoutMillis);
    }

    @Override
    public KVTable getKVListByNamespace(String namespace) throws RemotingException, MQClientException, InterruptedException {
        return this.mqClientInstance.getMQClientAPIImpl().getKVListByNamespace(namespace, this.timeoutMillis);
    }

    @Override
    public void deleteTopic(String topicName, String clusterName) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        Set<String> brokerAddressSet = CommandUtil.fetchMasterAndSlaveAddrByClusterName(this.defaultMQAdminExt, clusterName);
        this.deleteTopicInBroker(brokerAddressSet, topicName);
        List<String> nameServerList = this.getNameServerAddressList();
        HashSet<String> nameServerSet = new HashSet<String>(nameServerList);
        this.deleteTopicInNameServer(nameServerSet, topicName);
        for (String namespace : this.kvNamespaceToDeleteList) {
            this.deleteKvConfig(namespace, topicName);
        }
    }

    @Override
    public void deleteTopicInBroker(Set<String> addrs, String topic) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        for (String addr : addrs) {
            this.mqClientInstance.getMQClientAPIImpl().deleteTopicInBroker(addr, topic, this.timeoutMillis);
        }
    }

    @Override
    public AdminToolResult<BrokerOperatorResult> deleteTopicInBrokerConcurrent(Set<String> addrs, final String topic) {
        final CopyOnWriteArrayList<String> successList = new CopyOnWriteArrayList<String>();
        final CopyOnWriteArrayList<String> failureList = new CopyOnWriteArrayList<String>();
        final CountDownLatch latch = new CountDownLatch(addrs.size());
        for (final String addr : addrs) {
            this.threadPoolExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        DefaultMQAdminExtImpl.this.mqClientInstance.getMQClientAPIImpl().deleteTopicInBroker(addr, topic, DefaultMQAdminExtImpl.this.timeoutMillis);
                        successList.add(addr);
                    }
                    catch (Exception e) {
                        DefaultMQAdminExtImpl.this.logger.error("deleteTopicInBroker error. topic={}, broker={}", new Object[]{topic, addr, e});
                        failureList.add(addr);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
        }
        try {
            latch.await(this.timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        BrokerOperatorResult result = new BrokerOperatorResult();
        result.setSuccessList(successList);
        result.setFailureList(failureList);
        return AdminToolResult.success(result);
    }

    @Override
    public void deleteTopicInNameServer(Set<String> addrs, String topic) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        if (addrs == null) {
            String ns = this.mqClientInstance.getMQClientAPIImpl().fetchNameServerAddr();
            addrs = new HashSet<String>(Arrays.asList(ns.split(";")));
        }
        for (String addr : addrs) {
            this.mqClientInstance.getMQClientAPIImpl().deleteTopicInNameServer(addr, topic, this.timeoutMillis);
        }
    }

    @Override
    public void deleteSubscriptionGroup(String addr, String groupName) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        this.mqClientInstance.getMQClientAPIImpl().deleteSubscriptionGroup(addr, groupName, false, this.timeoutMillis);
    }

    @Override
    public void deleteSubscriptionGroup(String addr, String groupName, boolean removeOffset) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        this.mqClientInstance.getMQClientAPIImpl().deleteSubscriptionGroup(addr, groupName, removeOffset, this.timeoutMillis);
    }

    @Override
    public void createAndUpdateKvConfig(String namespace, String key, String value) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        this.mqClientInstance.getMQClientAPIImpl().putKVConfigValue(namespace, key, value, this.timeoutMillis);
    }

    @Override
    public void deleteKvConfig(String namespace, String key) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        this.mqClientInstance.getMQClientAPIImpl().deleteKVConfigValue(namespace, key, this.timeoutMillis);
    }

    @Override
    public List<RollbackStats> resetOffsetByTimestampOld(String consumerGroup, String topic, long timestamp, boolean force) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        TopicRouteData topicRouteData = this.examineTopicRouteInfo(topic);
        ArrayList<RollbackStats> rollbackStatsList = new ArrayList<RollbackStats>();
        HashMap<String, QueueData> topicRouteMap = new HashMap<String, QueueData>();
        for (QueueData queueData : topicRouteData.getQueueDatas()) {
            topicRouteMap.put(queueData.getBrokerName(), queueData);
        }
        for (BrokerData bd : topicRouteData.getBrokerDatas()) {
            String addr = bd.selectBrokerAddr();
            if (addr == null) continue;
            rollbackStatsList.addAll(this.resetOffsetByTimestampOld(addr, (QueueData)topicRouteMap.get(bd.getBrokerName()), consumerGroup, topic, timestamp, force));
        }
        return rollbackStatsList;
    }

    private List<RollbackStats> resetOffsetByTimestampOld(String brokerAddr, QueueData queueData, String consumerGroup, String topic, long timestamp, boolean force) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        RollbackStats rollbackStats;
        OffsetWrapper offsetWrapper;
        MessageQueue queue;
        ArrayList<RollbackStats> rollbackStatsList = new ArrayList<RollbackStats>();
        ConsumeStats consumeStats = this.mqClientInstance.getMQClientAPIImpl().getConsumeStats(brokerAddr, consumerGroup, this.timeoutMillis);
        boolean hasConsumed = false;
        for (Map.Entry entry : consumeStats.getOffsetTable().entrySet()) {
            queue = (MessageQueue)entry.getKey();
            offsetWrapper = (OffsetWrapper)entry.getValue();
            if (!topic.equals(queue.getTopic())) continue;
            hasConsumed = true;
            rollbackStats = this.resetOffsetConsumeOffset(brokerAddr, consumerGroup, queue, offsetWrapper, timestamp, force);
            rollbackStatsList.add(rollbackStats);
        }
        if (!hasConsumed) {
            Map topicStatus = this.mqClientInstance.getMQClientAPIImpl().getTopicStatsInfo(brokerAddr, topic, this.timeoutMillis).getOffsetTable();
            for (int i = 0; i < queueData.getReadQueueNums(); ++i) {
                queue = new MessageQueue(topic, queueData.getBrokerName(), i);
                offsetWrapper = new OffsetWrapper();
                offsetWrapper.setBrokerOffset(((TopicOffset)topicStatus.get(queue)).getMaxOffset());
                offsetWrapper.setConsumerOffset(((TopicOffset)topicStatus.get(queue)).getMinOffset());
                rollbackStats = this.resetOffsetConsumeOffset(brokerAddr, consumerGroup, queue, offsetWrapper, timestamp, force);
                rollbackStatsList.add(rollbackStats);
            }
        }
        return rollbackStatsList;
    }

    @Override
    public Map<MessageQueue, Long> resetOffsetByTimestamp(String topic, String group, long timestamp, boolean isForce) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        return this.resetOffsetByTimestamp(topic, group, timestamp, isForce, false);
    }

    @Override
    public void resetOffsetNew(String consumerGroup, String topic, long timestamp) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        try {
            this.resetOffsetByTimestamp(topic, consumerGroup, timestamp, true);
        }
        catch (MQClientException e) {
            if (206 == e.getResponseCode()) {
                this.resetOffsetByTimestampOld(consumerGroup, topic, timestamp, true);
                return;
            }
            throw e;
        }
    }

    @Override
    public AdminToolResult<BrokerOperatorResult> resetOffsetNewConcurrent(final String group, final String topic, final long timestamp) {
        return this.adminToolExecute(new AdminToolHandler(){

            @Override
            public AdminToolResult doExecute() throws Exception {
                TopicRouteData topicRouteData = DefaultMQAdminExtImpl.this.examineTopicRouteInfo(topic);
                if (topicRouteData == null || CollectionUtils.isEmpty((Collection)topicRouteData.getBrokerDatas())) {
                    return AdminToolResult.failure(AdminToolsResultCodeEnum.TOPIC_ROUTE_INFO_NOT_EXIST, "topic router info not found");
                }
                final HashMap<String, QueueData> topicRouteMap = new HashMap<String, QueueData>();
                for (QueueData queueData : topicRouteData.getQueueDatas()) {
                    topicRouteMap.put(queueData.getBrokerName(), queueData);
                }
                final CopyOnWriteArrayList<String> successList = new CopyOnWriteArrayList<String>();
                final CopyOnWriteArrayList<String> failureList = new CopyOnWriteArrayList<String>();
                final CountDownLatch latch = new CountDownLatch(topicRouteData.getBrokerDatas().size());
                for (final BrokerData bd : topicRouteData.getBrokerDatas()) {
                    DefaultMQAdminExtImpl.this.threadPoolExecutor.submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            String addr = bd.selectBrokerAddr();
                            try {
                                if (addr != null) {
                                    Map offsetTable = DefaultMQAdminExtImpl.this.mqClientInstance.getMQClientAPIImpl().invokeBrokerToResetOffset(addr, topic, group, timestamp, true, DefaultMQAdminExtImpl.this.timeoutMillis, false);
                                    if (offsetTable != null) {
                                        successList.add(addr);
                                    } else {
                                        failureList.add(addr);
                                    }
                                }
                            }
                            catch (MQClientException e) {
                                if (206 == e.getResponseCode()) {
                                    try {
                                        DefaultMQAdminExtImpl.this.resetOffsetByTimestampOld(addr, (QueueData)topicRouteMap.get(bd.getBrokerName()), group, topic, timestamp, true);
                                        successList.add(addr);
                                    }
                                    catch (Exception e2) {
                                        DefaultMQAdminExtImpl.this.logger.error(MessageFormat.format("resetOffsetByTimestampOld error. addr={0}, topic={1}, group={2},timestamp={3}", addr, topic, group, timestamp), (Throwable)e);
                                        failureList.add(addr);
                                    }
                                } else if (1 == e.getResponseCode()) {
                                    successList.add(addr);
                                } else {
                                    failureList.add(addr);
                                    DefaultMQAdminExtImpl.this.logger.error(MessageFormat.format("resetOffsetNewConcurrent error. addr={0}, topic={1}, group={2},timestamp={3}", addr, topic, group, timestamp), (Throwable)e);
                                }
                            }
                            catch (Exception e) {
                                failureList.add(addr);
                                DefaultMQAdminExtImpl.this.logger.error(MessageFormat.format("resetOffsetNewConcurrent error. addr={0}, topic={1}, group={2},timestamp={3}", addr, topic, group, timestamp), (Throwable)e);
                            }
                            finally {
                                latch.countDown();
                            }
                        }
                    });
                }
                latch.await(DefaultMQAdminExtImpl.this.timeoutMillis, TimeUnit.MILLISECONDS);
                BrokerOperatorResult result = new BrokerOperatorResult();
                result.setSuccessList(successList);
                result.setFailureList(failureList);
                if (successList.size() == topicRouteData.getBrokerDatas().size()) {
                    return AdminToolResult.success(result);
                }
                return AdminToolResult.failure(AdminToolsResultCodeEnum.MQ_BROKER_ERROR, "operator failure", result);
            }
        });
    }

    public Map<MessageQueue, Long> resetOffsetByTimestamp(String topic, String group, long timestamp, boolean isForce, boolean isC) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        TopicRouteData topicRouteData = this.examineTopicRouteInfo(topic);
        List brokerDatas = topicRouteData.getBrokerDatas();
        HashMap<MessageQueue, Long> allOffsetTable = new HashMap<MessageQueue, Long>();
        if (brokerDatas != null) {
            for (BrokerData brokerData : brokerDatas) {
                Map offsetTable;
                String addr = brokerData.selectBrokerAddr();
                if (addr == null || (offsetTable = this.mqClientInstance.getMQClientAPIImpl().invokeBrokerToResetOffset(addr, topic, group, timestamp, isForce, this.timeoutMillis, isC)) == null) continue;
                allOffsetTable.putAll(offsetTable);
            }
        }
        return allOffsetTable;
    }

    private RollbackStats resetOffsetConsumeOffset(String brokerAddr, String consumeGroup, MessageQueue queue, OffsetWrapper offsetWrapper, long timestamp, boolean force) throws RemotingException, InterruptedException, MQBrokerException {
        long resetOffset = timestamp == -1L ? this.mqClientInstance.getMQClientAPIImpl().getMaxOffset(brokerAddr, queue, this.timeoutMillis) : this.mqClientInstance.getMQClientAPIImpl().searchOffset(brokerAddr, queue, timestamp, this.timeoutMillis);
        RollbackStats rollbackStats = new RollbackStats();
        rollbackStats.setBrokerName(queue.getBrokerName());
        rollbackStats.setQueueId((long)queue.getQueueId());
        rollbackStats.setBrokerOffset(offsetWrapper.getBrokerOffset());
        rollbackStats.setConsumerOffset(offsetWrapper.getConsumerOffset());
        rollbackStats.setTimestampOffset(resetOffset);
        rollbackStats.setRollbackOffset(offsetWrapper.getConsumerOffset());
        if (force || resetOffset <= offsetWrapper.getConsumerOffset()) {
            rollbackStats.setRollbackOffset(resetOffset);
            UpdateConsumerOffsetRequestHeader requestHeader = new UpdateConsumerOffsetRequestHeader();
            requestHeader.setConsumerGroup(consumeGroup);
            requestHeader.setTopic(queue.getTopic());
            requestHeader.setQueueId(Integer.valueOf(queue.getQueueId()));
            requestHeader.setCommitOffset(Long.valueOf(resetOffset));
            requestHeader.setBname(queue.getBrokerName());
            this.mqClientInstance.getMQClientAPIImpl().updateConsumerOffset(brokerAddr, requestHeader, this.timeoutMillis);
        }
        return rollbackStats;
    }

    @Override
    public Map<String, Map<MessageQueue, Long>> getConsumeStatus(String topic, String group, String clientAddr) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        String addr;
        TopicRouteData topicRouteData = this.examineTopicRouteInfo(topic);
        List brokerDatas = topicRouteData.getBrokerDatas();
        if (brokerDatas != null && brokerDatas.size() > 0 && (addr = ((BrokerData)brokerDatas.get(0)).selectBrokerAddr()) != null) {
            return this.mqClientInstance.getMQClientAPIImpl().invokeBrokerToGetConsumerStatus(addr, topic, group, clientAddr, this.timeoutMillis);
        }
        return Collections.EMPTY_MAP;
    }

    @Override
    public void createOrUpdateOrderConf(String key, String value, boolean isCluster) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        if (isCluster) {
            this.mqClientInstance.getMQClientAPIImpl().putKVConfigValue("ORDER_TOPIC_CONFIG", key, value, this.timeoutMillis);
        } else {
            String oldOrderConfs = null;
            try {
                oldOrderConfs = this.mqClientInstance.getMQClientAPIImpl().getKVConfigValue("ORDER_TOPIC_CONFIG", key, this.timeoutMillis);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            HashMap<String, String> orderConfMap = new HashMap<String, String>();
            if (!UtilAll.isBlank((String)oldOrderConfs)) {
                String[] oldOrderConfArr;
                for (String oldOrderConf : oldOrderConfArr = oldOrderConfs.split(";")) {
                    String[] items = oldOrderConf.split(":");
                    orderConfMap.put(items[0], oldOrderConf);
                }
            }
            String[] items = value.split(":");
            orderConfMap.put(items[0], value);
            StringBuilder newOrderConf = new StringBuilder();
            String splitor = "";
            for (Map.Entry entry : orderConfMap.entrySet()) {
                newOrderConf.append(splitor).append((String)entry.getValue());
                splitor = ";";
            }
            this.mqClientInstance.getMQClientAPIImpl().putKVConfigValue("ORDER_TOPIC_CONFIG", key, newOrderConf.toString(), this.timeoutMillis);
        }
    }

    @Override
    public GroupList queryTopicConsumeByWho(String topic) throws InterruptedException, MQBrokerException, RemotingException, MQClientException {
        TopicRouteData topicRouteData = this.examineTopicRouteInfo(topic);
        for (BrokerData bd : topicRouteData.getBrokerDatas()) {
            String addr = bd.selectBrokerAddr();
            if (addr == null) continue;
            return this.mqClientInstance.getMQClientAPIImpl().queryTopicConsumeByWho(addr, topic, this.timeoutMillis);
        }
        return null;
    }

    @Override
    public SubscriptionData querySubscription(String group, String topic) throws InterruptedException, MQBrokerException, RemotingException, MQClientException {
        TopicRouteData topicRouteData = this.examineTopicRouteInfo(topic);
        for (BrokerData bd : topicRouteData.getBrokerDatas()) {
            String addr = bd.selectBrokerAddr();
            if (addr == null) continue;
            return this.mqClientInstance.getMQClientAPIImpl().querySubscriptionByConsumer(addr, group, topic, this.timeoutMillis);
        }
        return null;
    }

    @Override
    public TopicList queryTopicsByConsumer(String group) throws InterruptedException, MQBrokerException, RemotingException, MQClientException {
        String retryTopic = MixAll.getRetryTopic((String)group);
        TopicRouteData topicRouteData = this.examineTopicRouteInfo(retryTopic);
        TopicList result = new TopicList();
        for (BrokerData bd : topicRouteData.getBrokerDatas()) {
            String addr = bd.selectBrokerAddr();
            if (addr == null) continue;
            TopicList topicList = this.mqClientInstance.getMQClientAPIImpl().queryTopicsByConsumer(addr, group, this.timeoutMillis);
            result.getTopicList().addAll(topicList.getTopicList());
        }
        return result;
    }

    @Override
    public AdminToolResult<TopicList> queryTopicsByConsumerConcurrent(final String group) {
        return this.adminToolExecute(new AdminToolHandler(){

            @Override
            public AdminToolResult doExecute() throws Exception {
                String retryTopic = MixAll.getRetryTopic((String)group);
                TopicRouteData topicRouteData = DefaultMQAdminExtImpl.this.examineTopicRouteInfo(retryTopic);
                if (topicRouteData == null || CollectionUtils.isEmpty((Collection)topicRouteData.getBrokerDatas())) {
                    return AdminToolResult.failure(AdminToolsResultCodeEnum.TOPIC_ROUTE_INFO_NOT_EXIST, "router info not found.");
                }
                final TopicList result = new TopicList();
                final CountDownLatch latch = new CountDownLatch(topicRouteData.getBrokerDatas().size());
                for (final BrokerData bd : topicRouteData.getBrokerDatas()) {
                    DefaultMQAdminExtImpl.this.threadPoolExecutor.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                String addr = bd.selectBrokerAddr();
                                if (addr != null) {
                                    TopicList topicList = DefaultMQAdminExtImpl.this.mqClientInstance.getMQClientAPIImpl().queryTopicsByConsumer(addr, group, DefaultMQAdminExtImpl.this.timeoutMillis);
                                    result.getTopicList().addAll(topicList.getTopicList());
                                }
                            }
                            catch (Exception e) {
                                DefaultMQAdminExtImpl.this.logger.error("queryTopicsByConsumer error. group={}", (Object)group, (Object)e);
                            }
                            finally {
                                latch.countDown();
                            }
                        }
                    });
                }
                latch.await(DefaultMQAdminExtImpl.this.timeoutMillis, TimeUnit.MILLISECONDS);
                return AdminToolResult.success(result);
            }
        });
    }

    @Override
    public List<QueueTimeSpan> queryConsumeTimeSpan(String topic, String group) throws InterruptedException, MQBrokerException, RemotingException, MQClientException {
        ArrayList<QueueTimeSpan> spanSet = new ArrayList<QueueTimeSpan>();
        TopicRouteData topicRouteData = this.examineTopicRouteInfo(topic);
        for (BrokerData bd : topicRouteData.getBrokerDatas()) {
            String addr = bd.selectBrokerAddr();
            if (addr == null) continue;
            spanSet.addAll(this.mqClientInstance.getMQClientAPIImpl().queryConsumeTimeSpan(addr, topic, group, this.timeoutMillis));
        }
        return spanSet;
    }

    @Override
    public AdminToolResult<List<QueueTimeSpan>> queryConsumeTimeSpanConcurrent(final String topic, final String group) {
        return this.adminToolExecute(new AdminToolHandler(){

            @Override
            public AdminToolResult doExecute() throws Exception {
                final CopyOnWriteArrayList spanSet = new CopyOnWriteArrayList();
                TopicRouteData topicRouteData = DefaultMQAdminExtImpl.this.examineTopicRouteInfo(topic);
                if (topicRouteData == null || topicRouteData.getBrokerDatas() == null || topicRouteData.getBrokerDatas().size() == 0) {
                    return AdminToolResult.success(spanSet);
                }
                final CountDownLatch latch = new CountDownLatch(topicRouteData.getBrokerDatas().size());
                for (final BrokerData bd : topicRouteData.getBrokerDatas()) {
                    DefaultMQAdminExtImpl.this.threadPoolExecutor.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                String addr = bd.selectBrokerAddr();
                                if (addr != null) {
                                    spanSet.addAll(DefaultMQAdminExtImpl.this.mqClientInstance.getMQClientAPIImpl().queryConsumeTimeSpan(addr, topic, group, DefaultMQAdminExtImpl.this.timeoutMillis));
                                }
                            }
                            catch (Exception e) {
                                DefaultMQAdminExtImpl.this.logger.error("queryConsumeTimeSpan error. topic={}, group={}", new Object[]{topic, group, e});
                            }
                            finally {
                                latch.countDown();
                            }
                        }
                    });
                }
                latch.await(DefaultMQAdminExtImpl.this.timeoutMillis, TimeUnit.MILLISECONDS);
                return AdminToolResult.success(spanSet);
            }
        });
    }

    @Override
    public boolean cleanExpiredConsumerQueue(String cluster) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, MQClientException, InterruptedException {
        boolean result = false;
        try {
            ClusterInfo clusterInfo = this.examineBrokerClusterInfo();
            if (null == cluster || "".equals(cluster)) {
                for (String targetCluster : clusterInfo.retrieveAllClusterNames()) {
                    result = this.cleanExpiredConsumerQueueByCluster(clusterInfo, targetCluster);
                }
            } else {
                result = this.cleanExpiredConsumerQueueByCluster(clusterInfo, cluster);
            }
        }
        catch (MQBrokerException e) {
            this.logger.error("cleanExpiredConsumerQueue error.", (Throwable)e);
        }
        return result;
    }

    public boolean cleanExpiredConsumerQueueByCluster(ClusterInfo clusterInfo, String cluster) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, MQClientException, InterruptedException {
        String[] addrs;
        boolean result = false;
        for (String addr : addrs = clusterInfo.retrieveAllAddrByCluster(cluster)) {
            result = this.cleanExpiredConsumerQueueByAddr(addr);
        }
        return result;
    }

    @Override
    public boolean cleanExpiredConsumerQueueByAddr(String addr) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, MQClientException, InterruptedException {
        boolean result = this.mqClientInstance.getMQClientAPIImpl().cleanExpiredConsumeQueue(addr, this.timeoutMillis);
        this.logger.warn("clean expired ConsumeQueue on target broker={}, execute result={}", (Object)addr, (Object)result);
        return result;
    }

    @Override
    public boolean deleteExpiredCommitLog(String cluster) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, MQClientException, InterruptedException {
        boolean result = false;
        try {
            ClusterInfo clusterInfo = this.examineBrokerClusterInfo();
            if (StringUtils.isEmpty((CharSequence)cluster)) {
                for (String targetCluster : clusterInfo.retrieveAllClusterNames()) {
                    result = this.deleteExpiredCommitLogByCluster(clusterInfo, targetCluster);
                }
            } else {
                result = this.deleteExpiredCommitLogByCluster(clusterInfo, cluster);
            }
        }
        catch (MQBrokerException e) {
            this.logger.error("deleteExpiredCommitLog error.", (Throwable)e);
        }
        return result;
    }

    public boolean deleteExpiredCommitLogByCluster(ClusterInfo clusterInfo, String cluster) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, MQClientException, InterruptedException {
        String[] addrs;
        boolean result = false;
        for (String addr : addrs = clusterInfo.retrieveAllAddrByCluster(cluster)) {
            result = this.deleteExpiredCommitLogByAddr(addr);
        }
        return result;
    }

    @Override
    public boolean deleteExpiredCommitLogByAddr(String addr) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, MQClientException, InterruptedException {
        boolean result = this.mqClientInstance.getMQClientAPIImpl().deleteExpiredCommitLog(addr, this.timeoutMillis);
        this.logger.warn("Delete expired CommitLog on target broker={}, execute result={}", (Object)addr, (Object)result);
        return result;
    }

    @Override
    public boolean cleanUnusedTopic(String cluster) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, MQClientException, InterruptedException {
        boolean result = false;
        try {
            ClusterInfo clusterInfo = this.examineBrokerClusterInfo();
            if (StringUtils.isEmpty((CharSequence)cluster)) {
                for (String targetCluster : clusterInfo.retrieveAllClusterNames()) {
                    result = this.cleanUnusedTopicByCluster(clusterInfo, targetCluster);
                }
            } else {
                result = this.cleanUnusedTopicByCluster(clusterInfo, cluster);
            }
        }
        catch (MQBrokerException e) {
            this.logger.error("cleanExpiredConsumerQueue error.", (Throwable)e);
        }
        return result;
    }

    public boolean cleanUnusedTopicByCluster(ClusterInfo clusterInfo, String cluster) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, MQClientException, InterruptedException {
        String[] addrs;
        boolean result = false;
        for (String addr : addrs = clusterInfo.retrieveAllAddrByCluster(cluster)) {
            result = this.cleanUnusedTopicByAddr(addr);
        }
        return result;
    }

    @Override
    public boolean cleanUnusedTopicByAddr(String addr) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, MQClientException, InterruptedException {
        boolean result = this.mqClientInstance.getMQClientAPIImpl().cleanUnusedTopicByAddr(addr, this.timeoutMillis);
        this.logger.warn("clean unused topic on target broker={}, execute result={}", (Object)addr, (Object)result);
        return result;
    }

    @Override
    public ConsumerRunningInfo getConsumerRunningInfo(String consumerGroup, String clientId, boolean jstack) throws RemotingException, MQClientException, InterruptedException {
        return this.getConsumerRunningInfo(consumerGroup, clientId, jstack, false);
    }

    @Override
    public ConsumerRunningInfo getConsumerRunningInfo(String consumerGroup, String clientId, boolean jstack, boolean metrics) throws RemotingException, MQClientException, InterruptedException {
        String topic = "%RETRY%" + consumerGroup;
        TopicRouteData topicRouteData = this.examineTopicRouteInfo(topic);
        List brokerDatas = topicRouteData.getBrokerDatas();
        if (brokerDatas != null) {
            for (BrokerData brokerData : brokerDatas) {
                String addr = brokerData.selectBrokerAddr();
                if (addr == null) continue;
                return this.mqClientInstance.getMQClientAPIImpl().getConsumerRunningInfo(addr, consumerGroup, clientId, jstack, this.timeoutMillis);
            }
        }
        return null;
    }

    @Override
    public ConsumeMessageDirectlyResult consumeMessageDirectly(String consumerGroup, String clientId, String msgId) throws RemotingException, MQClientException, InterruptedException, MQBrokerException {
        MessageExt msg = this.viewMessage(msgId);
        return this.mqClientInstance.getMQClientAPIImpl().consumeMessageDirectly(NetworkUtil.socketAddress2String((SocketAddress)msg.getStoreHost()), consumerGroup, clientId, msg.getTopic(), msgId, this.timeoutMillis);
    }

    @Override
    public ConsumeMessageDirectlyResult consumeMessageDirectly(String consumerGroup, String clientId, String topic, String msgId) throws RemotingException, MQClientException, InterruptedException, MQBrokerException {
        MessageExt msg = this.viewMessage(topic, msgId);
        if (msg.getProperty("UNIQ_KEY") == null) {
            return this.mqClientInstance.getMQClientAPIImpl().consumeMessageDirectly(NetworkUtil.socketAddress2String((SocketAddress)msg.getStoreHost()), consumerGroup, clientId, topic, msgId, this.timeoutMillis);
        }
        MessageClientExt msgClient = (MessageClientExt)msg;
        return this.mqClientInstance.getMQClientAPIImpl().consumeMessageDirectly(NetworkUtil.socketAddress2String((SocketAddress)msg.getStoreHost()), consumerGroup, clientId, topic, msgClient.getOffsetMsgId(), this.timeoutMillis);
    }

    @Override
    public List<MessageTrack> messageTrackDetail(MessageExt msg) throws RemotingException, MQClientException, InterruptedException, MQBrokerException {
        ArrayList<MessageTrack> result = new ArrayList<MessageTrack>();
        GroupList groupList = this.queryTopicConsumeByWho(msg.getTopic());
        block11: for (String group : groupList.getGroupList()) {
            MessageTrack mt = new MessageTrack();
            mt.setConsumerGroup(group);
            mt.setTrackType(TrackType.UNKNOWN);
            ConsumerConnection cc = null;
            try {
                cc = this.examineConsumerConnectionInfo(group);
            }
            catch (MQBrokerException e) {
                if (206 == e.getResponseCode()) {
                    mt.setTrackType(TrackType.NOT_ONLINE);
                }
                mt.setExceptionDesc("CODE:" + e.getResponseCode() + " DESC:" + e.getErrorMessage());
                result.add(mt);
                continue;
            }
            catch (Exception e) {
                mt.setExceptionDesc(UtilAll.exceptionSimpleDesc((Throwable)e));
                result.add(mt);
                continue;
            }
            switch (cc.getConsumeType()) {
                case CONSUME_ACTIVELY: {
                    mt.setTrackType(TrackType.PULL);
                    break;
                }
                case CONSUME_PASSIVELY: {
                    boolean ifConsumed = false;
                    try {
                        ifConsumed = this.consumed(msg, group);
                    }
                    catch (MQClientException e) {
                        if (206 == e.getResponseCode()) {
                            mt.setTrackType(TrackType.NOT_ONLINE);
                            mt.setExceptionDesc("CODE:" + e.getResponseCode() + " DESC:" + e.getErrorMessage());
                        }
                        if (213 == e.getResponseCode()) {
                            mt.setTrackType(TrackType.CONSUME_BROADCASTING);
                        }
                        result.add(mt);
                        continue block11;
                    }
                    catch (MQBrokerException e) {
                        if (206 == e.getResponseCode()) {
                            mt.setTrackType(TrackType.NOT_ONLINE);
                            mt.setExceptionDesc("CODE:" + e.getResponseCode() + " DESC:" + e.getErrorMessage());
                        }
                        if (213 == e.getResponseCode()) {
                            mt.setTrackType(TrackType.CONSUME_BROADCASTING);
                        }
                        result.add(mt);
                        continue block11;
                    }
                    catch (Exception e) {
                        mt.setExceptionDesc(UtilAll.exceptionSimpleDesc((Throwable)e));
                        result.add(mt);
                        continue block11;
                    }
                    if (ifConsumed) {
                        mt.setTrackType(TrackType.CONSUMED);
                        for (Map.Entry next : cc.getSubscriptionTable().entrySet()) {
                            if (!((String)next.getKey()).equals(msg.getTopic()) || ((SubscriptionData)next.getValue()).getTagsSet().contains(msg.getTags()) || ((SubscriptionData)next.getValue()).getTagsSet().contains("*") || ((SubscriptionData)next.getValue()).getTagsSet().isEmpty()) continue;
                            mt.setTrackType(TrackType.CONSUMED_BUT_FILTERED);
                        }
                        break;
                    }
                    mt.setTrackType(TrackType.NOT_CONSUME_YET);
                    break;
                }
            }
            result.add(mt);
        }
        return result;
    }

    @Override
    public List<MessageTrack> messageTrackDetailConcurrent(final MessageExt msg) throws RemotingException, MQClientException, InterruptedException, MQBrokerException {
        final ArrayList<MessageTrack> result = new ArrayList<MessageTrack>();
        GroupList groupList = this.queryTopicConsumeByWho(msg.getTopic());
        final CountDownLatch countDownLatch = new CountDownLatch(groupList.getGroupList().size());
        for (final String group : groupList.getGroupList()) {
            this.threadPoolExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    MessageTrack mt = new MessageTrack();
                    mt.setConsumerGroup(group);
                    mt.setTrackType(TrackType.UNKNOWN);
                    ConsumerConnection cc = null;
                    try {
                        cc = DefaultMQAdminExtImpl.this.examineConsumerConnectionInfo(group);
                    }
                    catch (MQBrokerException e) {
                        if (206 == e.getResponseCode()) {
                            mt.setTrackType(TrackType.NOT_ONLINE);
                        }
                        mt.setExceptionDesc("CODE:" + e.getResponseCode() + " DESC:" + e.getErrorMessage());
                        result.add(mt);
                        countDownLatch.countDown();
                        return;
                    }
                    catch (Exception e) {
                        mt.setExceptionDesc(UtilAll.exceptionSimpleDesc((Throwable)e));
                        result.add(mt);
                        countDownLatch.countDown();
                        return;
                    }
                    switch (cc.getConsumeType()) {
                        case CONSUME_ACTIVELY: {
                            mt.setTrackType(TrackType.PULL);
                            break;
                        }
                        case CONSUME_PASSIVELY: {
                            boolean ifConsumed = false;
                            try {
                                ifConsumed = DefaultMQAdminExtImpl.this.consumed(msg, group);
                            }
                            catch (MQClientException e) {
                                if (206 == e.getResponseCode()) {
                                    mt.setTrackType(TrackType.NOT_ONLINE);
                                }
                                mt.setExceptionDesc("CODE:" + e.getResponseCode() + " DESC:" + e.getErrorMessage());
                                result.add(mt);
                                countDownLatch.countDown();
                                return;
                            }
                            catch (MQBrokerException e) {
                                if (206 == e.getResponseCode()) {
                                    mt.setTrackType(TrackType.NOT_ONLINE);
                                }
                                mt.setExceptionDesc("CODE:" + e.getResponseCode() + " DESC:" + e.getErrorMessage());
                                result.add(mt);
                                countDownLatch.countDown();
                                return;
                            }
                            catch (Exception e) {
                                mt.setExceptionDesc(UtilAll.exceptionSimpleDesc((Throwable)e));
                                result.add(mt);
                                countDownLatch.countDown();
                                return;
                            }
                            if (ifConsumed) {
                                mt.setTrackType(TrackType.CONSUMED);
                                for (Map.Entry next : cc.getSubscriptionTable().entrySet()) {
                                    if (!((String)next.getKey()).equals(msg.getTopic()) || ((SubscriptionData)next.getValue()).getTagsSet().contains(msg.getTags()) || ((SubscriptionData)next.getValue()).getTagsSet().contains("*") || ((SubscriptionData)next.getValue()).getTagsSet().isEmpty()) continue;
                                    mt.setTrackType(TrackType.CONSUMED_BUT_FILTERED);
                                }
                                break;
                            }
                            mt.setTrackType(TrackType.NOT_CONSUME_YET);
                            break;
                        }
                    }
                    result.add(mt);
                    countDownLatch.countDown();
                }
            });
        }
        countDownLatch.await(this.timeoutMillis, TimeUnit.MILLISECONDS);
        return result;
    }

    public boolean consumed(MessageExt msg, String group) throws RemotingException, MQClientException, InterruptedException, MQBrokerException {
        ConsumeStats cstats = this.examineConsumeStats(group);
        ClusterInfo ci = this.examineBrokerClusterInfo();
        for (Map.Entry next : cstats.getOffsetTable().entrySet()) {
            BrokerData brokerData;
            MessageQueue mq = (MessageQueue)next.getKey();
            if (!mq.getTopic().equals(msg.getTopic()) || mq.getQueueId() != msg.getQueueId() || (brokerData = (BrokerData)ci.getBrokerAddrTable().get(mq.getBrokerName())) == null) continue;
            String addr = NetworkUtil.convert2IpString((String)((String)brokerData.getBrokerAddrs().get(0L)));
            if (!NetworkUtil.socketAddress2String((SocketAddress)msg.getStoreHost()).equals(addr) || ((OffsetWrapper)next.getValue()).getConsumerOffset() <= msg.getQueueOffset()) continue;
            return true;
        }
        return false;
    }

    public boolean consumedConcurrent(MessageExt msg, String group) throws RemotingException, MQClientException, InterruptedException, MQBrokerException {
        AdminToolResult<ConsumeStats> cstats = this.examineConsumeStatsConcurrent(group, null);
        if (!cstats.isSuccess()) {
            throw new MQClientException(cstats.getCode(), cstats.getErrorMsg());
        }
        ClusterInfo ci = this.examineBrokerClusterInfo();
        if (cstats.isSuccess()) {
            for (Map.Entry next : cstats.getData().getOffsetTable().entrySet()) {
                String addr;
                BrokerData brokerData;
                MessageQueue mq = (MessageQueue)next.getKey();
                if (!mq.getTopic().equals(msg.getTopic()) || mq.getQueueId() != msg.getQueueId() || (brokerData = (BrokerData)ci.getBrokerAddrTable().get(mq.getBrokerName())) == null || !(addr = (String)brokerData.getBrokerAddrs().get(0L)).equals(NetworkUtil.socketAddress2String((SocketAddress)msg.getStoreHost())) || ((OffsetWrapper)next.getValue()).getConsumerOffset() <= msg.getQueueOffset()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void cloneGroupOffset(String srcGroup, String destGroup, String topic, boolean isOffline) throws RemotingException, MQClientException, InterruptedException, MQBrokerException {
        String retryTopic = MixAll.getRetryTopic((String)srcGroup);
        TopicRouteData topicRouteData = this.examineTopicRouteInfo(retryTopic);
        for (BrokerData bd : topicRouteData.getBrokerDatas()) {
            String addr = bd.selectBrokerAddr();
            if (addr == null) continue;
            this.mqClientInstance.getMQClientAPIImpl().cloneGroupOffset(addr, srcGroup, destGroup, topic, isOffline, this.timeoutMillis);
        }
    }

    @Override
    public BrokerStatsData viewBrokerStatsData(String brokerAddr, String statsName, String statsKey) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, MQClientException, InterruptedException {
        return this.mqClientInstance.getMQClientAPIImpl().viewBrokerStatsData(brokerAddr, statsName, statsKey, this.timeoutMillis);
    }

    @Override
    public Set<String> getClusterList(String topic) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, MQClientException, InterruptedException {
        return this.mqClientInstance.getMQClientAPIImpl().getClusterList(topic, this.timeoutMillis);
    }

    @Override
    public ConsumeStatsList fetchConsumeStatsInBroker(String brokerAddr, boolean isOrder, long timeoutMillis) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, MQClientException, InterruptedException {
        return this.mqClientInstance.getMQClientAPIImpl().fetchConsumeStatsInBroker(brokerAddr, isOrder, timeoutMillis);
    }

    @Override
    public Set<String> getTopicClusterList(String topic) throws InterruptedException, MQBrokerException, MQClientException, RemotingException {
        HashSet<String> clusterSet = new HashSet<String>();
        ClusterInfo clusterInfo = this.examineBrokerClusterInfo();
        TopicRouteData topicRouteData = this.examineTopicRouteInfo(topic);
        BrokerData brokerData = (BrokerData)topicRouteData.getBrokerDatas().get(0);
        String brokerName = brokerData.getBrokerName();
        for (Map.Entry next : clusterInfo.getClusterAddrTable().entrySet()) {
            if (!((Set)next.getValue()).contains(brokerName)) continue;
            clusterSet.add((String)next.getKey());
        }
        return clusterSet;
    }

    @Override
    public SubscriptionGroupWrapper getAllSubscriptionGroup(String brokerAddr, long timeoutMillis) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQBrokerException {
        return this.mqClientInstance.getMQClientAPIImpl().getAllSubscriptionGroup(brokerAddr, timeoutMillis);
    }

    @Override
    public SubscriptionGroupWrapper getUserSubscriptionGroup(String brokerAddr, long timeoutMillis) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQBrokerException {
        SubscriptionGroupWrapper subscriptionGroupWrapper = this.mqClientInstance.getMQClientAPIImpl().getAllSubscriptionGroup(brokerAddr, timeoutMillis);
        Iterator iterator = subscriptionGroupWrapper.getSubscriptionGroupTable().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry configEntry = iterator.next();
            if (!MixAll.isSysConsumerGroup((String)((String)configEntry.getKey())) && !SYSTEM_GROUP_SET.contains(configEntry.getKey())) continue;
            iterator.remove();
        }
        return subscriptionGroupWrapper;
    }

    @Override
    public TopicConfigSerializeWrapper getAllTopicConfig(String brokerAddr, long timeoutMillis) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQBrokerException {
        return this.mqClientInstance.getMQClientAPIImpl().getAllTopicConfig(brokerAddr, timeoutMillis);
    }

    @Override
    public TopicConfigSerializeWrapper getUserTopicConfig(String brokerAddr, boolean specialTopic, long timeoutMillis) throws InterruptedException, RemotingException, MQBrokerException, MQClientException {
        TopicConfigSerializeWrapper topicConfigSerializeWrapper = this.getAllTopicConfig(brokerAddr, timeoutMillis);
        TopicList topicList = this.mqClientInstance.getMQClientAPIImpl().getSystemTopicListFromBroker(brokerAddr, timeoutMillis);
        Iterator iterator = topicConfigSerializeWrapper.getTopicConfigTable().entrySet().iterator();
        while (iterator.hasNext()) {
            TopicConfig topicConfig = (TopicConfig)iterator.next().getValue();
            if (topicList.getTopicList().contains(topicConfig.getTopicName()) || TopicValidator.isSystemTopic((String)topicConfig.getTopicName())) {
                iterator.remove();
                continue;
            }
            if (!specialTopic && StringUtils.startsWithAny((CharSequence)topicConfig.getTopicName(), (CharSequence[])new CharSequence[]{"%RETRY%", "%DLQ%"})) {
                iterator.remove();
                continue;
            }
            if (PermName.isValid((int)topicConfig.getPerm())) continue;
            iterator.remove();
        }
        return topicConfigSerializeWrapper;
    }

    public void createTopic(String key, String newTopic, int queueNum, Map<String, String> attributes) throws MQClientException {
        this.createTopic(key, newTopic, queueNum, 0, attributes);
    }

    public void createTopic(String key, String newTopic, int queueNum, int topicSysFlag, Map<String, String> attributes) throws MQClientException {
        this.mqClientInstance.getMQAdminImpl().createTopic(key, newTopic, queueNum, topicSysFlag, attributes);
    }

    @Override
    public void createStaticTopic(String addr, String defaultTopic, TopicConfig topicConfig, TopicQueueMappingDetail mappingDetail, boolean force) throws RemotingException, InterruptedException, MQBrokerException {
        this.mqClientInstance.getMQClientAPIImpl().createStaticTopic(addr, defaultTopic, topicConfig, mappingDetail, force, this.timeoutMillis);
    }

    public long searchOffset(MessageQueue mq, long timestamp) throws MQClientException {
        return this.mqClientInstance.getMQAdminImpl().searchOffset(mq, timestamp);
    }

    public long maxOffset(MessageQueue mq) throws MQClientException {
        return this.mqClientInstance.getMQAdminImpl().maxOffset(mq);
    }

    public long minOffset(MessageQueue mq) throws MQClientException {
        return this.mqClientInstance.getMQAdminImpl().minOffset(mq);
    }

    public long earliestMsgStoreTime(MessageQueue mq) throws MQClientException {
        return this.mqClientInstance.getMQAdminImpl().earliestMsgStoreTime(mq);
    }

    public MessageExt viewMessage(String msgId) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        return this.mqClientInstance.getMQAdminImpl().viewMessage(msgId);
    }

    public QueryResult queryMessage(String topic, String key, int maxNum, long begin, long end) throws MQClientException, InterruptedException {
        return this.mqClientInstance.getMQAdminImpl().queryMessage(topic, key, maxNum, begin, end);
    }

    @Override
    public void updateConsumeOffset(String brokerAddr, String consumeGroup, MessageQueue mq, long offset) throws RemotingException, InterruptedException, MQBrokerException {
        UpdateConsumerOffsetRequestHeader requestHeader = new UpdateConsumerOffsetRequestHeader();
        requestHeader.setConsumerGroup(consumeGroup);
        requestHeader.setTopic(mq.getTopic());
        requestHeader.setQueueId(Integer.valueOf(mq.getQueueId()));
        requestHeader.setCommitOffset(Long.valueOf(offset));
        requestHeader.setBname(mq.getBrokerName());
        this.mqClientInstance.getMQClientAPIImpl().updateConsumerOffset(brokerAddr, requestHeader, this.timeoutMillis);
    }

    @Override
    public void updateNameServerConfig(Properties properties, List<String> nameServers) throws InterruptedException, RemotingConnectException, UnsupportedEncodingException, RemotingSendRequestException, RemotingTimeoutException, MQClientException, MQBrokerException {
        this.mqClientInstance.getMQClientAPIImpl().updateNameServerConfig(properties, nameServers, this.timeoutMillis);
    }

    @Override
    public Map<String, Properties> getNameServerConfig(List<String> nameServers) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQClientException, UnsupportedEncodingException {
        return this.mqClientInstance.getMQClientAPIImpl().getNameServerConfig(nameServers, this.timeoutMillis);
    }

    @Override
    public QueryConsumeQueueResponseBody queryConsumeQueue(String brokerAddr, String topic, int queueId, long index, int count, String consumerGroup) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQClientException {
        return this.mqClientInstance.getMQClientAPIImpl().queryConsumeQueue(brokerAddr, topic, queueId, index, count, consumerGroup, this.timeoutMillis);
    }

    @Override
    public boolean resumeCheckHalfMessage(String msgId) throws RemotingException, MQClientException, InterruptedException, MQBrokerException {
        MessageExt msg = this.viewMessage(msgId);
        return this.mqClientInstance.getMQClientAPIImpl().resumeCheckHalfMessage(NetworkUtil.socketAddress2String((SocketAddress)msg.getStoreHost()), msgId, this.timeoutMillis);
    }

    @Override
    public boolean resumeCheckHalfMessage(String topic, String msgId) throws RemotingException, MQClientException, InterruptedException, MQBrokerException {
        MessageExt msg = this.viewMessage(topic, msgId);
        if (msg.getProperty("UNIQ_KEY") == null) {
            return this.mqClientInstance.getMQClientAPIImpl().resumeCheckHalfMessage(NetworkUtil.socketAddress2String((SocketAddress)msg.getStoreHost()), msgId, this.timeoutMillis);
        }
        MessageClientExt msgClient = (MessageClientExt)msg;
        return this.mqClientInstance.getMQClientAPIImpl().resumeCheckHalfMessage(NetworkUtil.socketAddress2String((SocketAddress)msg.getStoreHost()), msgClient.getOffsetMsgId(), this.timeoutMillis);
    }

    @Override
    public void setMessageRequestMode(String brokerAddr, String topic, String consumerGroup, MessageRequestMode mode, int popShareQueueNum, long timeoutMillis) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQClientException {
        this.mqClientInstance.getMQClientAPIImpl().setMessageRequestMode(brokerAddr, topic, consumerGroup, mode, popShareQueueNum, timeoutMillis);
    }

    @Override
    @Deprecated
    public long searchOffset(String brokerAddr, String topicName, int queueId, long timestamp, long timeoutMillis) throws RemotingException, MQBrokerException, InterruptedException {
        return this.mqClientInstance.getMQClientAPIImpl().searchOffset(brokerAddr, topicName, queueId, timestamp, timeoutMillis);
    }

    public QueryResult queryMessageByUniqKey(String topic, String key, int maxNum, long begin, long end) throws MQClientException, InterruptedException {
        return this.mqClientInstance.getMQAdminImpl().queryMessageByUniqKey(topic, key, maxNum, begin, end);
    }

    @Override
    public void resetOffsetByQueueId(String brokerAddr, String consumeGroup, String topicName, int queueId, long resetOffset) throws RemotingException, InterruptedException, MQBrokerException {
        UpdateConsumerOffsetRequestHeader requestHeader = new UpdateConsumerOffsetRequestHeader();
        requestHeader.setConsumerGroup(consumeGroup);
        requestHeader.setTopic(topicName);
        requestHeader.setQueueId(Integer.valueOf(queueId));
        requestHeader.setCommitOffset(Long.valueOf(resetOffset));
        this.mqClientInstance.getMQClientAPIImpl().updateConsumerOffset(brokerAddr, requestHeader, this.timeoutMillis);
        try {
            Map result = this.mqClientInstance.getMQClientAPIImpl().invokeBrokerToResetOffset(brokerAddr, topicName, consumeGroup, 0L, queueId, Long.valueOf(resetOffset), this.timeoutMillis);
            if (null != result) {
                for (Map.Entry entry : result.entrySet()) {
                    this.logger.info("Reset single message queue {} offset from {} to {}", new Object[]{JSON.toJSONString(entry.getKey()), entry.getValue(), resetOffset});
                }
            }
        }
        catch (MQClientException e) {
            throw new MQBrokerException(e.getResponseCode(), e.getMessage());
        }
    }

    @Override
    public HARuntimeInfo getBrokerHAStatus(String brokerAddr) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQBrokerException {
        return this.mqClientInstance.getMQClientAPIImpl().getBrokerHAStatus(brokerAddr, this.timeoutMillis);
    }

    @Override
    public BrokerReplicasInfo getInSyncStateData(String controllerAddress, List<String> brokers) throws RemotingException, InterruptedException, MQBrokerException {
        return this.mqClientInstance.getMQClientAPIImpl().getInSyncStateData(controllerAddress, brokers);
    }

    @Override
    public EpochEntryCache getBrokerEpochCache(String brokerAddr) throws RemotingException, InterruptedException, MQBrokerException {
        return this.mqClientInstance.getMQClientAPIImpl().getBrokerEpochCache(brokerAddr);
    }

    @Override
    public GetMetaDataResponseHeader getControllerMetaData(String controllerAddr) throws RemotingException, InterruptedException, MQBrokerException {
        return this.mqClientInstance.getMQClientAPIImpl().getControllerMetaData(controllerAddr);
    }

    @Override
    public void resetMasterFlushOffset(String brokerAddr, long masterFlushOffset) throws InterruptedException, MQBrokerException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException {
        this.mqClientInstance.getMQClientAPIImpl().resetMasterFlushOffset(brokerAddr, masterFlushOffset);
    }

    @Override
    public ElectMasterResponseHeader electMaster(String controllerAddr, String clusterName, String brokerName, String brokerAddr) throws RemotingException, InterruptedException, MQBrokerException {
        return this.mqClientInstance.getMQClientAPIImpl().electMaster(controllerAddr, clusterName, brokerName, brokerAddr);
    }

    @Override
    public GroupForbidden updateAndGetGroupReadForbidden(String brokerAddr, String groupName, String topicName, Boolean readable) throws RemotingException, InterruptedException, MQBrokerException {
        UpdateGroupForbiddenRequestHeader requestHeader = new UpdateGroupForbiddenRequestHeader();
        requestHeader.setGroup(groupName);
        requestHeader.setTopic(topicName);
        requestHeader.setReadable(readable);
        return this.mqClientInstance.getMQClientAPIImpl().updateAndGetGroupForbidden(brokerAddr, requestHeader, this.timeoutMillis);
    }

    @Override
    public void deleteTopicInNameServer(Set<String> addrs, String clusterName, String topic) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        if (addrs == null) {
            String ns = this.mqClientInstance.getMQClientAPIImpl().fetchNameServerAddr();
            addrs = new HashSet<String>(Arrays.asList(ns.split(";")));
        }
        for (String addr : addrs) {
            this.mqClientInstance.getMQClientAPIImpl().deleteTopicInNameServer(addr, clusterName, topic, this.timeoutMillis);
        }
    }

    @Override
    public Map<String, Properties> getControllerConfig(List<String> controllerServers) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQClientException, UnsupportedEncodingException {
        return this.mqClientInstance.getMQClientAPIImpl().getControllerConfig(controllerServers, this.timeoutMillis);
    }

    @Override
    public void updateControllerConfig(Properties properties, List<String> controllers) throws InterruptedException, RemotingConnectException, UnsupportedEncodingException, RemotingSendRequestException, RemotingTimeoutException, MQClientException, MQBrokerException {
        this.mqClientInstance.getMQClientAPIImpl().updateControllerConfig(properties, controllers, this.timeoutMillis);
    }

    @Override
    public void cleanControllerBrokerData(String controllerAddr, String clusterName, String brokerName, String brokerAddr, boolean isCleanLivingBroker) throws RemotingException, InterruptedException, MQBrokerException {
        this.mqClientInstance.getMQClientAPIImpl().cleanControllerBrokerData(controllerAddr, clusterName, brokerName, brokerAddr, isCleanLivingBroker);
    }

    public MQClientInstance getMqClientInstance() {
        return this.mqClientInstance;
    }

    static {
        SYSTEM_GROUP_SET.add("DEFAULT_CONSUMER");
        SYSTEM_GROUP_SET.add("DEFAULT_PRODUCER");
        SYSTEM_GROUP_SET.add("TOOLS_CONSUMER");
        SYSTEM_GROUP_SET.add("SCHEDULE_CONSUMER");
        SYSTEM_GROUP_SET.add("FILTERSRV_CONSUMER");
        SYSTEM_GROUP_SET.add("__MONITOR_CONSUMER");
        SYSTEM_GROUP_SET.add("CLIENT_INNER_PRODUCER");
        SYSTEM_GROUP_SET.add("SELF_TEST_P_GROUP");
        SYSTEM_GROUP_SET.add("SELF_TEST_C_GROUP");
        SYSTEM_GROUP_SET.add("CID_ONS-HTTP-PROXY");
        SYSTEM_GROUP_SET.add("CID_ONSAPI_PERMISSION");
        SYSTEM_GROUP_SET.add("CID_ONSAPI_OWNER");
        SYSTEM_GROUP_SET.add("CID_ONSAPI_PULL");
        SYSTEM_GROUP_SET.add("CID_RMQ_SYS_TRANS");
    }
}

