/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.processor;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.longpolling.NotificationRequest;
import org.apache.rocketmq.common.AbstractBrokerRunnable;
import org.apache.rocketmq.common.BrokerIdentity;
import org.apache.rocketmq.common.KeyBuilder;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.constant.PermName;
import org.apache.rocketmq.common.help.FAQUrl;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.netty.NettyRemotingAbstract;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.netty.RequestTask;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.header.NotificationRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.NotificationResponseHeader;
import org.apache.rocketmq.remoting.protocol.subscription.SubscriptionGroupConfig;

public class NotificationProcessor
implements NettyRequestProcessor {
    private static final Logger POP_LOGGER = LoggerFactory.getLogger((String)"RocketmqPop");
    private final BrokerController brokerController;
    private Random random = new Random(System.currentTimeMillis());
    private static final String BORN_TIME = "bornTime";
    private ConcurrentLinkedHashMap<String, ArrayBlockingQueue<NotificationRequest>> pollingMap = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(100000L).build();
    private Thread checkNotificationPollingThread;

    public NotificationProcessor(BrokerController brokerController) {
        this.brokerController = brokerController;
        this.checkNotificationPollingThread = new Thread((Runnable)new AbstractBrokerRunnable((BrokerIdentity)brokerController.getBrokerConfig()){

            public void run0() {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        Thread.sleep(200L);
                        Collection pops = NotificationProcessor.this.pollingMap.values();
                        for (ArrayBlockingQueue popQ : pops) {
                            NotificationRequest tmPopRequest = (NotificationRequest)popQ.peek();
                            while (tmPopRequest != null && tmPopRequest.isTimeout() && (tmPopRequest = (NotificationRequest)popQ.poll()) != null) {
                                POP_LOGGER.info("timeout , wakeUp Notification : {}", (Object)tmPopRequest);
                                NotificationProcessor.this.wakeUp(tmPopRequest);
                                tmPopRequest = (NotificationRequest)popQ.peek();
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    catch (Exception e) {
                        POP_LOGGER.error("checkNotificationPolling error", (Throwable)e);
                    }
                }
            }
        });
        this.checkNotificationPollingThread.setDaemon(true);
        this.checkNotificationPollingThread.setName("checkNotificationPolling");
        this.checkNotificationPollingThread.start();
    }

    public void shutdown() {
        this.checkNotificationPollingThread.interrupt();
    }

    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        request.addExtField(BORN_TIME, String.valueOf(System.currentTimeMillis()));
        return this.processRequest(ctx.channel(), request);
    }

    public boolean rejectRequest() {
        return false;
    }

    public void notifyMessageArriving(String topic, int queueId) {
        this.notifyMessageArrivingForQueue(topic, -1);
        if (queueId > 0) {
            this.notifyMessageArrivingForQueue(topic, queueId);
        }
    }

    public void notifyMessageArrivingForQueue(String topic, int queueId) {
        ArrayBlockingQueue remotingCommands = (ArrayBlockingQueue)this.pollingMap.get((Object)KeyBuilder.buildPollingNotificationKey((String)topic, (int)queueId));
        if (remotingCommands != null) {
            ArrayList c = new ArrayList();
            remotingCommands.drainTo(c);
            for (NotificationRequest notificationRequest : c) {
                POP_LOGGER.info("new msg arrive , wakeUp : {}", (Object)notificationRequest);
                this.wakeUp(notificationRequest);
            }
        }
    }

    private void wakeUp(NotificationRequest request) {
        if (request == null || !request.complete()) {
            return;
        }
        if (!request.getChannel().isActive()) {
            return;
        }
        Runnable run = () -> {
            try {
                RemotingCommand response = this.processRequest(request.getChannel(), request.getRemotingCommand());
                if (response != null) {
                    response.setOpaque(request.getRemotingCommand().getOpaque());
                    response.markResponseType();
                    NettyRemotingAbstract.writeResponse((Channel)request.getChannel(), (RemotingCommand)request.getRemotingCommand(), (RemotingCommand)response, future -> {
                        if (!future.isSuccess()) {
                            POP_LOGGER.error("ProcessRequestWrapper response to {} failed", (Object)request.getChannel().remoteAddress(), (Object)future.cause());
                            POP_LOGGER.error(request.toString());
                            POP_LOGGER.error(response.toString());
                        }
                    });
                }
            }
            catch (RemotingCommandException e) {
                POP_LOGGER.error("ExecuteRequestWhenWakeup run", (Throwable)e);
            }
        };
        this.brokerController.getPullMessageExecutor().submit((Runnable)new RequestTask(run, request.getChannel(), request.getRemotingCommand()));
    }

    private RemotingCommand processRequest(Channel channel, RemotingCommand request) throws RemotingCommandException {
        int queueId;
        int i;
        TopicConfig retryTopicConfig;
        boolean needRetry;
        RemotingCommand response = RemotingCommand.createResponseCommand(NotificationResponseHeader.class);
        NotificationResponseHeader responseHeader = (NotificationResponseHeader)response.readCustomHeader();
        NotificationRequestHeader requestHeader = (NotificationRequestHeader)request.decodeCommandCustomHeader(NotificationRequestHeader.class);
        response.setOpaque(request.getOpaque());
        if (!PermName.isReadable((int)this.brokerController.getBrokerConfig().getBrokerPermission())) {
            response.setCode(16);
            response.setRemark(String.format("the broker[%s] peeking message is forbidden", this.brokerController.getBrokerConfig().getBrokerIP1()));
            return response;
        }
        TopicConfig topicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(requestHeader.getTopic());
        if (null == topicConfig) {
            POP_LOGGER.error("The topic {} not exist, consumer: {} ", (Object)requestHeader.getTopic(), (Object)RemotingHelper.parseChannelRemoteAddr((Channel)channel));
            response.setCode(17);
            response.setRemark(String.format("topic[%s] not exist, apply first please! %s", requestHeader.getTopic(), FAQUrl.suggestTodo((String)"https://rocketmq.apache.org/docs/bestPractice/06FAQ")));
            return response;
        }
        if (!PermName.isReadable((int)topicConfig.getPerm())) {
            response.setCode(16);
            response.setRemark("the topic[" + requestHeader.getTopic() + "] peeking message is forbidden");
            return response;
        }
        if (requestHeader.getQueueId() >= topicConfig.getReadQueueNums()) {
            String errorInfo = String.format("queueId[%d] is illegal, topic:[%s] topicConfig.readQueueNums:[%d] consumer:[%s]", requestHeader.getQueueId(), requestHeader.getTopic(), topicConfig.getReadQueueNums(), channel.remoteAddress());
            POP_LOGGER.warn(errorInfo);
            response.setCode(1);
            response.setRemark(errorInfo);
            return response;
        }
        SubscriptionGroupConfig subscriptionGroupConfig = this.brokerController.getSubscriptionGroupManager().findSubscriptionGroupConfig(requestHeader.getConsumerGroup());
        if (null == subscriptionGroupConfig) {
            response.setCode(26);
            response.setRemark(String.format("subscription group [%s] does not exist, %s", requestHeader.getConsumerGroup(), FAQUrl.suggestTodo((String)"https://rocketmq.apache.org/docs/bestPractice/06FAQ")));
            return response;
        }
        if (!subscriptionGroupConfig.isConsumeEnable()) {
            response.setCode(16);
            response.setRemark("subscription group no permission, " + requestHeader.getConsumerGroup());
            return response;
        }
        int randomQ = this.random.nextInt(100);
        boolean hasMsg = false;
        boolean bl = needRetry = randomQ % 5 == 0;
        if (needRetry && (retryTopicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(KeyBuilder.buildPopRetryTopic((String)requestHeader.getTopic(), (String)requestHeader.getConsumerGroup()))) != null) {
            for (i = 0; i < retryTopicConfig.getReadQueueNums() && !(hasMsg = this.hasMsgFromQueue(true, requestHeader, queueId = (randomQ + i) % retryTopicConfig.getReadQueueNums())); ++i) {
            }
        }
        if (!hasMsg) {
            if (requestHeader.getQueueId() < 0) {
                int queueId2;
                for (int i2 = 0; i2 < topicConfig.getReadQueueNums() && !(hasMsg = this.hasMsgFromQueue(false, requestHeader, queueId2 = (randomQ + i2) % topicConfig.getReadQueueNums())); ++i2) {
                }
            } else {
                int queueId3 = requestHeader.getQueueId();
                hasMsg = this.hasMsgFromQueue(false, requestHeader, queueId3);
            }
            if (!needRetry && !hasMsg && (retryTopicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(KeyBuilder.buildPopRetryTopic((String)requestHeader.getTopic(), (String)requestHeader.getConsumerGroup()))) != null) {
                for (i = 0; i < retryTopicConfig.getReadQueueNums() && !(hasMsg = this.hasMsgFromQueue(true, requestHeader, queueId = (randomQ + i) % retryTopicConfig.getReadQueueNums())); ++i) {
                }
            }
        }
        if (!hasMsg && this.polling(channel, request, requestHeader)) {
            return null;
        }
        response.setCode(0);
        responseHeader.setHasMsg(hasMsg);
        return response;
    }

    private boolean hasMsgFromQueue(boolean isRetry, NotificationRequestHeader requestHeader, int queueId) {
        if (this.brokerController.getConsumerOrderInfoManager().checkBlock(requestHeader.getTopic(), requestHeader.getConsumerGroup(), queueId, 0L)) {
            return false;
        }
        String topic = isRetry ? KeyBuilder.buildPopRetryTopic((String)requestHeader.getTopic(), (String)requestHeader.getConsumerGroup()) : requestHeader.getTopic();
        long offset = this.getPopOffset(topic, requestHeader.getConsumerGroup(), queueId);
        long restNum = this.brokerController.getMessageStore().getMaxOffsetInQueue(topic, queueId) - offset;
        return restNum > 0L;
    }

    private long getPopOffset(String topic, String cid, int queueId) {
        long bufferOffset;
        long offset = this.brokerController.getConsumerOffsetManager().queryOffset(cid, topic, queueId);
        if (offset < 0L) {
            offset = this.brokerController.getMessageStore().getMinOffsetInQueue(topic, queueId);
        }
        if ((bufferOffset = this.brokerController.getPopMessageProcessor().getPopBufferMergeService().getLatestOffset(topic, cid, queueId)) < 0L) {
            return offset;
        }
        return bufferOffset > offset ? bufferOffset : offset;
    }

    private boolean polling(Channel channel, RemotingCommand remotingCommand, NotificationRequestHeader requestHeader) {
        if (requestHeader.getPollTime() <= 0L) {
            return false;
        }
        long expired = requestHeader.getBornTime() + requestHeader.getPollTime();
        NotificationRequest request = new NotificationRequest(remotingCommand, channel, expired);
        boolean result = false;
        if (!request.isTimeout()) {
            String key = KeyBuilder.buildPollingNotificationKey((String)requestHeader.getTopic(), (int)requestHeader.getQueueId());
            ArrayBlockingQueue<NotificationRequest> queue = (ArrayBlockingQueue<NotificationRequest>)this.pollingMap.get((Object)key);
            if (queue == null) {
                queue = new ArrayBlockingQueue<NotificationRequest>(this.brokerController.getBrokerConfig().getPopPollingSize());
                this.pollingMap.put((Object)key, queue);
                result = queue.offer(request);
            } else {
                result = queue.offer(request);
            }
        }
        POP_LOGGER.info("polling {}, result {}", (Object)remotingCommand, (Object)result);
        return result;
    }
}

