/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.example.benchmark;

import java.util.LinkedList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.UtilAll;

class StatsBenchmarkBatchProducer {
    private final LongAdder sendRequestSuccessCount = new LongAdder();
    private final LongAdder sendRequestFailedCount = new LongAdder();
    private final LongAdder sendMessageSuccessTimeTotal = new LongAdder();
    private final AtomicLong sendMessageMaxRT = new AtomicLong(0L);
    private final LongAdder sendMessageSuccessCount = new LongAdder();
    private final LongAdder sendMessageFailedCount = new LongAdder();
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new ThreadFactoryImpl("BenchmarkTimerThread", Boolean.TRUE.booleanValue()));
    private final LinkedList<Long[]> snapshotList = new LinkedList();

    StatsBenchmarkBatchProducer() {
    }

    public Long[] createSnapshot() {
        Long[] snap = new Long[]{System.currentTimeMillis(), this.sendRequestSuccessCount.longValue(), this.sendRequestFailedCount.longValue(), this.sendMessageSuccessCount.longValue(), this.sendMessageFailedCount.longValue(), this.sendMessageSuccessTimeTotal.longValue()};
        return snap;
    }

    public LongAdder getSendRequestSuccessCount() {
        return this.sendRequestSuccessCount;
    }

    public LongAdder getSendRequestFailedCount() {
        return this.sendRequestFailedCount;
    }

    public LongAdder getSendMessageSuccessTimeTotal() {
        return this.sendMessageSuccessTimeTotal;
    }

    public AtomicLong getSendMessageMaxRT() {
        return this.sendMessageMaxRT;
    }

    public LongAdder getSendMessageSuccessCount() {
        return this.sendMessageSuccessCount;
    }

    public LongAdder getSendMessageFailedCount() {
        return this.sendMessageFailedCount;
    }

    public void start() {
        this.executorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                StatsBenchmarkBatchProducer.this.snapshotList.addLast(StatsBenchmarkBatchProducer.this.createSnapshot());
                if (StatsBenchmarkBatchProducer.this.snapshotList.size() > 10) {
                    StatsBenchmarkBatchProducer.this.snapshotList.removeFirst();
                }
            }
        }, 1000L, 1000L, TimeUnit.MILLISECONDS);
        this.executorService.scheduleAtFixedRate(new Runnable(){

            private void printStats() {
                if (StatsBenchmarkBatchProducer.this.snapshotList.size() >= 10) {
                    Long[] begin = (Long[])StatsBenchmarkBatchProducer.this.snapshotList.getFirst();
                    Long[] end = (Long[])StatsBenchmarkBatchProducer.this.snapshotList.getLast();
                    long sendTps = (long)((double)(end[1] - begin[1]) / (double)(end[0] - begin[0]) * 1000.0);
                    long sendMps = (long)((double)(end[3] - begin[3]) / (double)(end[0] - begin[0]) * 1000.0);
                    double averageRT = (double)(end[5] - begin[5]) / (double)(end[1] - begin[1]);
                    double averageMsgRT = (double)(end[5] - begin[5]) / (double)(end[3] - begin[3]);
                    System.out.printf("Current Time: %s | Send TPS: %d | Send MPS: %d | Max RT(ms): %d | Average RT(ms): %7.3f | Average Message RT(ms): %7.3f | Send Failed: %d | Send Message Failed: %d%n", UtilAll.timeMillisToHumanString2((long)System.currentTimeMillis()), sendTps, sendMps, StatsBenchmarkBatchProducer.this.getSendMessageMaxRT().longValue(), averageRT, averageMsgRT, end[2], end[4]);
                }
            }

            @Override
            public void run() {
                try {
                    this.printStats();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, 10000L, 10000L, TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

