/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.offset;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.offset.ConsumerOffsetManager;
import org.apache.rocketmq.broker.offset.RocksDBOffsetSerializeWrapper;
import org.apache.rocketmq.common.config.RocksDBConfigManager;
import org.apache.rocketmq.common.utils.DataConverter;
import org.rocksdb.WriteBatch;

public class RocksDBConsumerOffsetManager
extends ConsumerOffsetManager {
    public RocksDBConsumerOffsetManager(BrokerController brokerController) {
        super(brokerController);
        this.rocksDBConfigManager = new RocksDBConfigManager(brokerController.getMessageStoreConfig().getMemTableFlushIntervalMs());
    }

    public boolean load() {
        return this.rocksDBConfigManager.load(this.configFilePath(), this::decode0);
    }

    public boolean stop() {
        return this.rocksDBConfigManager.stop();
    }

    @Override
    protected void removeConsumerOffset(String topicAtGroup) {
        try {
            byte[] keyBytes = topicAtGroup.getBytes(DataConverter.CHARSET_UTF8);
            this.rocksDBConfigManager.delete(keyBytes);
        }
        catch (Exception e) {
            LOG.error("kv remove consumerOffset Failed, {}", (Object)topicAtGroup);
        }
    }

    protected void decode0(byte[] key, byte[] body) {
        String topicAtGroup = new String(key, DataConverter.CHARSET_UTF8);
        RocksDBOffsetSerializeWrapper wrapper = (RocksDBOffsetSerializeWrapper)((Object)JSON.parseObject((byte[])body, RocksDBOffsetSerializeWrapper.class, (Feature[])new Feature[0]));
        this.offsetTable.put(topicAtGroup, wrapper.getOffsetTable());
        LOG.info("load exist local offset, {}, {}", (Object)topicAtGroup, wrapper.getOffsetTable());
    }

    @Override
    public String configFilePath() {
        return this.brokerController.getMessageStoreConfig().getStorePathRootDir() + File.separator + "config" + File.separator + "consumerOffsets" + File.separator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void persist() {
        try (WriteBatch writeBatch = new WriteBatch();){
            for (Map.Entry entry : this.offsetTable.entrySet()) {
                this.putWriteBatch(writeBatch, (String)entry.getKey(), (ConcurrentMap)entry.getValue());
                if (writeBatch.getDataSize() < 4096L) continue;
                this.rocksDBConfigManager.batchPutWithWal(writeBatch);
            }
            this.rocksDBConfigManager.batchPutWithWal(writeBatch);
            this.rocksDBConfigManager.flushWAL();
        }
    }

    private void putWriteBatch(WriteBatch writeBatch, String topicGroupName, ConcurrentMap<Integer, Long> offsetMap) throws Exception {
        byte[] keyBytes = topicGroupName.getBytes(DataConverter.CHARSET_UTF8);
        RocksDBOffsetSerializeWrapper wrapper = new RocksDBOffsetSerializeWrapper();
        wrapper.setOffsetTable(offsetMap);
        byte[] valueBytes = JSON.toJSONBytes((Object)((Object)wrapper), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.BrowserCompatible});
        writeBatch.put(keyBytes, valueBytes);
    }
}

