/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.common;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.rocketmq.store.SelectMappedBufferResult;

public class SelectBufferResultWrapper {
    private final SelectMappedBufferResult result;
    private final long offset;
    private final long tagCode;
    private final AtomicInteger accessCount;

    public SelectBufferResultWrapper(SelectMappedBufferResult result, long offset, long tagCode, boolean used) {
        this.result = result;
        this.offset = offset;
        this.tagCode = tagCode;
        this.accessCount = new AtomicInteger(used ? 1 : 0);
    }

    public SelectMappedBufferResult getDuplicateResult() {
        return new SelectMappedBufferResult(this.result.getStartOffset(), this.result.getByteBuffer().asReadOnlyBuffer(), this.result.getSize(), this.result.getMappedFile());
    }

    public long getOffset() {
        return this.offset;
    }

    public int getBufferSize() {
        return this.result.getSize();
    }

    public long getTagCode() {
        return this.tagCode;
    }

    public int incrementAndGet() {
        return this.accessCount.incrementAndGet();
    }

    public int getAccessCount() {
        return this.accessCount.get();
    }
}

