/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.namesrv.processor;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.MQVersion;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.namesrv.NamesrvController;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.protocol.DataVersion;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.body.BrokerMemberGroup;
import org.apache.rocketmq.remoting.protocol.body.GetBrokerMemberGroupResponseBody;
import org.apache.rocketmq.remoting.protocol.body.RegisterBrokerBody;
import org.apache.rocketmq.remoting.protocol.body.TopicConfigSerializeWrapper;
import org.apache.rocketmq.remoting.protocol.body.TopicList;
import org.apache.rocketmq.remoting.protocol.header.GetBrokerMemberGroupRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.GetTopicsByClusterRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.namesrv.AddWritePermOfBrokerRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.namesrv.AddWritePermOfBrokerResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.namesrv.BrokerHeartbeatRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.namesrv.DeleteKVConfigRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.namesrv.DeleteTopicFromNamesrvRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.namesrv.GetKVConfigRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.namesrv.GetKVConfigResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.namesrv.GetKVListByNamespaceRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.namesrv.PutKVConfigRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.namesrv.QueryDataVersionRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.namesrv.QueryDataVersionResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.namesrv.RegisterBrokerRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.namesrv.RegisterBrokerResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.namesrv.RegisterTopicRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.namesrv.UnRegisterBrokerRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.namesrv.WipeWritePermOfBrokerRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.namesrv.WipeWritePermOfBrokerResponseHeader;
import org.apache.rocketmq.remoting.protocol.namesrv.RegisterBrokerResult;
import org.apache.rocketmq.remoting.protocol.route.TopicRouteData;

public class DefaultRequestProcessor
implements NettyRequestProcessor {
    private static Logger log = LoggerFactory.getLogger((String)"RocketmqNamesrv");
    protected final NamesrvController namesrvController;
    protected Set<String> configBlackList = new HashSet<String>();

    public DefaultRequestProcessor(NamesrvController namesrvController) {
        this.namesrvController = namesrvController;
        this.initConfigBlackList();
    }

    private void initConfigBlackList() {
        this.configBlackList.add("configBlackList");
        this.configBlackList.add("configStorePath");
        this.configBlackList.add("kvConfigPath");
        this.configBlackList.add("rocketmqHome");
        String[] configArray = this.namesrvController.getNamesrvConfig().getConfigBlackList().split(";");
        this.configBlackList.addAll(Arrays.asList(configArray));
    }

    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        if (ctx != null) {
            log.debug("receive request, {} {} {}", new Object[]{request.getCode(), RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()), request});
        }
        switch (request.getCode()) {
            case 100: {
                return this.putKVConfig(ctx, request);
            }
            case 101: {
                return this.getKVConfig(ctx, request);
            }
            case 102: {
                return this.deleteKVConfig(ctx, request);
            }
            case 322: {
                return this.queryBrokerTopicConfig(ctx, request);
            }
            case 103: {
                return this.registerBroker(ctx, request);
            }
            case 104: {
                return this.unregisterBroker(ctx, request);
            }
            case 904: {
                return this.brokerHeartbeat(ctx, request);
            }
            case 901: {
                return this.getBrokerMemberGroup(ctx, request);
            }
            case 106: {
                return this.getBrokerClusterInfo(ctx, request);
            }
            case 205: {
                return this.wipeWritePermOfBroker(ctx, request);
            }
            case 327: {
                return this.addWritePermOfBroker(ctx, request);
            }
            case 206: {
                return this.getAllTopicListFromNameserver(ctx, request);
            }
            case 216: {
                return this.deleteTopicInNamesrv(ctx, request);
            }
            case 217: {
                return this.registerTopicToNamesrv(ctx, request);
            }
            case 219: {
                return this.getKVListByNamespace(ctx, request);
            }
            case 224: {
                return this.getTopicsByCluster(ctx, request);
            }
            case 304: {
                return this.getSystemTopicListFromNs(ctx, request);
            }
            case 311: {
                return this.getUnitTopicList(ctx, request);
            }
            case 312: {
                return this.getHasUnitSubTopicList(ctx, request);
            }
            case 313: {
                return this.getHasUnitSubUnUnitTopicList(ctx, request);
            }
            case 318: {
                return this.updateConfig(ctx, request);
            }
            case 319: {
                return this.getConfig(ctx, request);
            }
        }
        String error = " request type " + request.getCode() + " not supported";
        return RemotingCommand.createResponseCommand((int)3, (String)error);
    }

    public boolean rejectRequest() {
        return false;
    }

    public RemotingCommand putKVConfig(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        PutKVConfigRequestHeader requestHeader = (PutKVConfigRequestHeader)request.decodeCommandCustomHeader(PutKVConfigRequestHeader.class);
        if (requestHeader.getNamespace() == null || requestHeader.getKey() == null) {
            response.setCode(1);
            response.setRemark("namespace or key is null");
            return response;
        }
        this.namesrvController.getKvConfigManager().putKVConfig(requestHeader.getNamespace(), requestHeader.getKey(), requestHeader.getValue());
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    public RemotingCommand getKVConfig(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(GetKVConfigResponseHeader.class);
        GetKVConfigResponseHeader responseHeader = (GetKVConfigResponseHeader)response.readCustomHeader();
        GetKVConfigRequestHeader requestHeader = (GetKVConfigRequestHeader)request.decodeCommandCustomHeader(GetKVConfigRequestHeader.class);
        String value = this.namesrvController.getKvConfigManager().getKVConfig(requestHeader.getNamespace(), requestHeader.getKey());
        if (value != null) {
            responseHeader.setValue(value);
            response.setCode(0);
            response.setRemark(null);
            return response;
        }
        response.setCode(22);
        response.setRemark("No config item, Namespace: " + requestHeader.getNamespace() + " Key: " + requestHeader.getKey());
        return response;
    }

    public RemotingCommand deleteKVConfig(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        DeleteKVConfigRequestHeader requestHeader = (DeleteKVConfigRequestHeader)request.decodeCommandCustomHeader(DeleteKVConfigRequestHeader.class);
        this.namesrvController.getKvConfigManager().deleteKVConfig(requestHeader.getNamespace(), requestHeader.getKey());
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    public RemotingCommand registerBroker(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(RegisterBrokerResponseHeader.class);
        RegisterBrokerResponseHeader responseHeader = (RegisterBrokerResponseHeader)response.readCustomHeader();
        RegisterBrokerRequestHeader requestHeader = (RegisterBrokerRequestHeader)request.decodeCommandCustomHeader(RegisterBrokerRequestHeader.class);
        if (!this.checksum(ctx, request, requestHeader)) {
            response.setCode(1);
            response.setRemark("crc32 not match");
            return response;
        }
        TopicConfigSerializeWrapper topicConfigWrapper = null;
        List filterServerList = null;
        MQVersion.Version brokerVersion = MQVersion.value2Version((int)request.getVersion());
        if (brokerVersion.ordinal() >= MQVersion.Version.V3_0_11.ordinal()) {
            RegisterBrokerBody registerBrokerBody = this.extractRegisterBrokerBodyFromRequest(request, requestHeader);
            topicConfigWrapper = registerBrokerBody.getTopicConfigSerializeWrapper();
            filterServerList = registerBrokerBody.getFilterServerList();
        } else {
            topicConfigWrapper = this.extractRegisterTopicConfigFromRequest(request);
        }
        RegisterBrokerResult result = this.namesrvController.getRouteInfoManager().registerBroker(requestHeader.getClusterName(), requestHeader.getBrokerAddr(), requestHeader.getBrokerName(), requestHeader.getBrokerId(), requestHeader.getHaServerAddr(), (String)request.getExtFields().get("__ZONE_NAME"), requestHeader.getHeartbeatTimeoutMillis(), requestHeader.getEnableActingMaster(), topicConfigWrapper, filterServerList, ctx.channel());
        if (result == null) {
            response.setCode(1);
            response.setRemark("register broker failed");
            return response;
        }
        responseHeader.setHaServerAddr(result.getHaServerAddr());
        responseHeader.setMasterAddr(result.getMasterAddr());
        if (this.namesrvController.getNamesrvConfig().isReturnOrderTopicConfigToBroker()) {
            byte[] jsonValue = this.namesrvController.getKvConfigManager().getKVListByNamespace("ORDER_TOPIC_CONFIG");
            response.setBody(jsonValue);
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private TopicConfigSerializeWrapper extractRegisterTopicConfigFromRequest(RemotingCommand request) {
        TopicConfigSerializeWrapper topicConfigWrapper;
        if (request.getBody() != null) {
            topicConfigWrapper = (TopicConfigSerializeWrapper)TopicConfigSerializeWrapper.decode((byte[])request.getBody(), TopicConfigSerializeWrapper.class);
        } else {
            topicConfigWrapper = new TopicConfigSerializeWrapper();
            topicConfigWrapper.getDataVersion().setCounter(new AtomicLong(0L));
            topicConfigWrapper.getDataVersion().setTimestamp(0L);
            topicConfigWrapper.getDataVersion().setStateVersion(0L);
        }
        return topicConfigWrapper;
    }

    private RegisterBrokerBody extractRegisterBrokerBodyFromRequest(RemotingCommand request, RegisterBrokerRequestHeader requestHeader) throws RemotingCommandException {
        RegisterBrokerBody registerBrokerBody = new RegisterBrokerBody();
        if (request.getBody() != null) {
            try {
                MQVersion.Version brokerVersion = MQVersion.value2Version((int)request.getVersion());
                registerBrokerBody = RegisterBrokerBody.decode((byte[])request.getBody(), (boolean)requestHeader.isCompressed(), (MQVersion.Version)brokerVersion);
            }
            catch (Exception e) {
                throw new RemotingCommandException("Failed to decode RegisterBrokerBody", (Throwable)e);
            }
        } else {
            registerBrokerBody.getTopicConfigSerializeWrapper().getDataVersion().setCounter(new AtomicLong(0L));
            registerBrokerBody.getTopicConfigSerializeWrapper().getDataVersion().setTimestamp(0L);
            registerBrokerBody.getTopicConfigSerializeWrapper().getDataVersion().setStateVersion(0L);
        }
        return registerBrokerBody;
    }

    private RemotingCommand getBrokerMemberGroup(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        GetBrokerMemberGroupRequestHeader requestHeader = (GetBrokerMemberGroupRequestHeader)request.decodeCommandCustomHeader(GetBrokerMemberGroupRequestHeader.class);
        BrokerMemberGroup memberGroup = this.namesrvController.getRouteInfoManager().getBrokerMemberGroup(requestHeader.getClusterName(), requestHeader.getBrokerName());
        GetBrokerMemberGroupResponseBody responseBody = new GetBrokerMemberGroupResponseBody();
        responseBody.setBrokerMemberGroup(memberGroup);
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        response.setCode(0);
        response.setBody(responseBody.encode());
        return response;
    }

    private boolean checksum(ChannelHandlerContext ctx, RemotingCommand request, RegisterBrokerRequestHeader requestHeader) {
        int crc32;
        if (requestHeader.getBodyCrc32() != 0 && (crc32 = UtilAll.crc32((byte[])request.getBody())) != requestHeader.getBodyCrc32()) {
            log.warn(String.format("receive registerBroker request,crc32 not match,from %s", RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel())));
            return false;
        }
        return true;
    }

    public RemotingCommand queryBrokerTopicConfig(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(QueryDataVersionResponseHeader.class);
        QueryDataVersionResponseHeader responseHeader = (QueryDataVersionResponseHeader)response.readCustomHeader();
        QueryDataVersionRequestHeader requestHeader = (QueryDataVersionRequestHeader)request.decodeCommandCustomHeader(QueryDataVersionRequestHeader.class);
        DataVersion dataVersion = (DataVersion)DataVersion.decode((byte[])request.getBody(), DataVersion.class);
        String clusterName = requestHeader.getClusterName();
        String brokerAddr = requestHeader.getBrokerAddr();
        Boolean changed = this.namesrvController.getRouteInfoManager().isBrokerTopicConfigChanged(clusterName, brokerAddr, dataVersion);
        this.namesrvController.getRouteInfoManager().updateBrokerInfoUpdateTimestamp(clusterName, brokerAddr);
        DataVersion nameSeverDataVersion = this.namesrvController.getRouteInfoManager().queryBrokerTopicConfig(clusterName, brokerAddr);
        response.setCode(0);
        response.setRemark(null);
        if (nameSeverDataVersion != null) {
            response.setBody(nameSeverDataVersion.encode());
        }
        responseHeader.setChanged(changed);
        return response;
    }

    public RemotingCommand unregisterBroker(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        UnRegisterBrokerRequestHeader requestHeader = (UnRegisterBrokerRequestHeader)request.decodeCommandCustomHeader(UnRegisterBrokerRequestHeader.class);
        if (!this.namesrvController.getRouteInfoManager().submitUnRegisterBrokerRequest(requestHeader)) {
            log.warn("Couldn't submit the unregister broker request to handler, broker info: {}", (Object)requestHeader);
            response.setCode(1);
            response.setRemark(null);
            return response;
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    public RemotingCommand brokerHeartbeat(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        BrokerHeartbeatRequestHeader requestHeader = (BrokerHeartbeatRequestHeader)request.decodeCommandCustomHeader(BrokerHeartbeatRequestHeader.class);
        this.namesrvController.getRouteInfoManager().updateBrokerInfoUpdateTimestamp(requestHeader.getClusterName(), requestHeader.getBrokerAddr());
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand getBrokerClusterInfo(ChannelHandlerContext ctx, RemotingCommand request) {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        byte[] content = this.namesrvController.getRouteInfoManager().getAllClusterInfo().encode();
        response.setBody(content);
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand wipeWritePermOfBroker(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(WipeWritePermOfBrokerResponseHeader.class);
        WipeWritePermOfBrokerResponseHeader responseHeader = (WipeWritePermOfBrokerResponseHeader)response.readCustomHeader();
        WipeWritePermOfBrokerRequestHeader requestHeader = (WipeWritePermOfBrokerRequestHeader)request.decodeCommandCustomHeader(WipeWritePermOfBrokerRequestHeader.class);
        int wipeTopicCnt = this.namesrvController.getRouteInfoManager().wipeWritePermOfBrokerByLock(requestHeader.getBrokerName());
        if (ctx != null) {
            log.info("wipe write perm of broker[{}], client: {}, {}", new Object[]{requestHeader.getBrokerName(), RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()), wipeTopicCnt});
        }
        responseHeader.setWipeTopicCount(Integer.valueOf(wipeTopicCnt));
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand addWritePermOfBroker(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(AddWritePermOfBrokerResponseHeader.class);
        AddWritePermOfBrokerResponseHeader responseHeader = (AddWritePermOfBrokerResponseHeader)response.readCustomHeader();
        AddWritePermOfBrokerRequestHeader requestHeader = (AddWritePermOfBrokerRequestHeader)request.decodeCommandCustomHeader(AddWritePermOfBrokerRequestHeader.class);
        int addTopicCnt = this.namesrvController.getRouteInfoManager().addWritePermOfBrokerByLock(requestHeader.getBrokerName());
        log.info("add write perm of broker[{}], client: {}, {}", new Object[]{requestHeader.getBrokerName(), RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()), addTopicCnt});
        responseHeader.setAddTopicCount(Integer.valueOf(addTopicCnt));
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand getAllTopicListFromNameserver(ChannelHandlerContext ctx, RemotingCommand request) {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        boolean enableAllTopicList = this.namesrvController.getNamesrvConfig().isEnableAllTopicList();
        log.warn("getAllTopicListFromNameserver {} enable {}", (Object)ctx.channel().remoteAddress(), (Object)enableAllTopicList);
        if (enableAllTopicList) {
            byte[] body = this.namesrvController.getRouteInfoManager().getAllTopicList().encode();
            response.setBody(body);
            response.setCode(0);
            response.setRemark(null);
        } else {
            response.setCode(1);
            response.setRemark("disable");
        }
        return response;
    }

    private RemotingCommand registerTopicToNamesrv(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        RegisterTopicRequestHeader requestHeader = (RegisterTopicRequestHeader)request.decodeCommandCustomHeader(RegisterTopicRequestHeader.class);
        TopicRouteData topicRouteData = (TopicRouteData)TopicRouteData.decode((byte[])request.getBody(), TopicRouteData.class);
        if (topicRouteData != null && topicRouteData.getQueueDatas() != null && !topicRouteData.getQueueDatas().isEmpty()) {
            this.namesrvController.getRouteInfoManager().registerTopic(requestHeader.getTopic(), topicRouteData.getQueueDatas());
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand deleteTopicInNamesrv(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        DeleteTopicFromNamesrvRequestHeader requestHeader = (DeleteTopicFromNamesrvRequestHeader)request.decodeCommandCustomHeader(DeleteTopicFromNamesrvRequestHeader.class);
        if (requestHeader.getClusterName() != null && !requestHeader.getClusterName().isEmpty()) {
            this.namesrvController.getRouteInfoManager().deleteTopic(requestHeader.getTopic(), requestHeader.getClusterName());
        } else {
            this.namesrvController.getRouteInfoManager().deleteTopic(requestHeader.getTopic());
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand getKVListByNamespace(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        GetKVListByNamespaceRequestHeader requestHeader = (GetKVListByNamespaceRequestHeader)request.decodeCommandCustomHeader(GetKVListByNamespaceRequestHeader.class);
        byte[] jsonValue = this.namesrvController.getKvConfigManager().getKVListByNamespace(requestHeader.getNamespace());
        if (null != jsonValue) {
            response.setBody(jsonValue);
            response.setCode(0);
            response.setRemark(null);
            return response;
        }
        response.setCode(22);
        response.setRemark("No config item, Namespace: " + requestHeader.getNamespace());
        return response;
    }

    private RemotingCommand getTopicsByCluster(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        boolean enableTopicList = this.namesrvController.getNamesrvConfig().isEnableTopicList();
        if (!enableTopicList) {
            response.setCode(1);
            response.setRemark("disable");
            return response;
        }
        GetTopicsByClusterRequestHeader requestHeader = (GetTopicsByClusterRequestHeader)request.decodeCommandCustomHeader(GetTopicsByClusterRequestHeader.class);
        TopicList topicsByCluster = this.namesrvController.getRouteInfoManager().getTopicsByCluster(requestHeader.getCluster());
        byte[] body = topicsByCluster.encode();
        response.setBody(body);
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand getSystemTopicListFromNs(ChannelHandlerContext ctx, RemotingCommand request) {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        TopicList systemTopicList = this.namesrvController.getRouteInfoManager().getSystemTopicList();
        byte[] body = systemTopicList.encode();
        response.setBody(body);
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand getUnitTopicList(ChannelHandlerContext ctx, RemotingCommand request) {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        boolean enableTopicList = this.namesrvController.getNamesrvConfig().isEnableTopicList();
        if (enableTopicList) {
            TopicList unitTopicList = this.namesrvController.getRouteInfoManager().getUnitTopics();
            byte[] body = unitTopicList.encode();
            response.setBody(body);
            response.setCode(0);
            response.setRemark(null);
        } else {
            response.setCode(1);
            response.setRemark("disable");
        }
        return response;
    }

    private RemotingCommand getHasUnitSubTopicList(ChannelHandlerContext ctx, RemotingCommand request) {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        boolean enableTopicList = this.namesrvController.getNamesrvConfig().isEnableTopicList();
        if (enableTopicList) {
            TopicList hasUnitSubTopicList = this.namesrvController.getRouteInfoManager().getHasUnitSubTopicList();
            byte[] body = hasUnitSubTopicList.encode();
            response.setBody(body);
            response.setCode(0);
            response.setRemark(null);
        } else {
            response.setCode(1);
            response.setRemark("disable");
        }
        return response;
    }

    private RemotingCommand getHasUnitSubUnUnitTopicList(ChannelHandlerContext ctx, RemotingCommand request) {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        boolean enableTopicList = this.namesrvController.getNamesrvConfig().isEnableTopicList();
        if (enableTopicList) {
            TopicList hasUnitSubUnUnitTopicList = this.namesrvController.getRouteInfoManager().getHasUnitSubUnUnitTopicList();
            byte[] body = hasUnitSubUnUnitTopicList.encode();
            response.setBody(body);
            response.setCode(0);
            response.setRemark(null);
        } else {
            response.setCode(1);
            response.setRemark("disable");
        }
        return response;
    }

    private RemotingCommand updateConfig(ChannelHandlerContext ctx, RemotingCommand request) {
        if (ctx != null) {
            log.info("updateConfig called by {}", (Object)RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()));
        }
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        byte[] body = request.getBody();
        if (body != null) {
            String bodyStr;
            try {
                bodyStr = new String(body, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error("updateConfig byte array to string error: ", (Throwable)e);
                response.setCode(1);
                response.setRemark("UnsupportedEncodingException " + e);
                return response;
            }
            Properties properties = MixAll.string2Properties((String)bodyStr);
            if (properties == null) {
                log.error("updateConfig MixAll.string2Properties error {}", (Object)bodyStr);
                response.setCode(1);
                response.setRemark("string2Properties error");
                return response;
            }
            if (this.validateBlackListConfigExist(properties)) {
                response.setCode(16);
                response.setRemark("Can not update config in black list.");
                return response;
            }
            this.namesrvController.getConfiguration().update(properties);
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand getConfig(ChannelHandlerContext ctx, RemotingCommand request) {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        String content = this.namesrvController.getConfiguration().getAllConfigsFormatString();
        if (StringUtils.isNotBlank((CharSequence)content)) {
            try {
                response.setBody(content.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                log.error("getConfig error, ", (Throwable)e);
                response.setCode(1);
                response.setRemark("UnsupportedEncodingException " + e);
                return response;
            }
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private boolean validateBlackListConfigExist(Properties properties) {
        for (String blackConfig : this.configBlackList) {
            if (!properties.containsKey(blackConfig)) continue;
            return true;
        }
        return false;
    }
}

