/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.rocketmq.producer;

import io.openmessaging.BytesMessage;
import io.openmessaging.KeyValue;
import io.openmessaging.Message;
import io.openmessaging.Promise;
import io.openmessaging.exception.OMSRuntimeException;
import io.openmessaging.interceptor.ProducerInterceptor;
import io.openmessaging.producer.BatchMessageSender;
import io.openmessaging.producer.LocalTransactionExecutor;
import io.openmessaging.producer.Producer;
import io.openmessaging.producer.SendResult;
import io.openmessaging.rocketmq.producer.AbstractOMSProducer;
import io.openmessaging.rocketmq.promise.DefaultPromise;
import io.openmessaging.rocketmq.utils.OMSUtil;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;

public class ProducerImpl
extends AbstractOMSProducer
implements Producer {
    private static final Logger log = LoggerFactory.getLogger(ProducerImpl.class);

    public ProducerImpl(KeyValue properties) {
        super(properties);
    }

    public KeyValue attributes() {
        return this.properties;
    }

    public SendResult send(Message message) {
        return this.send(message, this.rocketmqProducer.getSendMsgTimeout());
    }

    public SendResult send(Message message, KeyValue properties) {
        long timeout = properties.containsKey("TIMEOUT") ? (long)properties.getInt("TIMEOUT") : (long)this.rocketmqProducer.getSendMsgTimeout();
        return this.send(message, timeout);
    }

    public SendResult send(Message message, LocalTransactionExecutor branchExecutor, KeyValue attributes) {
        return null;
    }

    private SendResult send(Message message, long timeout) {
        this.checkMessageType(message);
        org.apache.rocketmq.common.message.Message rmqMessage = OMSUtil.msgConvert((BytesMessage)message);
        try {
            org.apache.rocketmq.client.producer.SendResult rmqResult = this.rocketmqProducer.send(rmqMessage, timeout);
            if (!rmqResult.getSendStatus().equals((Object)SendStatus.SEND_OK)) {
                log.error(String.format("Send message to RocketMQ failed, %s", message));
                throw new OMSRuntimeException("-1", "Send message to RocketMQ broker failed.");
            }
            message.sysHeaders().put("MESSAGE_ID", rmqResult.getMsgId());
            return OMSUtil.sendResultConvert(rmqResult);
        }
        catch (Exception e) {
            log.error(String.format("Send message to RocketMQ failed, %s", message), (Throwable)e);
            throw this.checkProducerException(rmqMessage.getTopic(), message.sysHeaders().getString("MESSAGE_ID"), e);
        }
    }

    public Promise<SendResult> sendAsync(Message message) {
        return this.sendAsync(message, this.rocketmqProducer.getSendMsgTimeout());
    }

    public Promise<SendResult> sendAsync(Message message, KeyValue properties) {
        long timeout = properties.containsKey("TIMEOUT") ? (long)properties.getInt("TIMEOUT") : (long)this.rocketmqProducer.getSendMsgTimeout();
        return this.sendAsync(message, timeout);
    }

    private Promise<SendResult> sendAsync(final Message message, long timeout) {
        this.checkMessageType(message);
        org.apache.rocketmq.common.message.Message rmqMessage = OMSUtil.msgConvert((BytesMessage)message);
        final DefaultPromise<SendResult> promise = new DefaultPromise<SendResult>();
        try {
            this.rocketmqProducer.send(rmqMessage, new SendCallback(){

                public void onSuccess(org.apache.rocketmq.client.producer.SendResult rmqResult) {
                    message.sysHeaders().put("MESSAGE_ID", rmqResult.getMsgId());
                    promise.set((Object)OMSUtil.sendResultConvert(rmqResult));
                }

                public void onException(Throwable e) {
                    promise.setFailure(e);
                }
            }, timeout);
        }
        catch (Exception e) {
            promise.setFailure(e);
        }
        return promise;
    }

    public void sendOneway(Message message) {
        this.checkMessageType(message);
        org.apache.rocketmq.common.message.Message rmqMessage = OMSUtil.msgConvert((BytesMessage)message);
        try {
            this.rocketmqProducer.sendOneway(rmqMessage);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendOneway(Message message, KeyValue properties) {
        this.sendOneway(message);
    }

    public BatchMessageSender createBatchMessageSender() {
        return null;
    }

    public void addInterceptor(ProducerInterceptor interceptor) {
    }

    public void removeInterceptor(ProducerInterceptor interceptor) {
    }
}

