/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.constant;

public class PermName {
    public static final int INDEX_PERM_PRIORITY = 3;
    public static final int INDEX_PERM_READ = 2;
    public static final int INDEX_PERM_WRITE = 1;
    public static final int INDEX_PERM_INHERIT = 0;
    public static final int PERM_PRIORITY = 8;
    public static final int PERM_READ = 4;
    public static final int PERM_WRITE = 2;
    public static final int PERM_INHERIT = 1;

    public static String perm2String(int perm) {
        StringBuilder sb = new StringBuilder("---");
        if (PermName.isReadable(perm)) {
            sb.replace(0, 1, "R");
        }
        if (PermName.isWriteable(perm)) {
            sb.replace(1, 2, "W");
        }
        if (PermName.isInherited(perm)) {
            sb.replace(2, 3, "X");
        }
        return sb.toString();
    }

    public static boolean isReadable(int perm) {
        return (perm & 4) == 4;
    }

    public static boolean isWriteable(int perm) {
        return (perm & 2) == 2;
    }

    public static boolean isInherited(int perm) {
        return (perm & 1) == 1;
    }

    public static boolean isValid(String perm) {
        return PermName.isValid(Integer.parseInt(perm));
    }

    public static boolean isValid(int perm) {
        return perm >= 0 && perm < 8;
    }

    public static boolean isPriority(int perm) {
        return (perm & 8) == 8;
    }

    public static boolean isAccessible(int perm) {
        return PermName.isReadable(perm) || PermName.isWriteable(perm);
    }
}

