/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.protocol;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.rocketmq.common.action.RocketMQAction;
import org.apache.rocketmq.remoting.CommandCustomHeader;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public class RequestHeaderRegistry {
    private static final String PACKAGE_NAME = "org.apache.rocketmq.remoting.protocol.header";
    private final Map<Integer, Class<? extends CommandCustomHeader>> requestHeaderMap = new HashMap<Integer, Class<? extends CommandCustomHeader>>();

    public static RequestHeaderRegistry getInstance() {
        return RequestHeaderRegistryHolder.INSTANCE;
    }

    public void initialize() {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)PACKAGE_NAME, (ClassLoader[])new ClassLoader[0])).setScanners(new Scanner[]{new SubTypesScanner(false)}));
        Set classes = reflections.getSubTypesOf(CommandCustomHeader.class);
        classes.forEach(this::registerHeader);
    }

    public Class<? extends CommandCustomHeader> getRequestHeader(int requestCode) {
        return this.requestHeaderMap.get(requestCode);
    }

    private void registerHeader(Class<? extends CommandCustomHeader> clazz) {
        if (!clazz.isAnnotationPresent(RocketMQAction.class)) {
            return;
        }
        RocketMQAction action = clazz.getAnnotation(RocketMQAction.class);
        this.requestHeaderMap.putIfAbsent(action.value(), clazz);
    }

    private static class RequestHeaderRegistryHolder {
        private static final RequestHeaderRegistry INSTANCE = new RequestHeaderRegistry();

        private RequestHeaderRegistryHolder() {
        }
    }
}

