/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.rocketmq;

import io.openmessaging.KeyValue;
import io.openmessaging.MessagingAccessPoint;
import io.openmessaging.ResourceManager;
import io.openmessaging.consumer.PullConsumer;
import io.openmessaging.consumer.PushConsumer;
import io.openmessaging.consumer.StreamingConsumer;
import io.openmessaging.exception.OMSNotSupportedException;
import io.openmessaging.producer.Producer;
import io.openmessaging.rocketmq.consumer.PullConsumerImpl;
import io.openmessaging.rocketmq.consumer.PushConsumerImpl;
import io.openmessaging.rocketmq.producer.ProducerImpl;
import io.openmessaging.rocketmq.utils.OMSUtil;

public class MessagingAccessPointImpl
implements MessagingAccessPoint {
    private final KeyValue accessPointProperties;

    public MessagingAccessPointImpl(KeyValue accessPointProperties) {
        this.accessPointProperties = accessPointProperties;
    }

    public KeyValue attributes() {
        return this.accessPointProperties;
    }

    public String implVersion() {
        return "0.3.0";
    }

    public Producer createProducer() {
        return new ProducerImpl(this.accessPointProperties);
    }

    public Producer createProducer(KeyValue properties) {
        return new ProducerImpl(OMSUtil.buildKeyValue(this.accessPointProperties, properties));
    }

    public PushConsumer createPushConsumer() {
        return new PushConsumerImpl(this.accessPointProperties);
    }

    public PushConsumer createPushConsumer(KeyValue properties) {
        return new PushConsumerImpl(OMSUtil.buildKeyValue(this.accessPointProperties, properties));
    }

    public PullConsumer createPullConsumer() {
        return new PullConsumerImpl(this.accessPointProperties);
    }

    public PullConsumer createPullConsumer(KeyValue attributes) {
        return new PullConsumerImpl(OMSUtil.buildKeyValue(this.accessPointProperties, attributes));
    }

    public StreamingConsumer createStreamingConsumer() {
        return null;
    }

    public StreamingConsumer createStreamingConsumer(KeyValue attributes) {
        return null;
    }

    public ResourceManager resourceManager() {
        throw new OMSNotSupportedException("-1", "ResourceManager is not supported in current version.");
    }

    public void startup() {
    }

    public void shutdown() {
    }
}

