/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.message;

import apache.rocketmq.v2.Resource;
import apache.rocketmq.v2.SystemProperties;
import com.google.protobuf.ByteString;
import com.google.protobuf.util.Timestamps;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.apache.rocketmq.client.apis.message.Message;
import org.apache.rocketmq.client.apis.message.MessageId;
import org.apache.rocketmq.client.java.impl.producer.ProducerSettings;
import org.apache.rocketmq.client.java.message.MessageIdCodec;
import org.apache.rocketmq.client.java.message.MessageImpl;
import org.apache.rocketmq.client.java.message.MessageType;
import org.apache.rocketmq.client.java.message.protocol.Encoding;
import org.apache.rocketmq.client.java.misc.Utilities;

public class PublishingMessageImpl
extends MessageImpl {
    private final MessageId messageId;
    private final MessageType messageType;
    private volatile String traceContext = null;

    public PublishingMessageImpl(Message message, ProducerSettings producerSettings, boolean txEnabled) throws IOException {
        super(message);
        int length = message.getBody().remaining();
        int maxBodySizeBytes = producerSettings.getMaxBodySizeBytes();
        if (length > maxBodySizeBytes) {
            throw new IOException("Message body size exceeds the threshold, max size=" + maxBodySizeBytes + " bytes");
        }
        this.messageId = MessageIdCodec.getInstance().nextMessageId();
        if (!(message.getMessageGroup().isPresent() || message.getDeliveryTimestamp().isPresent() || txEnabled)) {
            this.messageType = MessageType.NORMAL;
            return;
        }
        if (message.getMessageGroup().isPresent() && !txEnabled) {
            this.messageType = MessageType.FIFO;
            return;
        }
        if (message.getDeliveryTimestamp().isPresent() && !txEnabled) {
            this.messageType = MessageType.DELAY;
            return;
        }
        if (!message.getMessageGroup().isPresent() && !message.getDeliveryTimestamp().isPresent() && txEnabled) {
            this.messageType = MessageType.TRANSACTION;
            return;
        }
        throw new IllegalArgumentException("Transactional message should not set messageGroup or deliveryTimestamp");
    }

    public MessageId getMessageId() {
        return this.messageId;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public void setTraceContext(String traceContext) {
        this.traceContext = traceContext;
    }

    public Optional<String> getTraceContext() {
        return null == this.traceContext ? Optional.empty() : Optional.of(this.traceContext);
    }

    public apache.rocketmq.v2.Message toProtobuf() {
        SystemProperties.Builder systemPropertiesBuilder = SystemProperties.newBuilder().addAllKeys((Iterable)this.keys).setMessageId(this.messageId.toString()).setBornTimestamp(Timestamps.fromMillis((long)System.currentTimeMillis())).setBornHost(Utilities.hostName()).setBodyEncoding(Encoding.toProtobuf(Encoding.IDENTITY)).setMessageType(MessageType.toProtobuf(this.messageType));
        this.getTag().ifPresent(arg_0 -> ((SystemProperties.Builder)systemPropertiesBuilder).setTag(arg_0));
        this.getTraceContext().ifPresent(arg_0 -> ((SystemProperties.Builder)systemPropertiesBuilder).setTraceContext(arg_0));
        this.getDeliveryTimestamp().ifPresent(millis -> systemPropertiesBuilder.setDeliveryTimestamp(Timestamps.fromMillis((long)millis)));
        this.getMessageGroup().ifPresent(arg_0 -> ((SystemProperties.Builder)systemPropertiesBuilder).setMessageGroup(arg_0));
        SystemProperties systemProperties = systemPropertiesBuilder.build();
        Resource topicResource = Resource.newBuilder().setName(this.getTopic()).build();
        return apache.rocketmq.v2.Message.newBuilder().setTopic(topicResource).setBody(ByteString.copyFrom((ByteBuffer)this.getBody())).setSystemProperties(systemProperties).putAllUserProperties(this.getProperties()).build();
    }
}

