/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.hook;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.rocketmq.client.java.hook.Attribute;
import org.apache.rocketmq.client.java.hook.AttributeKey;
import org.apache.rocketmq.client.java.hook.MessageHookPoints;
import org.apache.rocketmq.client.java.hook.MessageHookPointsStatus;
import org.apache.rocketmq.client.java.hook.MessageInterceptor;
import org.apache.rocketmq.client.java.hook.MessageInterceptorContext;
import org.apache.rocketmq.client.java.hook.MessageInterceptorContextImpl;
import org.apache.rocketmq.client.java.message.GeneralMessage;
import org.apache.rocketmq.shaded.org.slf4j.Logger;
import org.apache.rocketmq.shaded.org.slf4j.LoggerFactory;

public class CompositedMessageInterceptor
implements MessageInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageInterceptor.class);
    private static final AttributeKey<Map<Integer, Map<AttributeKey, Attribute>>> INTERCEPTOR_ATTRIBUTES_KEY = AttributeKey.create("composited_interceptor_attributes");
    private final List<MessageInterceptor> interceptors;

    public CompositedMessageInterceptor(List<MessageInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    @Override
    public void doBefore(MessageInterceptorContext context0, List<GeneralMessage> messages) {
        HashMap<Integer, Map<AttributeKey, Attribute>> attributeMap = new HashMap<Integer, Map<AttributeKey, Attribute>>();
        for (int index = 0; index < this.interceptors.size(); ++index) {
            MessageInterceptor interceptor = this.interceptors.get(index);
            MessageHookPoints messageHookPoints = context0.getMessageHookPoints();
            MessageHookPointsStatus status = context0.getStatus();
            MessageInterceptorContextImpl context = new MessageInterceptorContextImpl(messageHookPoints, status);
            try {
                interceptor.doBefore(context, messages);
            }
            catch (Throwable t) {
                LOGGER.error("Exception raised while handing messages", t);
            }
            Map<AttributeKey, Attribute> attributes = context.getAttributes();
            attributeMap.put(index, attributes);
        }
        context0.putAttribute(INTERCEPTOR_ATTRIBUTES_KEY, Attribute.create(attributeMap));
    }

    @Override
    public void doAfter(MessageInterceptorContext context0, List<GeneralMessage> messages) {
        for (int index = this.interceptors.size() - 1; index >= 0; --index) {
            Map<Integer, Map<AttributeKey, Attribute>> attributeMap = context0.getAttribute(INTERCEPTOR_ATTRIBUTES_KEY).get();
            Map<AttributeKey, Attribute> attributes = attributeMap.get(index);
            MessageHookPoints messageHookPoints = context0.getMessageHookPoints();
            MessageHookPointsStatus status = context0.getStatus();
            MessageInterceptorContextImpl context = new MessageInterceptorContextImpl(messageHookPoints, status, attributes);
            MessageInterceptor interceptor = this.interceptors.get(index);
            try {
                interceptor.doAfter(context, messages);
                continue;
            }
            catch (Throwable t) {
                LOGGER.error("Exception raised while handing messages", t);
            }
        }
    }
}

