/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.sdk.logs.export;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.common.CompletableResultCode;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.logs.data.LogData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.logs.export.LogExporter;

final class MultiLogExporter
implements LogExporter {
    private static final Logger logger = Logger.getLogger(MultiLogExporter.class.getName());
    private final LogExporter[] logExporters;

    static LogExporter create(List<LogExporter> logExporters) {
        return new MultiLogExporter(logExporters.toArray(new LogExporter[0]));
    }

    @Override
    public CompletableResultCode export(Collection<LogData> logs) {
        ArrayList<CompletableResultCode> results = new ArrayList<CompletableResultCode>(this.logExporters.length);
        for (LogExporter logExporter : this.logExporters) {
            CompletableResultCode exportResult;
            try {
                exportResult = logExporter.export(logs);
            }
            catch (RuntimeException e) {
                logger.log(Level.WARNING, "Exception thrown by the export.", e);
                results.add(CompletableResultCode.ofFailure());
                continue;
            }
            results.add(exportResult);
        }
        return CompletableResultCode.ofAll(results);
    }

    @Override
    public CompletableResultCode flush() {
        ArrayList<CompletableResultCode> results = new ArrayList<CompletableResultCode>(this.logExporters.length);
        for (LogExporter logExporter : this.logExporters) {
            CompletableResultCode flushResult;
            try {
                flushResult = logExporter.flush();
            }
            catch (RuntimeException e) {
                logger.log(Level.WARNING, "Exception thrown by the flush.", e);
                results.add(CompletableResultCode.ofFailure());
                continue;
            }
            results.add(flushResult);
        }
        return CompletableResultCode.ofAll(results);
    }

    @Override
    public CompletableResultCode shutdown() {
        ArrayList<CompletableResultCode> results = new ArrayList<CompletableResultCode>(this.logExporters.length);
        for (LogExporter logExporter : this.logExporters) {
            CompletableResultCode shutdownResult;
            try {
                shutdownResult = logExporter.shutdown();
            }
            catch (RuntimeException e) {
                logger.log(Level.WARNING, "Exception thrown by the shutdown.", e);
                results.add(CompletableResultCode.ofFailure());
                continue;
            }
            results.add(shutdownResult);
        }
        return CompletableResultCode.ofAll(results);
    }

    private MultiLogExporter(LogExporter[] logExporters) {
        this.logExporters = logExporters;
    }
}

