/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl.consumer;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.apis.ClientException;
import org.apache.rocketmq.client.apis.consumer.FilterExpression;
import org.apache.rocketmq.client.apis.consumer.MessageListener;
import org.apache.rocketmq.client.apis.consumer.PushConsumer;
import org.apache.rocketmq.client.apis.consumer.PushConsumerBuilder;
import org.apache.rocketmq.client.java.impl.consumer.ConsumerImpl;
import org.apache.rocketmq.client.java.impl.consumer.PushConsumerImpl;

public class PushConsumerBuilderImpl
implements PushConsumerBuilder {
    private ClientConfiguration clientConfiguration = null;
    private String consumerGroup = null;
    private Map<String, FilterExpression> subscriptionExpressions = new ConcurrentHashMap<String, FilterExpression>();
    private MessageListener messageListener = null;
    private int maxCacheMessageCount = 1024;
    private int maxCacheMessageSizeInBytes = 0x4000000;
    private int consumptionThreadCount = 20;
    private boolean enableFifoConsumeAccelerator = false;

    public PushConsumerBuilder setClientConfiguration(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = (ClientConfiguration)Preconditions.checkNotNull((Object)clientConfiguration, (Object)"clientConfiguration should not be null");
        return this;
    }

    public PushConsumerBuilder setConsumerGroup(String consumerGroup) {
        Preconditions.checkNotNull((Object)consumerGroup, (Object)"consumerGroup should not be null");
        Preconditions.checkArgument((boolean)ConsumerImpl.CONSUMER_GROUP_PATTERN.matcher(consumerGroup).matches(), (String)"consumerGroup does not match the regex [regex=%s]", (Object)ConsumerImpl.CONSUMER_GROUP_PATTERN.pattern());
        this.consumerGroup = consumerGroup;
        return this;
    }

    public PushConsumerBuilder setSubscriptionExpressions(Map<String, FilterExpression> subscriptionExpressions) {
        Preconditions.checkNotNull(subscriptionExpressions, (Object)"subscriptionExpressions should not be null");
        Preconditions.checkArgument((!subscriptionExpressions.isEmpty() ? 1 : 0) != 0, (Object)"subscriptionExpressions should not be empty");
        this.subscriptionExpressions = subscriptionExpressions;
        return this;
    }

    public PushConsumerBuilder setMessageListener(MessageListener messageListener) {
        this.messageListener = (MessageListener)Preconditions.checkNotNull((Object)messageListener, (Object)"messageListener should not be null");
        return this;
    }

    public PushConsumerBuilder setMaxCacheMessageCount(int maxCachedMessageCount) {
        Preconditions.checkArgument((maxCachedMessageCount > 0 ? 1 : 0) != 0, (Object)"maxCachedMessageCount should be positive");
        this.maxCacheMessageCount = maxCachedMessageCount;
        return this;
    }

    public PushConsumerBuilder setMaxCacheMessageSizeInBytes(int maxCacheMessageSizeInBytes) {
        Preconditions.checkArgument((maxCacheMessageSizeInBytes > 0 ? 1 : 0) != 0, (Object)"maxCacheMessageSizeInBytes should be positive");
        this.maxCacheMessageSizeInBytes = maxCacheMessageSizeInBytes;
        return this;
    }

    public PushConsumerBuilder setConsumptionThreadCount(int consumptionThreadCount) {
        Preconditions.checkArgument((consumptionThreadCount > 0 ? 1 : 0) != 0, (Object)"consumptionThreadCount should be positive");
        this.consumptionThreadCount = consumptionThreadCount;
        return this;
    }

    public PushConsumerBuilder setEnableFifoConsumeAccelerator(boolean enableFifoConsumeAccelerator) {
        this.enableFifoConsumeAccelerator = enableFifoConsumeAccelerator;
        return this;
    }

    public PushConsumer build() throws ClientException {
        Preconditions.checkNotNull((Object)this.clientConfiguration, (Object)"clientConfiguration has not been set yet");
        Preconditions.checkNotNull((Object)this.consumerGroup, (Object)"consumerGroup has not been set yet");
        Preconditions.checkNotNull((Object)this.messageListener, (Object)"messageListener has not been set yet");
        Preconditions.checkArgument((!this.subscriptionExpressions.isEmpty() ? 1 : 0) != 0, (Object)"subscriptionExpressions have not been set yet");
        PushConsumerImpl pushConsumer = new PushConsumerImpl(this.clientConfiguration, this.consumerGroup, this.subscriptionExpressions, this.messageListener, this.maxCacheMessageCount, this.maxCacheMessageSizeInBytes, this.consumptionThreadCount, this.enableFifoConsumeAccelerator);
        pushConsumer.startAsync().awaitRunning();
        return pushConsumer;
    }
}

