/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.storage;

import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.rhea.errors.Errors;
import com.alipay.sofa.jraft.rhea.storage.KVOperation;
import com.alipay.sofa.jraft.rhea.storage.KVStoreClosure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KVClosureAdapter
implements KVStoreClosure {
    private static final Logger LOG = LoggerFactory.getLogger(KVClosureAdapter.class);
    private KVStoreClosure done;
    private KVOperation operation;

    public KVClosureAdapter(KVStoreClosure done, KVOperation operation) {
        this.done = done;
        this.operation = operation;
    }

    public KVStoreClosure getDone() {
        return this.done;
    }

    public KVOperation getOperation() {
        return this.operation;
    }

    public void run(Status status) {
        if (status.isOk()) {
            this.setError(Errors.NONE);
        } else {
            LOG.error("Fail status: {}.", (Object)status);
            if (this.getError() == null) {
                switch (status.getRaftError()) {
                    case SUCCESS: {
                        this.setError(Errors.NONE);
                        break;
                    }
                    case EINVAL: {
                        this.setError(Errors.INVALID_REQUEST);
                        break;
                    }
                    case EIO: {
                        this.setError(Errors.STORAGE_ERROR);
                        break;
                    }
                    default: {
                        this.setError(Errors.LEADER_NOT_AVAILABLE);
                    }
                }
            }
        }
        if (this.done != null) {
            this.done.run(status);
        }
        this.reset();
    }

    @Override
    public Errors getError() {
        if (this.done != null) {
            return this.done.getError();
        }
        return null;
    }

    @Override
    public void setError(Errors error) {
        if (this.done != null) {
            this.done.setError(error);
        }
    }

    @Override
    public Object getData() {
        if (this.done != null) {
            return this.done.getData();
        }
        return null;
    }

    @Override
    public void setData(Object data) {
        if (this.done != null) {
            this.done.setData(data);
        }
    }

    private void reset() {
        this.done = null;
        this.operation = null;
    }
}

