/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.common.util;

import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.mqtt.common.model.MqttTopic;

public class TopicUtils {
    public static String normalizeTopic(String topic) {
        if (StringUtils.isBlank((CharSequence)topic)) {
            return null;
        }
        if (!topic.contains("/")) {
            return topic;
        }
        if (!topic.endsWith("/")) {
            return topic + "/";
        }
        return topic;
    }

    public static String normalizeSecondTopic(String secondTopic) {
        if (StringUtils.isBlank((CharSequence)secondTopic)) {
            return null;
        }
        if (!secondTopic.startsWith("/")) {
            secondTopic = "/" + secondTopic;
        }
        if (!secondTopic.endsWith("/")) {
            return secondTopic + "/";
        }
        return secondTopic;
    }

    public static boolean isP2P(String secondTopic) {
        return secondTopic != null && secondTopic.startsWith("/p2p/");
    }

    public static String getClientIdFromP2pTopic(String p2pTopic) {
        String tmp = p2pTopic.substring("/p2p/".length());
        return tmp.substring(0, tmp.length() - 1);
    }

    public static String getClientIdFromRetryTopic(String retryTopic) {
        String tmp = retryTopic.substring("/retry/".length());
        return tmp.substring(0, tmp.length() - 1);
    }

    public static String getP2pTopic(String clientId) {
        return TopicUtils.normalizeTopic("/p2p/" + clientId + "/");
    }

    public static String getRetryTopic(String clientId) {
        return TopicUtils.normalizeTopic("/retry/" + clientId + "/");
    }

    public static boolean isRetryTopic(String topic) {
        return topic != null && topic.startsWith("/retry/");
    }

    public static boolean isP2pTopic(String topic) {
        return topic != null && topic.startsWith("/p2p/");
    }

    public static String getP2Peer(MqttTopic mqttTopic, String namespace) {
        if (mqttTopic.getSecondTopic() == null || mqttTopic.getFirstTopic() == null) {
            return null;
        }
        if (!TopicUtils.isP2P(mqttTopic.getSecondTopic())) {
            return null;
        }
        if (mqttTopic.getFirstTopic().contains("%") && StringUtils.isNotBlank((CharSequence)namespace)) {
            return StringUtils.join((Object[])new String[]{namespace, "%", mqttTopic.getSecondTopic().split("/")[2]});
        }
        return mqttTopic.getSecondTopic().split("/")[2];
    }

    public static String encode(String topic, String secondTopic) {
        if (secondTopic != null && secondTopic.length() > 1) {
            return topic + secondTopic;
        }
        return topic;
    }

    public static MqttTopic decode(String topics) {
        String topic;
        if (topics.startsWith("/")) {
            topics = topics.substring(1);
        }
        String secondTopic = null;
        int index = topics.indexOf("/", 1);
        if (index > 0) {
            topic = topics.substring(0, index);
            secondTopic = topics.substring(index);
        } else {
            topic = topics;
        }
        return new MqttTopic(topic, secondTopic);
    }

    public static boolean isWildCard(String topicFilter) {
        return topicFilter != null && (topicFilter.contains("#") || topicFilter.contains("+"));
    }

    public static boolean isMatch(String topic, String topicFilter) {
        if (topic.equals(topicFilter)) {
            return true;
        }
        if (!TopicUtils.isWildCard(topicFilter)) {
            return false;
        }
        String[] subscribeTopics = topicFilter.split("/");
        String[] messageTopics = topic.split("/");
        int targetTopicLength = messageTopics.length;
        int sourceTopicLength = subscribeTopics.length;
        int minTopicLength = Math.min(targetTopicLength, sourceTopicLength);
        for (int i = 0; i < minTopicLength; ++i) {
            boolean last;
            String sourceTopic = subscribeTopics[i];
            if (!TopicUtils.isWildCard(sourceTopic) && !sourceTopic.equals(messageTopics[i])) {
                return false;
            }
            if ("#".equals(sourceTopic)) {
                return i == sourceTopicLength - 1;
            }
            boolean bl = last = i == minTopicLength - 1 && (sourceTopicLength == targetTopicLength || sourceTopicLength == targetTopicLength + 1 && "#".equals(subscribeTopics[sourceTopicLength - 1]));
            if (!last) continue;
            return true;
        }
        return false;
    }

    public static String wrapLmq(String firstTopic, String secondTopic) {
        if (StringUtils.isBlank((CharSequence)secondTopic)) {
            return firstTopic;
        }
        return firstTopic + TopicUtils.normalizeSecondTopic(secondTopic);
    }

    public static String wrapP2pLmq(String clientId) {
        return TopicUtils.normalizeTopic("/p2p/" + clientId);
    }
}

