/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.ds.meta;

import com.alipay.sofa.jraft.error.RemotingException;
import com.alipay.sofa.jraft.rpc.InvokeCallback;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Resource;
import org.apache.rocketmq.mqtt.common.model.Message;
import org.apache.rocketmq.mqtt.common.model.consistency.ReadRequest;
import org.apache.rocketmq.mqtt.common.model.consistency.Response;
import org.apache.rocketmq.mqtt.common.model.consistency.StoreMessage;
import org.apache.rocketmq.mqtt.common.model.consistency.WriteRequest;
import org.apache.rocketmq.mqtt.ds.config.ServiceConf;
import org.apache.rocketmq.mqtt.ds.meta.MetaRpcClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RetainedMsgClient {
    private static Logger logger = LoggerFactory.getLogger(RetainedMsgClient.class);
    @Resource
    private ServiceConf serviceConf;
    @Resource
    private MetaRpcClient metaRpcClient;

    public void setRetainedMsg(String topic, Message msg, final CompletableFuture<Boolean> future) throws RemotingException, InterruptedException {
        String groupId = this.whichGroup();
        HashMap<String, String> option = new HashMap<String, String>();
        option.put("topic", topic);
        option.put("firstTopic", msg.getFirstTopic());
        option.put("isEmpty", String.valueOf(msg.isEmpty()));
        logger.debug("SetRetainedMsg option:" + option);
        WriteRequest request = WriteRequest.newBuilder().setGroup(groupId).setData(ByteString.copyFrom((byte[])msg.getEncodeBytes())).putAllExtData(option).setCategory("retainedMsg").build();
        this.metaRpcClient.getCliClientService().getRpcClient().invokeAsync(this.metaRpcClient.getLeader(groupId).getEndpoint(), (Object)request, new InvokeCallback(){

            public void complete(Object result, Throwable err) {
                if (err == null) {
                    Response rsp = (Response)result;
                    if (!rsp.getSuccess()) {
                        logger.error("SetRetainedMsg failed. {}", (Object)rsp.getErrMsg());
                        future.complete(false);
                        return;
                    }
                    future.complete(true);
                } else {
                    logger.error("", err);
                    future.complete(false);
                }
            }

            public Executor executor() {
                return null;
            }
        }, 5000L);
    }

    public void GetRetainedMsgsFromTrie(String firstTopic, String topic, final CompletableFuture<ArrayList<Message>> future) throws RemotingException, InterruptedException {
        String groupId = this.whichGroup();
        HashMap<String, String> option = new HashMap<String, String>();
        option.put("firstTopic", firstTopic);
        option.put("topic", topic);
        logger.debug("GetRetainedMsgsFromTrie option:" + option);
        ReadRequest request = ReadRequest.newBuilder().setGroup(groupId).setOperation("trie").setType("readIndexType").putAllExtData(option).setCategory("retainedMsg").build();
        this.metaRpcClient.getCliClientService().getRpcClient().invokeAsync(this.metaRpcClient.getLeader(groupId).getEndpoint(), (Object)request, new InvokeCallback(){

            public void complete(Object result, Throwable err) {
                if (err == null) {
                    Response rsp = (Response)result;
                    if (!rsp.getSuccess()) {
                        logger.error("GetRetainedTopicTrie failed. {}", (Object)rsp.getErrMsg());
                        future.complete(null);
                        return;
                    }
                    List datalistList = rsp.getDatalistList();
                    ArrayList<Message> resultList = new ArrayList<Message>();
                    for (ByteString tmp : datalistList) {
                        try {
                            resultList.add(Message.copyFromStoreMessage((StoreMessage)StoreMessage.parseFrom((byte[])tmp.toByteArray())));
                        }
                        catch (InvalidProtocolBufferException e) {
                            future.complete(null);
                            throw new RuntimeException(e);
                        }
                    }
                    future.complete(resultList);
                } else {
                    logger.error("", err);
                    future.complete(null);
                }
            }

            public Executor executor() {
                return null;
            }
        }, 5000L);
    }

    public void GetRetainedMsg(String topic, final CompletableFuture<Message> future) throws RemotingException, InterruptedException {
        String groupId = this.whichGroup();
        HashMap<String, String> option = new HashMap<String, String>();
        option.put("topic", topic);
        ReadRequest request = ReadRequest.newBuilder().setGroup(groupId).setOperation("topic").setType("readIndexType").putAllExtData(option).setCategory("retainedMsg").build();
        this.metaRpcClient.getCliClientService().getRpcClient().invokeAsync(this.metaRpcClient.getLeader(groupId).getEndpoint(), (Object)request, new InvokeCallback(){

            public void complete(Object result, Throwable err) {
                if (err == null) {
                    Response rsp = (Response)result;
                    if (!rsp.getSuccess()) {
                        logger.info("GetRetainedMsg failed. {}", (Object)rsp.getErrMsg());
                        future.complete(null);
                        return;
                    }
                    if (rsp.getData().toStringUtf8().equals("NOT_FOUND")) {
                        future.complete(null);
                        return;
                    }
                    Message message = null;
                    try {
                        message = Message.copyFromStoreMessage((StoreMessage)StoreMessage.parseFrom((byte[])rsp.getData().toByteArray()));
                    }
                    catch (InvalidProtocolBufferException e) {
                        future.complete(null);
                        throw new RuntimeException(e);
                    }
                    future.complete(message);
                } else {
                    logger.error("", err);
                    future.complete(null);
                }
            }

            public Executor executor() {
                return null;
            }
        }, 5000L);
    }

    private String whichGroup() {
        return this.metaRpcClient.getRaftGroups()[0];
    }
}

