/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.exporter.http;

import com.sun.net.httpserver.Authenticator;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsServer;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Predicate;
import io.prometheus.client.SampleNameFilter;
import io.prometheus.client.Supplier;
import io.prometheus.client.exporter.SampleNameFilterSupplier;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPOutputStream;
import org.apache.rocketmq.mqtt.exporter.http.BackedFileOutputStream;

public class MqttHTTPServer
implements Closeable {
    private static final File TEMP_DIR;
    protected final HttpServer server;
    protected final ExecutorService executorService;

    public MqttHTTPServer(HttpServer httpServer, CollectorRegistry registry, boolean daemon) throws IOException {
        this(httpServer, registry, daemon, null, null);
    }

    public MqttHTTPServer(InetSocketAddress addr, CollectorRegistry registry, boolean daemon) throws IOException {
        this(HttpServer.create(addr, 3), registry, daemon);
    }

    public MqttHTTPServer(InetSocketAddress addr, CollectorRegistry registry) throws IOException {
        this(addr, registry, false);
    }

    public MqttHTTPServer(int port, boolean daemon) throws IOException {
        this(new InetSocketAddress(port), CollectorRegistry.defaultRegistry, daemon);
    }

    public MqttHTTPServer(int port) throws IOException {
        this(port, false);
    }

    public MqttHTTPServer(String host, int port, boolean daemon) throws IOException {
        this(new InetSocketAddress(host, port), CollectorRegistry.defaultRegistry, daemon);
    }

    public MqttHTTPServer(String host, int port) throws IOException {
        this(new InetSocketAddress(host, port), CollectorRegistry.defaultRegistry, false);
    }

    private MqttHTTPServer(HttpServer httpServer, CollectorRegistry registry, boolean daemon, Supplier<Predicate<String>> sampleNameFilterSupplier, Authenticator authenticator) {
        if (httpServer.getAddress() == null) {
            throw new IllegalArgumentException("HttpServer hasn't been bound to an address");
        }
        this.server = httpServer;
        HTTPMetricHandler mHandler = new HTTPMetricHandler(registry, sampleNameFilterSupplier);
        HttpContext mContext = this.server.createContext("/", mHandler);
        if (authenticator != null) {
            mContext.setAuthenticator(authenticator);
        }
        mContext = this.server.createContext("/metrics", mHandler);
        if (authenticator != null) {
            mContext.setAuthenticator(authenticator);
        }
        mContext = this.server.createContext("/-/healthy", mHandler);
        if (authenticator != null) {
            mContext.setAuthenticator(authenticator);
        }
        this.executorService = new ThreadPoolExecutor(2, 2, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100), NamedDaemonThreadFactory.defaultThreadFactory(daemon));
        this.server.setExecutor(this.executorService);
        this.start(daemon);
    }

    protected static boolean shouldUseCompression(HttpExchange exchange) {
        Object encodingHeaders = exchange.getRequestHeaders().get("Accept-Encoding");
        if (encodingHeaders == null) {
            return false;
        }
        Iterator iterator = encodingHeaders.iterator();
        while (iterator.hasNext()) {
            String[] encodings;
            String encodingHeader = (String)iterator.next();
            for (String encoding : encodings = encodingHeader.split(",")) {
                if (!encoding.trim().equalsIgnoreCase("gzip")) continue;
                return true;
            }
        }
        return false;
    }

    protected static Set<String> parseQuery(String query) throws IOException {
        HashSet<String> names = new HashSet<String>();
        if (query != null) {
            String[] pairs;
            for (String pair : pairs = query.split("&")) {
                int idx = pair.indexOf("=");
                if (idx == -1 || !URLDecoder.decode(pair.substring(0, idx), "UTF-8").equals("name[]")) continue;
                names.add(URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
            }
        }
        return names;
    }

    private void start(boolean daemon) {
        if (daemon == Thread.currentThread().isDaemon()) {
            this.server.start();
        } else {
            FutureTask<Object> startTask = new FutureTask<Object>(new Runnable(){

                @Override
                public void run() {
                    MqttHTTPServer.this.server.start();
                }
            }, null);
            NamedDaemonThreadFactory.defaultThreadFactory(daemon).newThread(startTask).start();
            try {
                startTask.get();
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Unexpected exception on starting HTTPSever", e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void close() {
        this.server.stop(0);
        this.executorService.shutdown();
    }

    public int getPort() {
        return this.server.getAddress().getPort();
    }

    static {
        String temDirName = System.getProperty("--logging.path", "/home/admin/logs/mqtt-exporter/");
        TEMP_DIR = new File(temDirName);
        if (!System.getProperties().containsKey("sun.net.httpserver.maxReqTime")) {
            System.setProperty("sun.net.httpserver.maxReqTime", "60");
        }
        if (!System.getProperties().containsKey("sun.net.httpserver.maxRspTime")) {
            System.setProperty("sun.net.httpserver.maxRspTime", "600");
        }
    }

    public static class Builder {
        private int port = 0;
        private String hostname = null;
        private InetAddress inetAddress = null;
        private InetSocketAddress inetSocketAddress = null;
        private HttpServer httpServer = null;
        private CollectorRegistry registry = CollectorRegistry.defaultRegistry;
        private boolean daemon = false;
        private Predicate<String> sampleNameFilter;
        private Supplier<Predicate<String>> sampleNameFilterSupplier;
        private Authenticator authenticator;
        private HttpsConfigurator httpsConfigurator;

        public Builder withPort(int port) {
            this.port = port;
            return this;
        }

        public Builder withHostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder withInetAddress(InetAddress address) {
            this.inetAddress = address;
            return this;
        }

        public Builder withInetSocketAddress(InetSocketAddress address) {
            this.inetSocketAddress = address;
            return this;
        }

        public Builder withHttpServer(HttpServer httpServer) {
            this.httpServer = httpServer;
            return this;
        }

        public Builder withDaemonThreads(boolean daemon) {
            this.daemon = daemon;
            return this;
        }

        public Builder withSampleNameFilter(Predicate<String> sampleNameFilter) {
            this.sampleNameFilter = sampleNameFilter;
            return this;
        }

        public Builder withSampleNameFilterSupplier(Supplier<Predicate<String>> sampleNameFilterSupplier) {
            this.sampleNameFilterSupplier = sampleNameFilterSupplier;
            return this;
        }

        public Builder withRegistry(CollectorRegistry registry) {
            this.registry = registry;
            return this;
        }

        public Builder withAuthenticator(Authenticator authenticator) {
            this.authenticator = authenticator;
            return this;
        }

        public Builder withHttpsConfigurator(HttpsConfigurator configurator) {
            this.httpsConfigurator = configurator;
            return this;
        }

        public MqttHTTPServer build() throws IOException {
            if (this.sampleNameFilter != null) {
                this.assertNull(this.sampleNameFilterSupplier, "cannot configure 'sampleNameFilter' and 'sampleNameFilterSupplier' at the same time");
                this.sampleNameFilterSupplier = SampleNameFilterSupplier.of(this.sampleNameFilter);
            }
            if (this.httpServer != null) {
                this.assertZero(this.port, "cannot configure 'httpServer' and 'port' at the same time");
                this.assertNull(this.hostname, "cannot configure 'httpServer' and 'hostname' at the same time");
                this.assertNull(this.inetAddress, "cannot configure 'httpServer' and 'inetAddress' at the same time");
                this.assertNull(this.inetSocketAddress, "cannot configure 'httpServer' and 'inetSocketAddress' at the same time");
                this.assertNull(this.httpsConfigurator, "cannot configure 'httpServer' and 'httpsConfigurator' at the same time");
                return new MqttHTTPServer(this.httpServer, this.registry, this.daemon, this.sampleNameFilterSupplier, this.authenticator);
            }
            if (this.inetSocketAddress != null) {
                this.assertZero(this.port, "cannot configure 'inetSocketAddress' and 'port' at the same time");
                this.assertNull(this.hostname, "cannot configure 'inetSocketAddress' and 'hostname' at the same time");
                this.assertNull(this.inetAddress, "cannot configure 'inetSocketAddress' and 'inetAddress' at the same time");
            } else if (this.inetAddress != null) {
                this.assertNull(this.hostname, "cannot configure 'inetAddress' and 'hostname' at the same time");
                this.inetSocketAddress = new InetSocketAddress(this.inetAddress, this.port);
            } else {
                this.inetSocketAddress = this.hostname != null ? new InetSocketAddress(this.hostname, this.port) : new InetSocketAddress(this.port);
            }
            HttpServer httpServer = null;
            if (this.httpsConfigurator != null) {
                httpServer = HttpsServer.create(this.inetSocketAddress, 3);
                ((HttpsServer)httpServer).setHttpsConfigurator(this.httpsConfigurator);
            } else {
                httpServer = HttpServer.create(this.inetSocketAddress, 3);
            }
            return new MqttHTTPServer(httpServer, this.registry, this.daemon, this.sampleNameFilterSupplier, this.authenticator);
        }

        private void assertNull(Object o, String msg) {
            if (o != null) {
                throw new IllegalStateException(msg);
            }
        }

        private void assertZero(int i, String msg) {
            if (i != 0) {
                throw new IllegalStateException(msg);
            }
        }
    }

    static class NamedDaemonThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
        private final int poolNumber = POOL_NUMBER.getAndIncrement();
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final ThreadFactory delegate;
        private final boolean daemon;

        NamedDaemonThreadFactory(ThreadFactory delegate, boolean daemon) {
            this.delegate = delegate;
            this.daemon = daemon;
        }

        static ThreadFactory defaultThreadFactory(boolean daemon) {
            return new NamedDaemonThreadFactory(Executors.defaultThreadFactory(), daemon);
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = this.delegate.newThread(r);
            t.setName(String.format("prometheus-http-%d-%d", this.poolNumber, this.threadNumber.getAndIncrement()));
            t.setDaemon(this.daemon);
            return t;
        }
    }

    public static class HTTPMetricHandler
    implements HttpHandler {
        private static final String HEALTHY_RESPONSE = "Exporter is Healthy.";
        private final CollectorRegistry registry;
        private final LocalByteArray response = new LocalByteArray();
        private final Supplier<Predicate<String>> sampleNameFilterSupplier;

        public HTTPMetricHandler(CollectorRegistry registry) {
            this(registry, null);
        }

        public HTTPMetricHandler(CollectorRegistry registry, Supplier<Predicate<String>> sampleNameFilterSupplier) {
            this.registry = registry;
            this.sampleNameFilterSupplier = sampleNameFilterSupplier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(HttpExchange t) throws IOException {
            String query = t.getRequestURI().getRawQuery();
            String contextPath = t.getHttpContext().getPath();
            BackedFileOutputStream response = (BackedFileOutputStream)this.response.get();
            response.reset();
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)response, Charset.forName("UTF-8"));
            if ("/-/healthy".equals(contextPath)) {
                osw.write(HEALTHY_RESPONSE);
            } else {
                String contentType = TextFormat.chooseContentType((String)t.getRequestHeaders().getFirst("Accept"));
                t.getResponseHeaders().set("Content-Type", contentType);
                Predicate filter = this.sampleNameFilterSupplier == null ? null : (Predicate)this.sampleNameFilterSupplier.get();
                filter = SampleNameFilter.restrictToNamesEqualTo((Predicate)filter, MqttHTTPServer.parseQuery(query));
                if (filter == null) {
                    TextFormat.writeFormat((String)contentType, (Writer)osw, (Enumeration)this.registry.metricFamilySamples());
                } else {
                    TextFormat.writeFormat((String)contentType, (Writer)osw, (Enumeration)this.registry.filteredMetricFamilySamples(filter));
                }
            }
            osw.close();
            if (MqttHTTPServer.shouldUseCompression(t)) {
                t.getResponseHeaders().set("Content-Encoding", "gzip");
                t.sendResponseHeaders(200, 0L);
                try (GZIPOutputStream os = new GZIPOutputStream(t.getResponseBody());){
                    response.writeTo(os);
                }
            } else {
                long contentLength = response.size();
                if (contentLength > 0L) {
                    t.getResponseHeaders().set("Content-Length", String.valueOf(contentLength));
                }
                if (t.getRequestMethod().equals("HEAD")) {
                    contentLength = -1L;
                }
                t.sendResponseHeaders(200, contentLength);
                response.writeTo(t.getResponseBody());
            }
            t.close();
            response.reset();
        }
    }

    private static class LocalByteArray
    extends ThreadLocal<BackedFileOutputStream> {
        private LocalByteArray() {
        }

        @Override
        protected BackedFileOutputStream initialValue() {
            return new BackedFileOutputStream(0x1000000, false, TEMP_DIR);
        }
    }
}

