/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.test.ant.launcher.commands;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.royale.test.ant.launcher.OperatingSystem;
import org.apache.royale.test.ant.launcher.commands.TestRunCommand;
import org.apache.royale.test.ant.launcher.commands.player.AdlCommand;
import org.apache.royale.test.ant.launcher.commands.player.CustomPlayerCommand;
import org.apache.royale.test.ant.launcher.commands.player.DefaultPlayerCommand;
import org.apache.royale.test.ant.launcher.commands.player.FlashPlayerCommand;
import org.apache.royale.test.ant.launcher.commands.playwright.DefaultPlaywrightCommand;
import org.apache.royale.test.ant.launcher.platforms.LinuxDefaults;
import org.apache.royale.test.ant.launcher.platforms.MacOSXDefaults;
import org.apache.royale.test.ant.launcher.platforms.WindowsDefaults;

public class TestRunCommandFactory {
    private static final List<String> VALID_PLAYWRIGHT_PLAYERS = Arrays.asList("html", "chromium", "firefox", "webkit");

    public static TestRunCommand createCommand(OperatingSystem os, String player, File customCommand, String[] customCommandArgs, boolean localTrusted) {
        TestRunCommand newInstance = null;
        if (customCommand == null && VALID_PLAYWRIGHT_PLAYERS.contains(player)) {
            DefaultPlaywrightCommand playwrightCommand = new DefaultPlaywrightCommand();
            playwrightCommand.setBrowser(player);
            newInstance = playwrightCommand;
        } else {
            DefaultPlayerCommand defaultInstance = null;
            if (!player.equals("air")) {
                FlashPlayerCommand fpCommand = new FlashPlayerCommand();
                fpCommand.setLocalTrusted(localTrusted);
                defaultInstance = fpCommand;
            } else {
                defaultInstance = new AdlCommand();
            }
            if (os.equals((Object)OperatingSystem.WINDOWS)) {
                defaultInstance.setDefaults(new WindowsDefaults());
            } else if (os.equals((Object)OperatingSystem.MACOSX)) {
                defaultInstance.setDefaults(new MacOSXDefaults());
            } else {
                defaultInstance.setDefaults(new LinuxDefaults());
            }
            if (customCommand != null) {
                CustomPlayerCommand customInstance = new CustomPlayerCommand();
                customInstance.setProxiedCommand(defaultInstance);
                customInstance.setExecutable(customCommand);
                customInstance.setExecutableArgs(customCommandArgs);
                newInstance = customInstance;
            } else {
                newInstance = defaultInstance;
            }
        }
        return newInstance;
    }
}

