/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.common;

import flex2.compiler.common.ConfigurationPathResolver;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.config.ConfigurationInfo;
import flex2.compiler.config.ConfigurationValue;
import flex2.compiler.io.VirtualFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class NamespacesConfiguration {
    private ConfigurationPathResolver configResolver;
    private Map<String, List<VirtualFile>> manifestMappings;

    public void setConfigPathResolver(ConfigurationPathResolver resolver) {
        this.configResolver = resolver;
    }

    public Map<String, List<VirtualFile>> getManifestMappings() {
        return this.manifestMappings;
    }

    public void setManifestMappings(Map<String, List<VirtualFile>> manifestMappings) {
        this.manifestMappings = manifestMappings;
    }

    public VirtualFile[] getNamespace() {
        if (this.manifestMappings != null) {
            ArrayList<VirtualFile> fileList = new ArrayList<VirtualFile>();
            for (List<VirtualFile> files : this.manifestMappings.values()) {
                if (files == null) continue;
                Iterator<VirtualFile> f = files.iterator();
                while (f.hasNext()) {
                    fileList.add(f.next());
                }
            }
            VirtualFile[] fileArray = new VirtualFile[fileList.size()];
            return fileList.toArray(fileArray);
        }
        return null;
    }

    public void cfgNamespace(ConfigurationValue cfgval, List<String> args) throws ConfigurationException {
        if (args == null) {
            throw new ConfigurationException.CannotOpen(null, cfgval.getVar(), cfgval.getSource(), cfgval.getLine());
        }
        if (args.size() < 2) {
            throw new ConfigurationException.NamespaceMissingManifest("namespace", cfgval.getSource(), cfgval.getLine());
        }
        assert (this.configResolver != null) : "Path resolvers must be set before calling this method.";
        if (this.configResolver == null) {
            throw new ConfigurationException.CannotOpen(null, cfgval.getVar(), cfgval.getSource(), cfgval.getLine());
        }
        String uri = null;
        Iterator<String> iterator = args.iterator();
        while (iterator.hasNext()) {
            List<VirtualFile> files;
            if (uri == null) {
                uri = iterator.next();
                continue;
            }
            String manifest = iterator.next();
            VirtualFile file = ConfigurationPathResolver.getVirtualFile(manifest, this.configResolver, cfgval);
            if (this.manifestMappings == null) {
                this.manifestMappings = new LinkedHashMap<String, List<VirtualFile>>();
            }
            if ((files = this.manifestMappings.get(uri)) == null) {
                files = new ArrayList<VirtualFile>();
            }
            files.add(file);
            this.manifestMappings.put(uri, files);
        }
    }

    public static ConfigurationInfo getNamespaceInfo() {
        return new ConfigurationInfo(-1, new String[]{"uri", "manifest"}){

            @Override
            public boolean allowMultiple() {
                return true;
            }
        };
    }
}

