/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.problems.CompilerProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IOperatorNode;
import org.apache.royale.compiler.tree.as.IUnaryOperatorNode;
import org.apache.royale.linter.LinterRule;
import org.apache.royale.linter.NodeVisitor;
import org.apache.royale.linter.TokenQuery;
import org.apache.royale.linter.problems.ILinterProblem;

public class NoVoidOperatorRule
extends LinterRule {
    @Override
    public Map<ASTNodeID, NodeVisitor> getNodeVisitors() {
        HashMap<ASTNodeID, NodeVisitor> result = new HashMap<ASTNodeID, NodeVisitor>();
        result.put(ASTNodeID.Op_VoidID, (node, tokenQuery, problems) -> this.checkUnaryOperatorNode((IUnaryOperatorNode)node, tokenQuery, problems));
        return result;
    }

    private void checkUnaryOperatorNode(IUnaryOperatorNode unaryOperatorNode, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        if (!IOperatorNode.OperatorType.VOID.equals((Object)unaryOperatorNode.getOperator())) {
            return;
        }
        problems.add(new NoVoidOperatorLinterProblem(unaryOperatorNode));
    }

    public static class NoVoidOperatorLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Must not use 'void' operator";

        public NoVoidOperatorLinterProblem(IUnaryOperatorNode node) {
            super((ISourceLocation)node);
        }
    }
}

