/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.rhino.jstype.JSType;

public enum TypeMatchingStrategy {
    LOOSE(true, true, true),
    STRICT_NULLABILITY(true, false, true),
    SUBTYPES(true, false, false),
    EXACT(false, false, false);

    private final boolean allowSubtypes;
    private final boolean ignoreNullability;
    private final boolean allowLooseMatches;

    private TypeMatchingStrategy(boolean allowSubtypes, boolean ignoreNullability, boolean allowLooseMatches) {
        this.allowSubtypes = allowSubtypes;
        this.ignoreNullability = ignoreNullability;
        this.allowLooseMatches = allowLooseMatches;
    }

    public MatchResult match(JSType templateType, JSType type) {
        boolean voidableMismatch;
        if (templateType.isUnknownType()) {
            return MatchResult.MATCH;
        }
        if (type == null || type.isUnknownType() || type.isAllType()) {
            return this.allowLooseMatches ? MatchResult.LOOSE_MATCH : MatchResult.NO_MATCH;
        }
        if (this.allowSubtypes) {
            if (this.ignoreNullability) {
                type = type.restrictByNotNullOrUndefined();
            }
            if (type.isSubtypeOf(templateType)) {
                return MatchResult.MATCH;
            }
        }
        boolean nullableMismatch = templateType.isNullable() != type.isNullable();
        boolean bl = voidableMismatch = templateType.isVoidable() != type.isVoidable();
        if (!this.ignoreNullability && (nullableMismatch || voidableMismatch)) {
            return MatchResult.NO_MATCH;
        }
        return type.isEquivalentTo(templateType) ? MatchResult.MATCH : MatchResult.NO_MATCH;
    }

    public static enum MatchResult {
        MATCH,
        NO_MATCH,
        LOOSE_MATCH;


        public boolean isMatch() {
            return this != NO_MATCH;
        }

        public boolean isLooseMatch() {
            return this == LOOSE_MATCH;
        }
    }
}

