/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractScope;
import com.google.javascript.jscomp.ClosurePrimitiveErrors;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PreprocessorSymbolTable;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticScope;
import com.google.javascript.rhino.Token;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

final class ClosureRewriteModule
implements HotSwapCompilerPass {
    static final DiagnosticType INVALID_MODULE_NAMESPACE = DiagnosticType.error("JSC_GOOG_MODULE_INVALID_MODULE_NAMESPACE", "goog.module parameter must be string literals");
    static final DiagnosticType INVALID_PROVIDE_NAMESPACE = DiagnosticType.error("JSC_GOOG_MODULE_INVALID_PROVIDE_NAMESPACE", "goog.provide parameter must be a string literal.");
    static final DiagnosticType INVALID_PROVIDE_CALL = DiagnosticType.error("JSC_GOOG_MODULE_INVALID_PROVIDE_CALL", "goog.provide can not be called in goog.module.");
    static final DiagnosticType INVALID_GET_ALIAS = DiagnosticType.error("JSC_GOOG_MODULE_INVALID_GET_ALIAS", "goog.module.get should not be aliased.");
    static final DiagnosticType INVALID_EXPORT_COMPUTED_PROPERTY = DiagnosticType.error("JSC_GOOG_MODULE_INVALID_EXPORT_COMPUTED_PROPERTY", "Computed properties are not yet supported in goog.module exports.");
    static final DiagnosticType USELESS_USE_STRICT_DIRECTIVE = DiagnosticType.disabled("JSC_USELESS_USE_STRICT_DIRECTIVE", "'use strict' is unnecessary in goog.module files.");
    static final DiagnosticType DUPLICATE_MODULE = DiagnosticType.error("JSC_DUPLICATE_MODULE", "Duplicate module: {0}");
    static final DiagnosticType DUPLICATE_NAMESPACE = DiagnosticType.error("JSC_DUPLICATE_NAMESPACE", "Duplicate namespace: {0}");
    static final DiagnosticType LATE_PROVIDE_ERROR = DiagnosticType.error("JSC_LATE_PROVIDE_ERROR", "Required namespace \"{0}\" not provided yet.");
    static final DiagnosticType IMPORT_INLINING_SHADOWS_VAR = DiagnosticType.error("JSC_IMPORT_INLINING_SHADOWS_VAR", "Inlining of reference to import \"{1}\" shadows var \"{0}\".");
    static final DiagnosticType ILLEGAL_DESTRUCTURING_DEFAULT_EXPORT = DiagnosticType.error("JSC_ILLEGAL_DESTRUCTURING_DEFAULT_EXPORT", "Destructuring import only allowed for importing module with named exports.\nSee https://github.com/google/closure-compiler/wiki/goog.module-style");
    static final DiagnosticType ILLEGAL_DESTRUCTURING_NOT_EXPORTED = DiagnosticType.error("JSC_ILLEGAL_DESTRUCTURING_NOT_EXPORTED", "Destructuring import reference to name \"{0}\" was not exported in module {1}");
    private static final ImmutableSet<String> USE_STRICT_ONLY = ImmutableSet.of("use strict");
    private static final String MODULE_EXPORTS_PREFIX = "module$exports$";
    private static final String MODULE_CONTENTS_PREFIX = "module$contents$";
    private static final Node GOOG_FORWARDDECLARE = IR.getprop(IR.name("goog"), IR.string("forwardDeclare"));
    private static final Node GOOG_LOADMODULE = IR.getprop(IR.name("goog"), IR.string("loadModule"));
    private static final Node GOOG_MODULE = IR.getprop(IR.name("goog"), IR.string("module"));
    private static final Node GOOG_MODULE_DECLARELEGACYNAMESPACE = IR.getprop(GOOG_MODULE, IR.string("declareLegacyNamespace"));
    private static final Node GOOG_MODULE_GET = IR.getprop(GOOG_MODULE.cloneTree(), IR.string("get"));
    private static final Node GOOG_PROVIDE = IR.getprop(IR.name("goog"), IR.string("provide"));
    private static final Node GOOG_REQUIRE = IR.getprop(IR.name("goog"), IR.string("require"));
    private static final Node GOOG_REQUIRETYPE = IR.getprop(IR.name("goog"), IR.string("requireType"));
    private final AbstractCompiler compiler;
    private final PreprocessorSymbolTable preprocessorSymbolTable;
    private final boolean preserveSugar;
    private final NodeUtil.Visitor replaceJsDocRefs = new NodeUtil.Visitor(){

        @Override
        public void visit(Node typeRefNode) {
            String typeName;
            if (!typeRefNode.isString()) {
                return;
            }
            String prefixTypeName = typeName = typeRefNode.getString();
            String suffix = "";
            while (true) {
                boolean nameIsAnAlias;
                if (nameIsAnAlias = ((ClosureRewriteModule)ClosureRewriteModule.this).currentScript.namesToInlineByAlias.containsKey(prefixTypeName)) {
                    if (ClosureRewriteModule.this.preprocessorSymbolTable != null) {
                        Node moduleOnlyNode = typeRefNode.cloneNode();
                        ClosureRewriteModule.this.safeSetString(moduleOnlyNode, prefixTypeName);
                        moduleOnlyNode.setLength(prefixTypeName.length());
                        ClosureRewriteModule.this.maybeAddAliasToSymbolTable(moduleOnlyNode, ((ClosureRewriteModule)ClosureRewriteModule.this).currentScript.legacyNamespace);
                    }
                    String aliasedNamespace = ((ClosureRewriteModule)ClosureRewriteModule.this).currentScript.namesToInlineByAlias.get(prefixTypeName);
                    ClosureRewriteModule.this.safeSetString(typeRefNode, aliasedNamespace + suffix);
                    return;
                }
                if (((ClosureRewriteModule)ClosureRewriteModule.this).currentScript.isModule && ((ClosureRewriteModule)ClosureRewriteModule.this).currentScript.topLevelNames.contains(prefixTypeName)) {
                    ClosureRewriteModule.this.safeSetString(typeRefNode, ((ClosureRewriteModule)ClosureRewriteModule.this).currentScript.contentsPrefix + typeName);
                    return;
                }
                String binaryNamespaceIfModule = ClosureRewriteModule.this.rewriteState.getBinaryNamespace(prefixTypeName);
                if (ClosureRewriteModule.this.legacyScriptNamespacesAndPrefixes.contains(prefixTypeName) && binaryNamespaceIfModule == null) {
                    return;
                }
                if (binaryNamespaceIfModule != null) {
                    ClosureRewriteModule.this.safeSetString(typeRefNode, binaryNamespaceIfModule + suffix);
                    return;
                }
                if (!prefixTypeName.contains(".")) break;
                prefixTypeName = prefixTypeName.substring(0, prefixTypeName.lastIndexOf(46));
                suffix = typeName.substring(prefixTypeName.length(), typeName.length());
            }
        }
    };
    private final Deque<ScriptDescription> scriptStack = new ArrayDeque<ScriptDescription>();
    private ScriptDescription currentScript = null;
    private final GlobalRewriteState rewriteState;
    private final Set<String> legacyScriptNamespacesAndPrefixes = new HashSet<String>();
    private final List<UnrecognizedRequire> unrecognizedRequires = new ArrayList<UnrecognizedRequire>();

    static String getBinaryModuleNamespace(String legacyNamespace) {
        return MODULE_EXPORTS_PREFIX + legacyNamespace.replace('.', '$');
    }

    private void rewriteJsdoc(JSDocInfo info) {
        for (Node typeNode : info.getTypeNodes()) {
            NodeUtil.visitPreOrder(typeNode, this.replaceJsDocRefs);
        }
    }

    ClosureRewriteModule(AbstractCompiler compiler, PreprocessorSymbolTable preprocessorSymbolTable, GlobalRewriteState moduleRewriteState) {
        this.compiler = compiler;
        this.preprocessorSymbolTable = preprocessorSymbolTable;
        this.rewriteState = moduleRewriteState != null ? moduleRewriteState : new GlobalRewriteState();
        this.preserveSugar = compiler.getOptions().shouldPreserveGoogModule();
    }

    @Override
    public void process(Node externs, Node root) {
        ArrayDeque<ScriptDescription> scriptDescriptions = new ArrayDeque<ScriptDescription>();
        this.processAllFiles(scriptDescriptions, Iterables.concat(externs.children(), root.children()));
    }

    private void processAllFiles(Deque<ScriptDescription> scriptDescriptions, Iterable<Node> scriptNodes) {
        for (Node c : scriptNodes) {
            Preconditions.checkState(c.isScript(), c);
            NodeTraversal.traverse(this.compiler, c, new UnwrapGoogLoadModule());
            this.pushScript(new ScriptDescription());
            this.currentScript.rootNode = c;
            scriptDescriptions.addLast(this.currentScript);
            NodeTraversal.traverse(this.compiler, c, new ScriptPreprocessor());
            NodeTraversal.traverse(this.compiler, c, new ScriptRecorder());
            this.popScript();
        }
        this.reportUnrecognizedRequires();
        if (this.compiler.hasHaltingErrors()) {
            return;
        }
        for (Node c : scriptNodes) {
            this.pushScript(scriptDescriptions.removeFirst());
            if (!c.isFromExterns() || NodeUtil.isFromTypeSummary(c)) {
                NodeTraversal.traverse(this.compiler, c, new ScriptUpdater());
            }
            this.popScript();
        }
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        Preconditions.checkState(scriptRoot.isScript(), scriptRoot);
        NodeTraversal.traverse(this.compiler, scriptRoot, new UnwrapGoogLoadModule());
        this.rewriteState.removeRoot(originalRoot);
        this.pushScript(new ScriptDescription());
        this.currentScript.rootNode = scriptRoot;
        NodeTraversal.traverse(this.compiler, scriptRoot, new ScriptPreprocessor());
        NodeTraversal.traverse(this.compiler, scriptRoot, new ScriptRecorder());
        if (this.compiler.hasHaltingErrors()) {
            return;
        }
        NodeTraversal.traverse(this.compiler, scriptRoot, new ScriptUpdater());
        this.popScript();
        this.reportUnrecognizedRequires();
    }

    private void preprocessExportDeclaration(Node n) {
        if (!(n.getString().equals("exports") && ClosureRewriteModule.isAssignTarget(n) && n.getGrandparent().isExprResult())) {
            return;
        }
        Preconditions.checkState(this.currentScript.defaultExportRhs == null);
        Node exportRhs = n.getNext();
        if (ClosureRewriteModule.isNamedExportsLiteral(exportRhs)) {
            Node insertionPoint = n.getGrandparent();
            for (Node key = exportRhs.getFirstChild(); key != null; key = key.getNext()) {
                String exportName = key.getString();
                JSDocInfo jsdoc = key.getJSDocInfo();
                Node rhs = key.hasChildren() ? key.removeFirstChild() : IR.name(exportName).srcref(key);
                Node lhs = IR.getprop(IR.name("exports"), IR.string(exportName)).srcrefTree(key);
                Node newExport = IR.exprResult(IR.assign(lhs, rhs).srcref(key).setJSDocInfo(jsdoc)).srcref(key);
                insertionPoint.getParent().addChildAfter(newExport, insertionPoint);
                insertionPoint = newExport;
            }
            n.getGrandparent().detach();
        }
    }

    private static boolean isNamedExportsLiteral(Node objLit) {
        if (!objLit.isObjectLit() || !objLit.hasChildren()) {
            return false;
        }
        for (Node key = objLit.getFirstChild(); key != null; key = key.getNext()) {
            if (!key.isStringKey() || key.isQuotedString()) {
                return false;
            }
            if (!key.hasChildren() || key.getFirstChild().isName()) continue;
            return false;
        }
        return true;
    }

    private void recordModuleBody(Node moduleRoot) {
        this.pushScript(new ScriptDescription());
        this.currentScript.rootNode = moduleRoot;
        this.currentScript.isModule = true;
    }

    private void recordGoogModule(NodeTraversal t, Node call) {
        String legacyNamespace;
        Node legacyNamespaceNode = call.getLastChild();
        if (!legacyNamespaceNode.isString()) {
            t.report(legacyNamespaceNode, INVALID_MODULE_NAMESPACE, new String[0]);
            return;
        }
        this.currentScript.legacyNamespace = legacyNamespace = legacyNamespaceNode.getString();
        this.currentScript.contentsPrefix = ClosureRewriteModule.toModuleContentsPrefix(legacyNamespace);
        if (this.rewriteState.containsModule(legacyNamespace)) {
            t.report(call, DUPLICATE_MODULE, legacyNamespace);
        }
        if (this.rewriteState.legacyScriptNamespaces.contains(legacyNamespace)) {
            t.report(call, DUPLICATE_NAMESPACE, legacyNamespace);
        }
        Node scriptNode = NodeUtil.getEnclosingScript(this.currentScript.rootNode);
        this.rewriteState.scriptDescriptionsByGoogModuleNamespace.put(legacyNamespace, this.currentScript);
        this.rewriteState.legacyNamespacesByScriptNode.put(scriptNode, legacyNamespace);
    }

    private void recordGoogDeclareLegacyNamespace() {
        this.currentScript.declareLegacyNamespace = true;
    }

    private void recordGoogProvide(NodeTraversal t, Node call) {
        Node legacyNamespaceNode = call.getLastChild();
        if (!legacyNamespaceNode.isString()) {
            t.report(legacyNamespaceNode, INVALID_PROVIDE_NAMESPACE, new String[0]);
            return;
        }
        String legacyNamespace = legacyNamespaceNode.getString();
        if (this.currentScript.isModule) {
            t.report(legacyNamespaceNode, INVALID_PROVIDE_CALL, new String[0]);
        }
        if (this.rewriteState.containsModule(legacyNamespace)) {
            t.report(call, DUPLICATE_NAMESPACE, legacyNamespace);
        }
        Node scriptNode = NodeUtil.getEnclosingScript(call);
        this.rewriteState.legacyScriptNamespaces.add(legacyNamespace);
        this.rewriteState.legacyNamespacesByScriptNode.put(scriptNode, legacyNamespace);
        LinkedList<String> parts = Lists.newLinkedList(Splitter.on('.').split(legacyNamespace));
        while (!parts.isEmpty()) {
            this.legacyScriptNamespacesAndPrefixes.add(Joiner.on('.').join(parts));
            parts.removeLast();
        }
    }

    private void recordGoogRequire(NodeTraversal t, Node call, boolean mustBeOrdered) {
        this.maybeSplitMultiVar(call);
        Node legacyNamespaceNode = call.getLastChild();
        if (!legacyNamespaceNode.isString()) {
            t.report(legacyNamespaceNode, ClosurePrimitiveErrors.INVALID_REQUIRE_NAMESPACE, new String[0]);
            return;
        }
        String legacyNamespace = legacyNamespaceNode.getString();
        boolean targetIsAModule = this.rewriteState.containsModule(legacyNamespace);
        boolean targetIsALegacyScript = this.rewriteState.legacyScriptNamespaces.contains(legacyNamespace);
        if (this.currentScript.isModule && !targetIsAModule && !targetIsALegacyScript) {
            this.unrecognizedRequires.add(new UnrecognizedRequire(call, legacyNamespace, mustBeOrdered));
        }
    }

    private void recordGoogRequireType(NodeTraversal t, Node call) {
        Node legacyNamespaceNode = call.getLastChild();
        if (!legacyNamespaceNode.isString()) {
            t.report(legacyNamespaceNode, ClosurePrimitiveErrors.INVALID_REQUIRE_TYPE_NAMESPACE, new String[0]);
            return;
        }
        boolean mustBeOrdered = false;
        this.recordGoogRequire(t, call, mustBeOrdered);
    }

    private void recordGoogForwardDeclare(NodeTraversal t, Node call) {
        Node namespaceNode = call.getLastChild();
        if (!call.hasTwoChildren() || !namespaceNode.isString()) {
            t.report(namespaceNode, ClosurePrimitiveErrors.INVALID_FORWARD_DECLARE_NAMESPACE, new String[0]);
            return;
        }
        boolean mustBeOrdered = false;
        this.recordGoogRequire(t, call, mustBeOrdered);
    }

    private void recordGoogModuleGet(NodeTraversal t, Node call) {
        boolean isFillingAnAlias;
        Node legacyNamespaceNode = call.getLastChild();
        if (!call.hasTwoChildren() || !legacyNamespaceNode.isString()) {
            t.report(legacyNamespaceNode, ClosurePrimitiveErrors.INVALID_GET_NAMESPACE, new String[0]);
            return;
        }
        if (!this.currentScript.isModule && t.inGlobalScope() && this.compiler.getOptions().moduleResolutionMode != ModuleLoader.ResolutionMode.WEBPACK) {
            t.report(legacyNamespaceNode, ClosurePrimitiveErrors.INVALID_GET_CALL_SCOPE, new String[0]);
            return;
        }
        String legacyNamespace = legacyNamespaceNode.getString();
        if (!this.rewriteState.containsModule(legacyNamespace)) {
            this.unrecognizedRequires.add(new UnrecognizedRequire(call, legacyNamespace, false));
        }
        String aliasName = null;
        Node maybeAssign = call.getParent();
        boolean bl = isFillingAnAlias = maybeAssign.isAssign() && maybeAssign.getFirstChild().isName() && maybeAssign.getParent().isExprResult();
        if (isFillingAnAlias && this.currentScript.isModule) {
            aliasName = call.getParent().getFirstChild().getString();
            Var aliasVar = (Var)t.getScope().getVar(aliasName);
            if (aliasVar == null) {
                t.report(call, INVALID_GET_ALIAS, new String[0]);
                return;
            }
            Node aliasVarNodeRhs = NodeUtil.getRValueOfLValue(aliasVar.getNode());
            if (aliasVarNodeRhs == null || !ClosureRewriteModule.isCallTo(aliasVarNodeRhs, GOOG_FORWARDDECLARE)) {
                t.report(call, INVALID_GET_ALIAS, new String[0]);
                return;
            }
            if (!legacyNamespace.equals(aliasVarNodeRhs.getLastChild().getString())) {
                t.report(call, INVALID_GET_ALIAS, new String[0]);
                return;
            }
            this.compiler.reportChangeToEnclosingScope(maybeAssign);
            maybeAssign.getParent().detach();
        }
    }

    private void recordTopLevelClassOrFunctionName(Node classOrFunctionNode) {
        Node nameNode = classOrFunctionNode.getFirstChild();
        if (nameNode.isName() && !Strings.isNullOrEmpty(nameNode.getString())) {
            String name = nameNode.getString();
            this.currentScript.topLevelNames.add(name);
        }
    }

    private void recordTopLevelVarNames(Node varNode) {
        for (Node lhs : NodeUtil.findLhsNodesInNode(varNode)) {
            String name = lhs.getString();
            this.currentScript.topLevelNames.add(name);
        }
    }

    private void maybeRecordExportDeclaration(NodeTraversal t, Node n) {
        if (!(this.currentScript.isModule && n.getString().equals("exports") && ClosureRewriteModule.isAssignTarget(n))) {
            return;
        }
        Preconditions.checkState(this.currentScript.defaultExportRhs == null, this.currentScript.defaultExportRhs);
        Node exportRhs = n.getNext();
        if (ClosureRewriteModule.isNamedExportsLiteral(exportRhs)) {
            boolean areAllExportsInlinable = true;
            ArrayList<ExportDefinition> inlinableExports = new ArrayList<ExportDefinition>();
            for (Node key = exportRhs.getFirstChild(); key != null; key = key.getNext()) {
                String exportName = key.getString();
                Node rhs = key.hasChildren() ? key.getFirstChild() : key;
                ExportDefinition namedExport = ExportDefinition.newNamedExport(t, exportName, rhs);
                this.currentScript.namedExports.add(exportName);
                if (this.currentScript.declareLegacyNamespace || !namedExport.hasInlinableName(this.currentScript.exportsToInline.keySet())) {
                    areAllExportsInlinable = false;
                    continue;
                }
                inlinableExports.add(namedExport);
            }
            if (areAllExportsInlinable) {
                for (ExportDefinition export : inlinableExports) {
                    this.recordExportToInline(export);
                }
                NodeUtil.removeChild(n.getGrandparent(), n.getParent());
            } else {
                this.currentScript.willCreateExportsObject = true;
            }
            return;
        }
        Preconditions.checkState(!ClosureRewriteModule.isNamedExportsLiteral(exportRhs), "Exports object should have been converted already");
        this.currentScript.defaultExportRhs = exportRhs;
        this.currentScript.willCreateExportsObject = true;
        ExportDefinition defaultExport = ExportDefinition.newDefaultExport(t, exportRhs);
        if (!this.currentScript.declareLegacyNamespace && defaultExport.hasInlinableName(this.currentScript.exportsToInline.keySet())) {
            String localName;
            this.currentScript.defaultExportLocalName = localName = defaultExport.getLocalName();
            this.recordExportToInline(defaultExport);
        }
    }

    private void updateModuleBodyEarly(Node moduleScopeRoot) {
        this.pushScript(this.currentScript.removeFirstChildScript());
        this.currentScript.rootNode = moduleScopeRoot;
    }

    private void updateGoogModule(Node call) {
        Preconditions.checkState(this.currentScript.isModule, this.currentScript);
        if (this.currentScript.declareLegacyNamespace) {
            call.getFirstChild().getLastChild().setString("provide");
            this.compiler.reportChangeToEnclosingScope(call);
        }
        if (!this.currentScript.willCreateExportsObject) {
            Preconditions.checkState(!this.currentScript.hasCreatedExportObject, this.currentScript);
            this.exportTheEmptyBinaryNamespaceAt(NodeUtil.getEnclosingStatement(call), AddAt.AFTER);
        }
        if (!this.currentScript.declareLegacyNamespace && !this.preserveSugar) {
            this.compiler.reportChangeToEnclosingScope(call);
            NodeUtil.getEnclosingStatement(call).detach();
        }
        Node callee = call.getFirstChild();
        Node arg = callee.getNext();
        this.maybeAddToSymbolTable(callee);
        this.maybeAddToSymbolTable(ClosureRewriteModule.createNamespaceNode(arg));
    }

    private void updateGoogDeclareLegacyNamespace(Node call) {
        NodeUtil.getEnclosingStatement(call).detach();
    }

    private void updateGoogRequire(NodeTraversal t, Node call) {
        Node legacyNamespaceNode = call.getLastChild();
        Node statementNode = NodeUtil.getEnclosingStatement(call);
        String legacyNamespace = legacyNamespaceNode.getString();
        boolean targetIsNonLegacyGoogModule = this.rewriteState.containsModule(legacyNamespace) && !this.rewriteState.isLegacyModule(legacyNamespace);
        boolean importHasAlias = NodeUtil.isNameDeclaration(statementNode);
        boolean isDestructuring = statementNode.getFirstChild().isDestructuringLhs();
        boolean currentScriptIsAModule = this.currentScript.isModule;
        boolean requireDirectlyStoredInAlias = NodeUtil.isNameDeclaration(call.getGrandparent());
        if (currentScriptIsAModule && requireDirectlyStoredInAlias && this.isTopLevel(t, statementNode, ScopeType.EXEC_CONTEXT)) {
            Node lhs = call.getParent();
            String exportedNamespace = this.rewriteState.getExportedNamespaceOrScript(legacyNamespace);
            if (exportedNamespace != null) {
                if (lhs.isName()) {
                    String aliasName = statementNode.getFirstChild().getString();
                    this.recordNameToInline(aliasName, exportedNamespace);
                    this.maybeAddAliasToSymbolTable(statementNode.getFirstChild(), this.currentScript.legacyNamespace);
                } else if (lhs.isDestructuringLhs() && lhs.getFirstChild().isObjectPattern()) {
                    this.maybeWarnForInvalidDestructuring(t, lhs.getParent(), legacyNamespace);
                    for (Node importSpec : lhs.getFirstChild().children()) {
                        Preconditions.checkState(importSpec.hasChildren(), importSpec);
                        String importedProperty = importSpec.getString();
                        Node aliasNode = importSpec.getFirstChild();
                        String aliasName = aliasNode.getString();
                        String fullName = exportedNamespace + "." + importedProperty;
                        this.recordNameToInline(aliasName, fullName);
                        this.maybeAddAliasToSymbolTable(aliasNode, this.currentScript.legacyNamespace);
                        this.safeSetString(aliasNode, this.currentScript.contentsPrefix + aliasName);
                    }
                } else {
                    throw new RuntimeException("Illegal goog.module import: " + lhs);
                }
            }
        }
        if (this.currentScript.isModule || targetIsNonLegacyGoogModule) {
            if (isDestructuring) {
                if (!this.preserveSugar) {
                    this.compiler.reportChangeToEnclosingScope(statementNode);
                    statementNode.detach();
                }
            } else if (targetIsNonLegacyGoogModule) {
                if (!this.isTopLevel(t, statementNode, ScopeType.EXEC_CONTEXT)) {
                    Node binaryNamespaceName = IR.name(this.rewriteState.getBinaryNamespace(legacyNamespace));
                    binaryNamespaceName.setOriginalName(legacyNamespace);
                    call.replaceWith(binaryNamespaceName);
                    this.compiler.reportChangeToEnclosingScope(binaryNamespaceName);
                } else if (!(!importHasAlias && this.rewriteState.isLegacyModule(legacyNamespace) || this.preserveSugar)) {
                    this.compiler.reportChangeToEnclosingScope(statementNode);
                    statementNode.detach();
                }
            } else {
                call.detach();
                statementNode.replaceWith(IR.exprResult(call));
                this.compiler.reportChangeToEnclosingScope(call);
            }
            if (targetIsNonLegacyGoogModule && !this.preserveSugar) {
                Node callee = call.getFirstChild();
                Node arg = callee.getNext();
                this.maybeAddToSymbolTable(callee);
                this.maybeAddToSymbolTable(ClosureRewriteModule.createNamespaceNode(arg));
            }
        }
    }

    private void maybeWarnForInvalidDestructuring(NodeTraversal t, Node importNode, String importedNamespace) {
        Preconditions.checkArgument(importNode.getFirstChild().isDestructuringLhs(), importNode);
        ScriptDescription importedModule = (ScriptDescription)this.rewriteState.scriptDescriptionsByGoogModuleNamespace.get(importedNamespace);
        if (importedModule == null) {
            return;
        }
        if (importedModule.defaultExportRhs != null) {
            t.report(importNode, ILLEGAL_DESTRUCTURING_DEFAULT_EXPORT, new String[0]);
            return;
        }
        Node objPattern = importNode.getFirstFirstChild();
        for (Node key = objPattern.getFirstChild(); key != null; key = key.getNext()) {
            String exportName = key.getString();
            if (importedModule.namedExports.contains(exportName)) continue;
            t.report(importNode, ILLEGAL_DESTRUCTURING_NOT_EXPORTED, exportName, importedNamespace);
        }
    }

    private void updateGoogForwardDeclare(NodeTraversal t, Node call) {
        this.updateGoogRequire(t, call);
    }

    private void updateGoogModuleGetCall(Node call) {
        Node legacyNamespaceNode = call.getSecondChild();
        String legacyNamespace = legacyNamespaceNode.getString();
        String exportedNamespace = this.rewriteState.getExportedNamespaceOrScript(legacyNamespace);
        if (exportedNamespace != null) {
            this.compiler.reportChangeToEnclosingScope(call);
            Node exportedNamespaceName = NodeUtil.newQName(this.compiler, exportedNamespace).srcrefTree(call);
            exportedNamespaceName.setOriginalName(legacyNamespace);
            call.replaceWith(exportedNamespaceName);
        }
    }

    private void recordExportsPropertyAssignment(NodeTraversal t, Node getpropNode) {
        if (!this.currentScript.isModule) {
            return;
        }
        Node parent = getpropNode.getParent();
        Preconditions.checkState(parent.isAssign() || parent.isExprResult(), parent);
        Node exportsNameNode = getpropNode.getFirstChild();
        Preconditions.checkState(exportsNameNode.getString().equals("exports"), exportsNameNode);
        if (t.inModuleScope()) {
            String exportName = getpropNode.getLastChild().getString();
            this.currentScript.namedExports.add(exportName);
            Node exportRhs = getpropNode.getNext();
            ExportDefinition namedExport = ExportDefinition.newNamedExport(t, exportName, exportRhs);
            if (!this.currentScript.declareLegacyNamespace && this.currentScript.defaultExportRhs == null && namedExport.hasInlinableName(this.currentScript.exportsToInline.keySet())) {
                this.recordExportToInline(namedExport);
                parent.getParent().detach();
            }
        }
    }

    private void updateExportsPropertyAssignment(Node getpropNode) {
        if (!this.currentScript.isModule) {
            return;
        }
        Node parent = getpropNode.getParent();
        Preconditions.checkState(parent.isAssign() || parent.isExprResult(), parent);
        Node exportsNameNode = getpropNode.getFirstChild();
        Preconditions.checkState(exportsNameNode.getString().equals("exports"));
        String exportedNamespace = this.currentScript.getExportedNamespace();
        this.safeSetMaybeQualifiedString(exportsNameNode, exportedNamespace);
        Node jsdocNode = parent.isAssign() ? parent : getpropNode;
        ClosureRewriteModule.markConstAndCopyJsDoc(jsdocNode, jsdocNode);
        if (!this.currentScript.hasCreatedExportObject) {
            this.exportTheEmptyBinaryNamespaceAt(NodeUtil.getEnclosingStatement(parent), AddAt.BEFORE);
        }
    }

    private void maybeUpdateTopLevelName(NodeTraversal t, Node nameNode) {
        Node destructuringLhsNode;
        String name = nameNode.getString();
        if (!this.currentScript.isModule || !this.currentScript.topLevelNames.contains(name)) {
            return;
        }
        Var var = (Var)t.getScope().getVar(name);
        if (var == null || ((Scope)var.getScope()).getRootNode() != this.currentScript.rootNode) {
            return;
        }
        if (var.getNameNode() == nameNode && nameNode.getParent().isStringKey() && nameNode.getGrandparent().isObjectPattern() && (ClosureRewriteModule.isCallTo((destructuringLhsNode = nameNode.getGrandparent().getParent()).getLastChild(), GOOG_REQUIRE) || ClosureRewriteModule.isCallTo(destructuringLhsNode.getLastChild(), GOOG_REQUIRETYPE))) {
            return;
        }
        boolean nameIsAnAlias = this.currentScript.namesToInlineByAlias.containsKey(name);
        if (nameIsAnAlias && var.getNode() != nameNode) {
            this.maybeAddAliasToSymbolTable(nameNode, this.currentScript.legacyNamespace);
            String namespaceToInline = this.currentScript.namesToInlineByAlias.get(name);
            if (namespaceToInline.equals(this.currentScript.getBinaryNamespace())) {
                this.currentScript.hasCreatedExportObject = true;
            }
            this.safeSetMaybeQualifiedString(nameNode, namespaceToInline);
            if (namespaceToInline.indexOf(46) != -1) {
                String firstQualifiedName = namespaceToInline.substring(0, namespaceToInline.indexOf(46));
                Var shadowedVar = (Var)t.getScope().getVar(firstQualifiedName);
                if (shadowedVar == null || shadowedVar.isGlobal() || ((Scope)shadowedVar.getScope()).isModuleScope()) {
                    return;
                }
                t.report(shadowedVar.getNode(), IMPORT_INLINING_SHADOWS_VAR, shadowedVar.getName(), namespaceToInline);
            }
            return;
        }
        this.safeSetString(nameNode, this.currentScript.contentsPrefix + name);
    }

    private void maybeUpdateExportObjectLiteral(NodeTraversal t, Node n) {
        if (!this.currentScript.isModule) {
            return;
        }
        Node parent = n.getParent();
        Node rhs = parent.getLastChild();
        if (rhs.isObjectLit()) {
            for (Node c = rhs.getFirstChild(); c != null; c = c.getNext()) {
                if (c.isComputedProp()) {
                    t.report(c, INVALID_EXPORT_COMPUTED_PROPERTY, new String[0]);
                    continue;
                }
                if (!c.isStringKey()) continue;
                if (!c.hasChildren()) {
                    c.addChildToBack(IR.name(c.getString()).useSourceInfoFrom(c));
                }
                Node value = c.getFirstChild();
                this.maybeUpdateExportDeclToNode(t, c, value);
            }
        }
    }

    private void maybeUpdateExportDeclToNode(NodeTraversal t, Node target, Node value) {
        if (!this.currentScript.isModule) {
            return;
        }
        if (value.isName()) {
            JSDocInfo info;
            StaticScope varScope;
            Scope currentScope = t.getScope();
            Var v = (Var)t.getScope().getVar(value.getString());
            if (v != null && ((AbstractScope)(varScope = v.getScope())).getDepth() == currentScope.getDepth() && (info = v.getJSDocInfo()) != null && info.hasTypedefType()) {
                JSDocInfoBuilder builder = JSDocInfoBuilder.copyFrom(info);
                target.setJSDocInfo(builder.build());
                return;
            }
        }
        ClosureRewriteModule.markConstAndCopyJsDoc(target, target);
    }

    private void maybeUpdateExportDeclaration(NodeTraversal t, Node n) {
        Node jsdocNode;
        if (!(this.currentScript.isModule && n.getString().equals("exports") && ClosureRewriteModule.isAssignTarget(n))) {
            return;
        }
        Node assignNode = n.getParent();
        if (!this.currentScript.declareLegacyNamespace && this.currentScript.defaultExportLocalName != null) {
            assignNode.getParent().detach();
            return;
        }
        Node rhs = assignNode.getLastChild();
        if (this.currentScript.declareLegacyNamespace) {
            Node legacyQname = NodeUtil.newQName(this.compiler, this.currentScript.legacyNamespace).srcrefTree(n);
            assignNode.replaceChild(n, legacyQname);
            jsdocNode = assignNode;
        } else {
            rhs.detach();
            Node exprResultNode = assignNode.getParent();
            Node binaryNamespaceName = IR.name(this.currentScript.getBinaryNamespace());
            binaryNamespaceName.setOriginalName(this.currentScript.legacyNamespace);
            Node exportsObjectCreationNode = IR.var(binaryNamespaceName, rhs);
            exportsObjectCreationNode.useSourceInfoIfMissingFromForTree(exprResultNode);
            exportsObjectCreationNode.putBooleanProp(Node.IS_NAMESPACE, true);
            exprResultNode.replaceWith(exportsObjectCreationNode);
            jsdocNode = exportsObjectCreationNode;
            this.currentScript.hasCreatedExportObject = true;
        }
        ClosureRewriteModule.markConstAndCopyJsDoc(assignNode, jsdocNode);
        this.compiler.reportChangeToEnclosingScope(jsdocNode);
        this.maybeUpdateExportObjectLiteral(t, rhs);
    }

    private void maybeUpdateExportNameRef(Node n) {
        if (!this.currentScript.isModule || !"exports".equals(n.getString()) || n.getParent() == null) {
            return;
        }
        if (n.getParent().isParamList()) {
            return;
        }
        if (this.currentScript.declareLegacyNamespace) {
            Node legacyQname = NodeUtil.newQName(this.compiler, this.currentScript.legacyNamespace).srcrefTree(n);
            n.replaceWith(legacyQname);
            this.compiler.reportChangeToEnclosingScope(legacyQname);
            return;
        }
        this.safeSetString(n, this.currentScript.getBinaryNamespace());
        Preconditions.checkState(this.currentScript.willCreateExportsObject || this.currentScript.hasCreatedExportObject);
    }

    void updateModuleBody(Node moduleBody) {
        Preconditions.checkArgument(moduleBody.isModuleBody() && moduleBody.getParent().getBooleanProp(Node.GOOG_MODULE), moduleBody);
        moduleBody.setToken(Token.BLOCK);
        NodeUtil.tryMergeBlock(moduleBody, true);
        this.updateEndModule();
        this.popScript();
    }

    private void updateEndModule() {
        for (ExportDefinition export : this.currentScript.exportsToInline.values()) {
            Node nameNode = export.nameDecl.getNameNode();
            this.safeSetMaybeQualifiedString(nameNode, this.currentScript.getBinaryNamespace() + export.getExportPostfix());
        }
        Preconditions.checkState(this.currentScript.isModule, this.currentScript);
        Preconditions.checkState(this.currentScript.declareLegacyNamespace || this.currentScript.hasCreatedExportObject, this.currentScript);
    }

    private void pushScript(ScriptDescription newCurrentScript) {
        this.currentScript = newCurrentScript;
        if (!this.scriptStack.isEmpty()) {
            ScriptDescription parentScript = this.scriptStack.peek();
            parentScript.addChildScript(this.currentScript);
        }
        this.scriptStack.addFirst(this.currentScript);
    }

    private void popScript() {
        this.scriptStack.removeFirst();
        this.currentScript = this.scriptStack.peekFirst();
    }

    private void exportTheEmptyBinaryNamespaceAt(Node atNode, AddAt addAt) {
        if (this.currentScript.declareLegacyNamespace) {
            return;
        }
        Node binaryNamespaceName = IR.name(this.currentScript.getBinaryNamespace());
        binaryNamespaceName.setOriginalName(this.currentScript.legacyNamespace);
        Node binaryNamespaceExportNode = IR.var(binaryNamespaceName, IR.objectlit(new Node[0]));
        if (addAt == AddAt.BEFORE) {
            atNode.getParent().addChildBefore(binaryNamespaceExportNode, atNode);
        } else if (addAt == AddAt.AFTER) {
            atNode.getParent().addChildAfter(binaryNamespaceExportNode, atNode);
        }
        binaryNamespaceExportNode.putBooleanProp(Node.IS_NAMESPACE, true);
        binaryNamespaceExportNode.srcrefTree(atNode);
        this.markConst(binaryNamespaceExportNode);
        this.compiler.reportChangeToEnclosingScope(binaryNamespaceExportNode);
        this.currentScript.hasCreatedExportObject = true;
    }

    static void checkAndSetStrictModeDirective(NodeTraversal t, Node n) {
        Preconditions.checkState(n.isScript(), n);
        Set<String> directives = n.getDirectives();
        if (directives != null && directives.contains("use strict")) {
            t.report(n, USELESS_USE_STRICT_DIRECTIVE, new String[0]);
        } else if (directives == null) {
            n.setDirectives(USE_STRICT_ONLY);
        } else {
            ImmutableCollection.Builder builder = new ImmutableSet.Builder().add("use strict");
            ((ImmutableSet.Builder)builder).addAll(directives);
            n.setDirectives((Set<String>)((Object)((ImmutableSet.Builder)builder).build()));
        }
    }

    private void markConst(Node n) {
        JSDocInfoBuilder builder = JSDocInfoBuilder.maybeCopyFrom(n.getJSDocInfo());
        builder.recordConstancy();
        n.setJSDocInfo(builder.build());
    }

    private void maybeSplitMultiVar(Node rhsNode) {
        Node statementNode = rhsNode.getGrandparent();
        if (!statementNode.isVar() || !statementNode.hasMoreThanOneChild()) {
            return;
        }
        Node nameNode = rhsNode.getParent();
        nameNode.detach();
        rhsNode.detach();
        statementNode.getParent().addChildBefore(IR.var(nameNode, rhsNode), statementNode);
    }

    private static void markConstAndCopyJsDoc(Node from, Node target) {
        JSDocInfo info = from.getJSDocInfo();
        JSDocInfoBuilder builder = JSDocInfoBuilder.maybeCopyFrom(info);
        builder.recordConstancy();
        target.setJSDocInfo(builder.build());
    }

    private void recordExportToInline(ExportDefinition exportDefinition) {
        Preconditions.checkState(exportDefinition.hasInlinableName(this.currentScript.exportsToInline.keySet()), "exportDefinition: %s\n\nexportsToInline keys: %s", (Object)exportDefinition, this.currentScript.exportsToInline.keySet());
        Preconditions.checkState(null == this.currentScript.exportsToInline.put(exportDefinition.nameDecl, exportDefinition), "Already found a mapping for inlining export: %s", (Object)exportDefinition.nameDecl);
        String localName = exportDefinition.getLocalName();
        String fullExportedName = this.currentScript.getBinaryNamespace() + exportDefinition.getExportPostfix();
        this.recordNameToInline(localName, fullExportedName);
    }

    private void recordNameToInline(String aliasName, String legacyNamespace) {
        Preconditions.checkNotNull(aliasName);
        Preconditions.checkNotNull(legacyNamespace);
        Preconditions.checkState(null == this.currentScript.namesToInlineByAlias.put(aliasName, legacyNamespace), "Already found a mapping for inlining short name: %s", (Object)aliasName);
    }

    private void reportUnrecognizedRequires() {
        for (UnrecognizedRequire unrecognizedRequire : this.unrecognizedRequires) {
            String legacyNamespace = unrecognizedRequire.legacyNamespace;
            Node requireNode = unrecognizedRequire.requireNode;
            boolean targetGoogModuleExists = this.rewriteState.containsModule(legacyNamespace);
            boolean targetLegacyScriptExists = this.rewriteState.legacyScriptNamespaces.contains(legacyNamespace);
            if (!targetGoogModuleExists && !targetLegacyScriptExists) {
                Node changeScope;
                this.compiler.report(JSError.make(requireNode, ClosurePrimitiveErrors.MISSING_MODULE_OR_PROVIDE, legacyNamespace));
                if (this.preserveSugar || (changeScope = NodeUtil.getEnclosingChangeScopeRoot(requireNode)) == null) continue;
                this.compiler.reportChangeToChangeScope(changeScope);
                NodeUtil.getEnclosingStatement(requireNode).detach();
                continue;
            }
            if (!unrecognizedRequire.mustBeOrdered) continue;
            this.compiler.report(JSError.make(requireNode, LATE_PROVIDE_ERROR, legacyNamespace));
        }
        this.unrecognizedRequires.clear();
    }

    private void safeSetString(Node n, String newString) {
        Node changeScope;
        if (n.getString().equals(newString)) {
            return;
        }
        String originalName = n.getString();
        n.setString(newString);
        if (n.getOriginalName() == null) {
            n.setOriginalName(originalName);
        }
        if ((changeScope = NodeUtil.getEnclosingChangeScopeRoot(n)) != null) {
            this.compiler.reportChangeToChangeScope(changeScope);
        }
    }

    private void safeSetMaybeQualifiedString(Node nameNode, String newString) {
        if (!newString.contains(".")) {
            this.safeSetString(nameNode, newString);
            return;
        }
        Node nameParent = nameNode.getParent();
        JSDocInfo jsdoc = nameParent.getJSDocInfo();
        switch (nameParent.getToken()) {
            case CLASS: 
            case FUNCTION: {
                if (!NodeUtil.isStatement(nameParent) || nameParent.getFirstChild() != nameNode) break;
                Node statementParent = nameParent.getParent();
                Node placeholder = IR.empty();
                statementParent.replaceChild(nameParent, placeholder);
                Node newStatement = NodeUtil.newQNameDeclaration(this.compiler, newString, nameParent, jsdoc);
                nameParent.setJSDocInfo(null);
                newStatement.useSourceInfoIfMissingFromForTree(nameParent);
                this.replaceStringNodeLocationForExportedTopLevelVariable(newStatement, nameNode.getSourcePosition(), nameNode.getLength());
                statementParent.replaceChild(placeholder, newStatement);
                NodeUtil.removeName(nameParent);
                return;
            }
            case CONST: 
            case LET: 
            case VAR: {
                Node rhs = nameNode.hasChildren() ? nameNode.getLastChild().detach() : null;
                Node newStatement = NodeUtil.newQNameDeclaration(this.compiler, newString, rhs, jsdoc);
                newStatement.useSourceInfoIfMissingFromForTree(nameParent);
                int nameLength = nameNode.getOriginalName() != null ? nameNode.getOriginalName().length() : nameNode.getString().length();
                this.replaceStringNodeLocationForExportedTopLevelVariable(newStatement, nameNode.getSourcePosition(), nameLength);
                NodeUtil.replaceDeclarationChild(nameNode, newStatement);
                return;
            }
            case OBJECT_PATTERN: 
            case ARRAY_PATTERN: 
            case PARAM_LIST: {
                throw new RuntimeException("Not supported");
            }
        }
        Node newQualifiedNameNode = NodeUtil.newQName(this.compiler, newString);
        newQualifiedNameNode.srcrefTree(nameNode);
        nameParent.replaceChild(nameNode, newQualifiedNameNode);
        if (newQualifiedNameNode.getFirstChild() != null) {
            newQualifiedNameNode.getFirstChild().makeNonIndexableRecursive();
        }
        this.compiler.reportChangeToEnclosingScope(newQualifiedNameNode);
    }

    private void replaceStringNodeLocationForExportedTopLevelVariable(Node n, int sourcePosition, int length) {
        Node getProp;
        Node assign;
        if (n.hasOneChild() && (assign = n.getFirstChild()) != null && assign.isAssign() && (getProp = assign.getFirstChild()) != null && getProp.isGetProp()) {
            for (Node child : getProp.children()) {
                child.setSourceEncodedPosition(sourcePosition);
                child.setLength(length);
            }
        }
    }

    private boolean isTopLevel(NodeTraversal t, Node n, ScopeType scopeType) {
        if (scopeType == ScopeType.EXEC_CONTEXT) {
            return t.getClosestHoistScopeRoot() == this.currentScript.rootNode;
        }
        return n.getParent() == this.currentScript.rootNode;
    }

    private static String toModuleContentsPrefix(String legacyNamespace) {
        return MODULE_CONTENTS_PREFIX + legacyNamespace.replace('.', '$') + "_";
    }

    public static boolean isModuleExport(String name) {
        return name.startsWith(MODULE_EXPORTS_PREFIX);
    }

    public static boolean isModuleContent(String name) {
        return name.startsWith(MODULE_CONTENTS_PREFIX);
    }

    private static boolean isExportPropertyAssignment(Node n) {
        Node target = n.getFirstChild();
        return (ClosureRewriteModule.isAssignTarget(n) || ClosureRewriteModule.isTypedefTarget(n)) && target.isName() && target.getString().equals("exports");
    }

    private static boolean isAssignTarget(Node n) {
        Node parent = n.getParent();
        return parent.isAssign() && parent.getFirstChild() == n;
    }

    private static boolean isTypedefTarget(Node n) {
        Node parent = n.getParent();
        return parent.isExprResult() && parent.getFirstChild() == n;
    }

    private void maybeAddToSymbolTable(Node n) {
        if (this.preprocessorSymbolTable != null) {
            this.preprocessorSymbolTable.addReference(n);
        }
    }

    private void maybeAddAliasToSymbolTable(Node n, String module) {
        if (this.preprocessorSymbolTable != null) {
            n.putBooleanProp(Node.MODULE_ALIAS, true);
            String nodeName = n.getToken() == Token.STRING ? n.getString() : this.preprocessorSymbolTable.getQualifiedName(n);
            String name = "alias_" + module + "_" + nodeName;
            this.preprocessorSymbolTable.addReference(n, name);
        }
    }

    private static Node createNamespaceNode(Node n) {
        Node node = Node.newString(n.getString()).useSourceInfoFrom(n);
        node.putBooleanProp(Node.IS_MODULE_NAME, true);
        return node;
    }

    private static boolean isCallTo(Node n, Node targetMethod) {
        if (!n.isCall()) {
            return false;
        }
        Node method = n.getFirstChild();
        return method.isGetProp() && method.matchesQualifiedName(targetMethod);
    }

    private class UnwrapGoogLoadModule
    extends NodeTraversal.AbstractPreOrderCallback {
        private UnwrapGoogLoadModule() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case ROOT: 
                case SCRIPT: {
                    return true;
                }
                case EXPR_RESULT: {
                    Node call = n.getFirstChild();
                    if (ClosureRewriteModule.isCallTo(call, GOOG_LOADMODULE) && call.getLastChild().isFunction()) {
                        parent.putBooleanProp(Node.GOOG_MODULE, true);
                        Node functionNode = call.getLastChild();
                        ClosureRewriteModule.this.compiler.reportFunctionDeleted(functionNode);
                        Node moduleBody = functionNode.getLastChild().detach();
                        moduleBody.setToken(Token.MODULE_BODY);
                        n.replaceWith(moduleBody);
                        Node returnNode = moduleBody.getLastChild();
                        Preconditions.checkState(returnNode.isReturn(), returnNode);
                        returnNode.detach();
                    }
                    return false;
                }
            }
            return false;
        }
    }

    static class GlobalRewriteState {
        private final Map<String, ScriptDescription> scriptDescriptionsByGoogModuleNamespace = new HashMap<String, ScriptDescription>();
        private final Multimap<Node, String> legacyNamespacesByScriptNode = HashMultimap.create();
        private final Set<String> legacyScriptNamespaces = new HashSet<String>();

        GlobalRewriteState() {
        }

        boolean containsModule(String legacyNamespace) {
            return this.scriptDescriptionsByGoogModuleNamespace.containsKey(legacyNamespace);
        }

        boolean isLegacyModule(String legacyNamespace) {
            Preconditions.checkArgument(this.containsModule(legacyNamespace));
            return this.scriptDescriptionsByGoogModuleNamespace.get((Object)legacyNamespace).declareLegacyNamespace;
        }

        @Nullable
        String getBinaryNamespace(String legacyNamespace) {
            ScriptDescription script = this.scriptDescriptionsByGoogModuleNamespace.get(legacyNamespace);
            return script == null ? null : script.getBinaryNamespace();
        }

        @Nullable
        private String getExportedNamespaceOrScript(String legacyNamespace) {
            if (this.legacyScriptNamespaces.contains(legacyNamespace)) {
                return legacyNamespace;
            }
            ScriptDescription script = this.scriptDescriptionsByGoogModuleNamespace.get(legacyNamespace);
            return script == null ? null : script.getExportedNamespace();
        }

        void removeRoot(Node toRemove) {
            if (this.legacyNamespacesByScriptNode.containsKey(toRemove)) {
                this.scriptDescriptionsByGoogModuleNamespace.keySet().removeAll(this.legacyNamespacesByScriptNode.removeAll(toRemove));
            }
        }
    }

    private class ScriptUpdater
    implements NodeTraversal.ScopedCallback {
        private ScriptUpdater() {
        }

        @Override
        public void enterScope(NodeTraversal t) {
            t.getScope();
        }

        @Override
        public void exitScope(NodeTraversal t) {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case MODULE_BODY: {
                    if (parent.getBooleanProp(Node.GOOG_MODULE)) {
                        ClosureRewriteModule.this.updateModuleBodyEarly(n);
                        break;
                    }
                    return false;
                }
                case CALL: {
                    Node method = n.getFirstChild();
                    if (!method.isGetProp()) break;
                    if (method.matchesQualifiedName(GOOG_MODULE)) {
                        ClosureRewriteModule.this.updateGoogModule(n);
                        break;
                    }
                    if (method.matchesQualifiedName(GOOG_MODULE_DECLARELEGACYNAMESPACE)) {
                        ClosureRewriteModule.this.updateGoogDeclareLegacyNamespace(n);
                        break;
                    }
                    if (method.matchesQualifiedName(GOOG_REQUIRE) || method.matchesQualifiedName(GOOG_REQUIRETYPE)) {
                        ClosureRewriteModule.this.updateGoogRequire(t, n);
                        break;
                    }
                    if (method.matchesQualifiedName(GOOG_FORWARDDECLARE) && !parent.isExprResult()) {
                        ClosureRewriteModule.this.updateGoogForwardDeclare(t, n);
                        break;
                    }
                    if (!method.matchesQualifiedName(GOOG_MODULE_GET)) break;
                    ClosureRewriteModule.this.updateGoogModuleGetCall(n);
                    break;
                }
                case GETPROP: {
                    if (!ClosureRewriteModule.isExportPropertyAssignment(n)) break;
                    ClosureRewriteModule.this.updateExportsPropertyAssignment(n);
                    break;
                }
            }
            if (n.getJSDocInfo() != null) {
                ClosureRewriteModule.this.rewriteJsdoc(n.getJSDocInfo());
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case MODULE_BODY: {
                    ClosureRewriteModule.this.updateModuleBody(n);
                    break;
                }
                case NAME: {
                    ClosureRewriteModule.this.maybeUpdateTopLevelName(t, n);
                    ClosureRewriteModule.this.maybeUpdateExportDeclaration(t, n);
                    ClosureRewriteModule.this.maybeUpdateExportNameRef(n);
                    break;
                }
            }
        }
    }

    private class ScriptRecorder
    implements NodeTraversal.Callback {
        private ScriptRecorder() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case MODULE_BODY: {
                    ClosureRewriteModule.this.recordModuleBody(n);
                    break;
                }
                case CALL: {
                    Node method = n.getFirstChild();
                    if (!method.isGetProp()) break;
                    if (method.matchesQualifiedName(GOOG_MODULE)) {
                        ClosureRewriteModule.this.recordGoogModule(t, n);
                        break;
                    }
                    if (method.matchesQualifiedName(GOOG_MODULE_DECLARELEGACYNAMESPACE)) {
                        ClosureRewriteModule.this.recordGoogDeclareLegacyNamespace();
                        break;
                    }
                    if (method.matchesQualifiedName(GOOG_PROVIDE)) {
                        ClosureRewriteModule.this.recordGoogProvide(t, n);
                        break;
                    }
                    if (method.matchesQualifiedName(GOOG_REQUIRE)) {
                        ClosureRewriteModule.this.recordGoogRequire(t, n, true);
                        break;
                    }
                    if (method.matchesQualifiedName(GOOG_REQUIRETYPE)) {
                        ClosureRewriteModule.this.recordGoogRequireType(t, n);
                        break;
                    }
                    if (method.matchesQualifiedName(GOOG_FORWARDDECLARE) && !parent.isExprResult()) {
                        ClosureRewriteModule.this.recordGoogForwardDeclare(t, n);
                        break;
                    }
                    if (!method.matchesQualifiedName(GOOG_MODULE_GET)) break;
                    ClosureRewriteModule.this.recordGoogModuleGet(t, n);
                    break;
                }
                case CLASS: 
                case FUNCTION: {
                    if (!ClosureRewriteModule.this.isTopLevel(t, n, ScopeType.BLOCK)) break;
                    ClosureRewriteModule.this.recordTopLevelClassOrFunctionName(n);
                    break;
                }
                case CONST: 
                case LET: 
                case VAR: {
                    if (!ClosureRewriteModule.this.isTopLevel(t, n, n.isVar() ? ScopeType.EXEC_CONTEXT : ScopeType.BLOCK)) break;
                    ClosureRewriteModule.this.recordTopLevelVarNames(n);
                    break;
                }
                case GETPROP: {
                    if (!ClosureRewriteModule.isExportPropertyAssignment(n)) break;
                    ClosureRewriteModule.this.recordExportsPropertyAssignment(t, n);
                    break;
                }
                case NAME: {
                    ClosureRewriteModule.this.maybeRecordExportDeclaration(t, n);
                    break;
                }
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isModuleBody()) {
                ClosureRewriteModule.this.popScript();
            }
        }
    }

    private class ScriptPreprocessor
    extends NodeTraversal.AbstractPreOrderCallback {
        private ScriptPreprocessor() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case ROOT: 
                case MODULE_BODY: {
                    return true;
                }
                case SCRIPT: {
                    if (NodeUtil.isGoogModuleFile(n)) {
                        ClosureRewriteModule.checkAndSetStrictModeDirective(t, n);
                    }
                    return true;
                }
                case NAME: {
                    ClosureRewriteModule.this.preprocessExportDeclaration(n);
                    return true;
                }
            }
            return !parent.isScript();
        }
    }

    private static final class ScriptDescription {
        boolean isModule;
        boolean declareLegacyNamespace;
        String legacyNamespace;
        String contentsPrefix;
        final Set<String> topLevelNames = new HashSet<String>();
        final Deque<ScriptDescription> childScripts = new ArrayDeque<ScriptDescription>();
        final Map<String, String> namesToInlineByAlias = new HashMap<String, String>();
        boolean willCreateExportsObject;
        boolean hasCreatedExportObject;
        Node defaultExportRhs;
        String defaultExportLocalName;
        Set<String> namedExports = new HashSet<String>();
        Map<Var, ExportDefinition> exportsToInline = new HashMap<Var, ExportDefinition>();
        Node rootNode;

        private ScriptDescription() {
        }

        public void addChildScript(ScriptDescription childScript) {
            this.childScripts.addLast(childScript);
        }

        public ScriptDescription removeFirstChildScript() {
            return this.childScripts.removeFirst();
        }

        @Nullable
        String getBinaryNamespace() {
            if (!this.isModule || this.declareLegacyNamespace) {
                return null;
            }
            return ClosureRewriteModule.getBinaryModuleNamespace(this.legacyNamespace);
        }

        @Nullable
        String getExportedNamespace() {
            if (this.declareLegacyNamespace) {
                return this.legacyNamespace;
            }
            return this.getBinaryNamespace();
        }
    }

    private static final class ExportDefinition {
        @Nullable
        String exportName;
        @Nullable
        Node rhs;
        @Nullable
        Var nameDecl;
        private static final ImmutableSet<Token> INLINABLE_NAME_PARENTS = ImmutableSet.of(Token.VAR, Token.CONST, Token.LET, Token.FUNCTION, Token.CLASS);

        private ExportDefinition() {
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("exportName", this.exportName).add("rhs", this.rhs).add("nameDecl", this.nameDecl).omitNullValues().toString();
        }

        static ExportDefinition newDefaultExport(NodeTraversal t, Node rhs) {
            return ExportDefinition.newNamedExport(t, null, rhs);
        }

        static ExportDefinition newNamedExport(NodeTraversal t, String name, Node rhs) {
            ExportDefinition newExport = new ExportDefinition();
            newExport.exportName = name;
            newExport.rhs = rhs;
            if (rhs != null && (rhs.isName() || rhs.isStringKey())) {
                newExport.nameDecl = (Var)t.getScope().getVar(rhs.getString());
            }
            return newExport;
        }

        String getExportPostfix() {
            if (this.exportName == null) {
                return "";
            }
            return "." + this.exportName;
        }

        boolean hasInlinableName(Set<Var> exportedNames) {
            if (this.nameDecl == null || exportedNames.contains(this.nameDecl) || !INLINABLE_NAME_PARENTS.contains((Object)this.nameDecl.getParentNode().getToken())) {
                return false;
            }
            Node initialValue = this.nameDecl.getInitialValue();
            if (initialValue == null || !initialValue.isCall()) {
                return true;
            }
            Node method = initialValue.getFirstChild();
            if (!method.isGetProp()) {
                return true;
            }
            Node maybeGoog = method.getFirstChild();
            if (!maybeGoog.isName() || !maybeGoog.getString().equals("goog")) {
                return true;
            }
            String name = maybeGoog.getNext().getString();
            return !name.equals("require") && !name.equals("forwardDeclare") && !name.equals("getMsg");
        }

        String getLocalName() {
            return this.nameDecl.getName();
        }
    }

    private static final class UnrecognizedRequire {
        final Node requireNode;
        final String legacyNamespace;
        final boolean mustBeOrdered;

        UnrecognizedRequire(Node requireNode, String legacyNamespace, boolean mustBeOrdered) {
            this.requireNode = requireNode;
            this.legacyNamespace = legacyNamespace;
            this.mustBeOrdered = mustBeOrdered;
        }
    }

    private static enum ScopeType {
        EXEC_CONTEXT,
        BLOCK;

    }

    private static enum AddAt {
        BEFORE,
        AFTER;

    }
}

