/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.threadsafe;

import flash.tools.debugger.NoResponseException;
import flash.tools.debugger.NotConnectedException;
import flash.tools.debugger.NotSuspendedException;
import flash.tools.debugger.Session;
import flash.tools.debugger.Value;
import flash.tools.debugger.Variable;
import flash.tools.debugger.threadsafe.ThreadSafeDebuggerObject;
import flash.tools.debugger.threadsafe.ThreadSafeSession;
import flash.tools.debugger.threadsafe.ThreadSafeVariable;

public class ThreadSafeValue
extends ThreadSafeDebuggerObject
implements Value {
    private Value fVal;

    private ThreadSafeValue(Object object, Value value) {
        super(object);
        this.fVal = value;
    }

    public static ThreadSafeValue wrap(Object object, Value value) {
        if (value != null) {
            return new ThreadSafeValue(object, value);
        }
        return null;
    }

    public static ThreadSafeValue[] wrapArray(Object object, Value[] valueArray) {
        ThreadSafeValue[] threadSafeValueArray = new ThreadSafeValue[valueArray.length];
        for (int i = 0; i < valueArray.length; ++i) {
            threadSafeValueArray[i] = ThreadSafeValue.wrap(object, valueArray[i]);
        }
        return threadSafeValueArray;
    }

    public static Value getRaw(Value value) {
        if (value instanceof ThreadSafeValue) {
            return ((ThreadSafeValue)value).fVal;
        }
        return value;
    }

    public static Object getSyncObject(Value value) {
        return ((ThreadSafeValue)value).getSyncObject();
    }

    public boolean equals(Object object) {
        if (object instanceof Value) {
            return this.fVal.equals(ThreadSafeValue.getRaw((Value)object));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAttributes() {
        Object object = this.getSyncObject();
        synchronized (object) {
            return this.fVal.getAttributes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getClassName() {
        Object object = this.getSyncObject();
        synchronized (object) {
            return this.fVal.getClassName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getId() {
        Object object = this.getSyncObject();
        synchronized (object) {
            return this.fVal.getId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMemberCount(Session session) throws NotSuspendedException, NoResponseException, NotConnectedException {
        Object object = this.getSyncObject();
        synchronized (object) {
            return this.fVal.getMemberCount(ThreadSafeSession.getRaw(session));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Variable getMemberNamed(Session session, String string) throws NotSuspendedException, NoResponseException, NotConnectedException {
        Object object = this.getSyncObject();
        synchronized (object) {
            return ThreadSafeVariable.wrap(this.getSyncObject(), this.fVal.getMemberNamed(ThreadSafeSession.getRaw(session), string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Variable[] getMembers(Session session) throws NotSuspendedException, NoResponseException, NotConnectedException {
        Object object = this.getSyncObject();
        synchronized (object) {
            return ThreadSafeVariable.wrapArray(this.getSyncObject(), this.fVal.getMembers(ThreadSafeSession.getRaw(session)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getType() {
        Object object = this.getSyncObject();
        synchronized (object) {
            return this.fVal.getType();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTypeName() {
        Object object = this.getSyncObject();
        synchronized (object) {
            return this.fVal.getTypeName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAsObject() {
        Object object = this.getSyncObject();
        synchronized (object) {
            return this.fVal.getValueAsObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getValueAsString() {
        Object object = this.getSyncObject();
        synchronized (object) {
            return this.fVal.getValueAsString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAttributeSet(int n) {
        Object object = this.getSyncObject();
        synchronized (object) {
            return this.fVal.isAttributeSet(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getClassHierarchy(boolean bl) {
        Object object = this.getSyncObject();
        synchronized (object) {
            return this.fVal.getClassHierarchy(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.getSyncObject();
        synchronized (object) {
            return this.fVal.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Variable[] getPrivateInheritedMembers() {
        Object object = this.getSyncObject();
        synchronized (object) {
            return ThreadSafeVariable.wrapArray(this.getSyncObject(), this.fVal.getPrivateInheritedMembers());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Variable[] getPrivateInheritedMemberNamed(String string) {
        Object object = this.getSyncObject();
        synchronized (object) {
            return ThreadSafeVariable.wrapArray(this.getSyncObject(), this.fVal.getPrivateInheritedMemberNamed(string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIsolateId() {
        Object object = this.getSyncObject();
        synchronized (object) {
            return this.fVal.getIsolateId();
        }
    }
}

