/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.mxml;

import java.util.ArrayList;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.tree.mxml.MXMLArrayNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLInstanceNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLModelRootNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLObjectNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLPropertySpecifierNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLRemoteObjectMethodNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.mxml.IMXMLModelPropertyContainerNode;
import org.apache.royale.compiler.tree.mxml.IMXMLModelPropertyNode;
import org.apache.royale.compiler.tree.mxml.IMXMLNode;
import org.apache.royale.compiler.tree.mxml.IMXMLRemoteObjectMethodArgumentsPropertyNode;

class MXMLRemoteObjectMethodArgumentsPropertyNode
extends MXMLPropertySpecifierNode
implements IMXMLRemoteObjectMethodArgumentsPropertyNode {
    private final MXMLObjectNode objectNode = new MXMLObjectNode(this);

    MXMLRemoteObjectMethodArgumentsPropertyNode(MXMLRemoteObjectMethodNode parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLPropertySpecifierID;
    }

    @Override
    public int getChildCount() {
        return this.objectNode != null ? 1 : 0;
    }

    @Override
    public IASNode getChild(int i) {
        if (i != 0) {
            throw new IndexOutOfBoundsException("Arguments node only have one child node.");
        }
        return this.objectNode;
    }

    @Override
    protected void initializeFromTag(MXMLTreeBuilder builder, IMXMLTagData tag) {
        this.setLocation(tag);
        MXMLNodeBase.MXMLNodeInfo info = this.createNodeInfo(builder);
        MXMLModelRootNode modelRootNode = new MXMLModelRootNode(this);
        modelRootNode.initializeFromTag(builder, tag);
        RoyaleProject project = builder.getProject();
        for (MXMLPropertySpecifierNode specifierNode : this.getPropertySpecifiers(builder, modelRootNode, this.objectNode, this, project)) {
            info.addChildNode(specifierNode);
        }
        this.initializationComplete(builder, tag, info);
    }

    protected MXMLPropertySpecifierNode[] getPropertySpecifiers(MXMLTreeBuilder builder, IMXMLModelPropertyContainerNode containerNode, MXMLObjectNode parentNode, MXMLPropertySpecifierNode parentSpecifierNode, RoyaleProject project) {
        ArrayList<MXMLPropertySpecifierNode> propSpecifiers = new ArrayList<MXMLPropertySpecifierNode>();
        for (String propertyName : containerNode.getPropertyNames()) {
            IMXMLModelPropertyNode[] propertyNodes = containerNode.getPropertyNodes(propertyName);
            MXMLPropertySpecifierNode specifierNode = this.getPropertySpecifier(builder, propertyName, propertyNodes, parentNode, parentSpecifierNode, project);
            propSpecifiers.add(specifierNode);
        }
        return propSpecifiers.toArray(new MXMLPropertySpecifierNode[0]);
    }

    protected MXMLPropertySpecifierNode getPropertySpecifier(MXMLTreeBuilder builder, String propertyName, IMXMLModelPropertyNode[] propertyNodes, MXMLObjectNode parentNode, MXMLPropertySpecifierNode parentSpecifierNode, RoyaleProject project) {
        MXMLPropertySpecifierNode specifierNode = new MXMLPropertySpecifierNode(parentNode);
        specifierNode.setDynamicName(propertyName);
        if (propertyNodes.length > 1) {
            MXMLArrayNode argsArrayNode = new MXMLArrayNode(this);
            argsArrayNode.setClassReference(project, "Array");
            ArrayList<MXMLInstanceNode> argsChildNodes = new ArrayList<MXMLInstanceNode>();
            for (IMXMLModelPropertyNode propNode : propertyNodes) {
                if (propNode.hasLeafValue()) {
                    MXMLInstanceNode propInstanceNode = (MXMLInstanceNode)propNode.getInstanceNode();
                    propInstanceNode.setParent(argsArrayNode);
                    argsChildNodes.add(propInstanceNode);
                    continue;
                }
                MXMLObjectNode propObjectNode = new MXMLObjectNode(this);
                propObjectNode.setLocation(propNode);
                propObjectNode.setClassReference(project, "Object");
                IMXMLNode[] propSpecifiers = this.getPropertySpecifiers(builder, propNode, propObjectNode, specifierNode, project);
                propObjectNode.setChildren(propSpecifiers);
                argsChildNodes.add(propObjectNode);
            }
            argsArrayNode.setChildren(argsChildNodes.toArray(new IMXMLNode[0]));
            specifierNode.setInstanceNode(argsArrayNode);
        } else {
            IMXMLModelPropertyNode propNode = propertyNodes[0];
            if (propNode.hasLeafValue()) {
                MXMLInstanceNode propInstanceNode = (MXMLInstanceNode)propNode.getInstanceNode();
                propInstanceNode.setParent(parentSpecifierNode);
                specifierNode.setLocation(propNode);
                specifierNode.setInstanceNode(propInstanceNode);
            } else {
                MXMLObjectNode propObjectNode = new MXMLObjectNode(this);
                propObjectNode.setLocation(propNode);
                propObjectNode.setClassReference(project, "Object");
                IMXMLNode[] propSpecifiers = this.getPropertySpecifiers(builder, propNode, propObjectNode, specifierNode, project);
                propObjectNode.setChildren(propSpecifiers);
                specifierNode.setInstanceNode(propObjectNode);
            }
        }
        return specifierNode;
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, IMXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        this.initializeObjectNode(builder, tag, info);
        this.setInstanceNode(this.objectNode);
        super.initializationComplete(builder, tag, info);
    }

    private void initializeObjectNode(MXMLTreeBuilder builder, IMXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        RoyaleProject project = builder.getProject();
        this.objectNode.setClassReference(project, "Object");
        this.objectNode.setChildren(info.getChildNodeList().toArray(new IMXMLNode[0]));
        this.objectNode.setLocation(tag);
    }
}

