/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.swc.io;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.DigestOutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.royale.compiler.filespecs.FileSpecification;
import org.apache.royale.swc.ISWC;
import org.apache.royale.swc.ISWCFileEntry;
import org.apache.royale.swc.ISWCLibrary;
import org.apache.royale.swc.io.SWCWriterBase;
import org.apache.royale.swf.ISWF;
import org.apache.royale.swf.io.ISWFWriter;
import org.apache.royale.swf.io.ISWFWriterFactory;
import org.apache.royale.swf.io.SizeReportWritingSWFWriter;

public class SWCWriter
extends SWCWriterBase {
    private final ZipOutputStream zipOutputStream;
    private long fileDate = System.currentTimeMillis();

    public SWCWriter(String filename, String swcDate, String swcDateFormat) throws FileNotFoundException {
        this(filename, true, true, false, swcDate, swcDateFormat, SizeReportWritingSWFWriter.getSWFWriterFactory(null));
    }

    public SWCWriter(String filename, boolean compressLibrarySWF, boolean enableDebug, boolean enableTelemetry, String metadataDate, String metadataFormat, ISWFWriterFactory swfWriterFactory) throws FileNotFoundException {
        super(compressLibrarySWF, enableDebug, enableTelemetry, swfWriterFactory);
        File outputFile = new File(filename);
        File outputDirectory = new File(outputFile.getAbsoluteFile().getParent());
        outputDirectory.mkdirs();
        if (metadataDate != null) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(metadataFormat);
                Date d = sdf.parse(metadataDate);
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(d);
                ZonedDateTime zdt = ZonedDateTime.of(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), 0, ZoneId.systemDefault());
                this.fileDate = zdt.toInstant().toEpochMilli();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e1) {
                e1.printStackTrace();
            }
        }
        this.zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(filename)));
        this.zipOutputStream.setLevel(0);
    }

    @Override
    void writeCatalog(ISWC swc) throws IOException {
        ZipEntry ze = new ZipEntry("catalog.xml");
        ze.setTime(this.fileDate);
        ze.setMethod(0);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter catalogXMLWriter = new OutputStreamWriter(baos);
        this.writeCatalogXML(swc, catalogXMLWriter);
        ((Writer)catalogXMLWriter).flush();
        ze.setSize(baos.size());
        ze.setCompressedSize(baos.size());
        CRC32 crc = new CRC32();
        crc.reset();
        crc.update(baos.toByteArray());
        ze.setCrc(crc.getValue());
        this.zipOutputStream.putNextEntry(ze);
        baos.writeTo(this.zipOutputStream);
        this.zipOutputStream.closeEntry();
    }

    @Override
    void writeLibrary(ISWCLibrary library) throws IOException {
        ISWF swf = library.getSWF();
        String path = library.getPath();
        assert (swf != null) : "Expect SWF model";
        assert (path != null) : "Expect SWF path";
        ZipEntry ze = new ZipEntry(path);
        ze.setTime(this.fileDate);
        ze.setMethod(0);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ISWFWriter swfWriter = this.swfWriterFactory.createSWFWriter(swf, this.getLibrarySWFCompression(), this.enableDebug, this.enableTelemetry);
        swfWriter.writeTo(baos);
        swfWriter.close();
        ze.setSize(baos.size());
        ze.setCompressedSize(baos.size());
        CRC32 crc = new CRC32();
        crc.reset();
        crc.update(baos.toByteArray());
        ze.setCrc(crc.getValue());
        this.zipOutputStream.putNextEntry(ze);
        DigestOutputStream digestStream = this.getDigestOutputStream(library, this.zipOutputStream);
        baos.writeTo(digestStream != null ? digestStream : this.zipOutputStream);
        this.zipOutputStream.closeEntry();
        if (digestStream != null) {
            this.addDigestToLibrary(digestStream, library);
        }
    }

    @Override
    void writeFile(ISWCFileEntry fileEntry) throws IOException {
        ZipEntry ze = new ZipEntry(fileEntry.getPath());
        ze.setTime(this.fileDate);
        ze.setMethod(0);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream fileInputStream = fileEntry.createInputStream();
        String name = fileEntry.getPath();
        if (name.endsWith(".css")) {
            FileSpecification.NoCRLFInputStream filteredInputStream = new FileSpecification.NoCRLFInputStream(fileInputStream);
            IOUtils.copy((InputStream)filteredInputStream, (OutputStream)baos);
            filteredInputStream.close();
        } else {
            IOUtils.copy((InputStream)fileInputStream, (OutputStream)baos);
            fileInputStream.close();
        }
        ze.setSize(baos.size());
        ze.setCompressedSize(baos.size());
        CRC32 crc = new CRC32();
        crc.reset();
        crc.update(baos.toByteArray());
        ze.setCrc(crc.getValue());
        this.zipOutputStream.putNextEntry(ze);
        baos.writeTo(this.zipOutputStream);
        this.zipOutputStream.closeEntry();
    }

    @Override
    void prepare(ISWC swc) {
    }

    @Override
    void finish(ISWC swc) throws IOException {
        this.zipOutputStream.flush();
        this.zipOutputStream.close();
    }
}

