/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.microsoft.playwright.Locator;
import com.microsoft.playwright.assertions.LocatorAssertions;
import com.microsoft.playwright.impl.AssertionsBase;
import com.microsoft.playwright.impl.ExpectedTextValue;
import com.microsoft.playwright.impl.FrameExpectOptions;
import com.microsoft.playwright.impl.LocatorImpl;
import com.microsoft.playwright.impl.Serialization;
import com.microsoft.playwright.impl.Utils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class LocatorAssertionsImpl
extends AssertionsBase
implements LocatorAssertions {
    public LocatorAssertionsImpl(Locator locator) {
        this(locator, false);
    }

    private LocatorAssertionsImpl(Locator locator, boolean isNot) {
        super((LocatorImpl)locator, isNot);
    }

    @Override
    public void containsText(String text, LocatorAssertions.ContainsTextOptions options) {
        ExpectedTextValue expected = new ExpectedTextValue();
        expected.string = text;
        expected.ignoreCase = LocatorAssertionsImpl.shouldIgnoreCase(options);
        expected.matchSubstring = true;
        expected.normalizeWhiteSpace = true;
        this.expectImpl("to.have.text", expected, (Object)text, "Locator expected to contain text", Utils.convertType(options, FrameExpectOptions.class));
    }

    @Override
    public void containsText(Pattern pattern, LocatorAssertions.ContainsTextOptions options) {
        ExpectedTextValue expected = LocatorAssertionsImpl.expectedRegex(pattern);
        expected.ignoreCase = LocatorAssertionsImpl.shouldIgnoreCase(options);
        expected.matchSubstring = true;
        expected.normalizeWhiteSpace = true;
        this.expectImpl("to.have.text", expected, (Object)pattern, "Locator expected to contain regex", Utils.convertType(options, FrameExpectOptions.class));
    }

    @Override
    public void containsText(String[] strings, LocatorAssertions.ContainsTextOptions options) {
        ArrayList<ExpectedTextValue> list = new ArrayList<ExpectedTextValue>();
        for (String text : strings) {
            ExpectedTextValue expected = new ExpectedTextValue();
            expected.string = text;
            expected.ignoreCase = LocatorAssertionsImpl.shouldIgnoreCase(options);
            expected.matchSubstring = true;
            expected.normalizeWhiteSpace = true;
            list.add(expected);
        }
        this.expectImpl("to.contain.text.array", list, (Object)strings, "Locator expected to contain text", Utils.convertType(options, FrameExpectOptions.class));
    }

    @Override
    public void containsText(Pattern[] patterns, LocatorAssertions.ContainsTextOptions options) {
        ArrayList<ExpectedTextValue> list = new ArrayList<ExpectedTextValue>();
        for (Pattern pattern : patterns) {
            ExpectedTextValue expected = LocatorAssertionsImpl.expectedRegex(pattern);
            expected.ignoreCase = LocatorAssertionsImpl.shouldIgnoreCase(options);
            expected.matchSubstring = true;
            expected.normalizeWhiteSpace = true;
            list.add(expected);
        }
        this.expectImpl("to.contain.text.array", list, (Object)patterns, "Locator expected to contain text", Utils.convertType(options, FrameExpectOptions.class));
    }

    @Override
    public void hasAttribute(String name, String text, LocatorAssertions.HasAttributeOptions options) {
        ExpectedTextValue expected = new ExpectedTextValue();
        expected.string = text;
        this.hasAttribute(name, expected, text, options);
    }

    @Override
    public void hasAttribute(String name, Pattern pattern, LocatorAssertions.HasAttributeOptions options) {
        ExpectedTextValue expected = LocatorAssertionsImpl.expectedRegex(pattern);
        this.hasAttribute(name, expected, pattern, options);
    }

    private void hasAttribute(String name, ExpectedTextValue expectedText, Object expectedValue, LocatorAssertions.HasAttributeOptions options) {
        if (options == null) {
            options = new LocatorAssertions.HasAttributeOptions();
        }
        FrameExpectOptions commonOptions = Utils.convertType(options, FrameExpectOptions.class);
        commonOptions.expressionArg = name;
        String message = "Locator expected to have attribute '" + name + "'";
        if (expectedValue instanceof Pattern) {
            message = message + " matching regex";
        }
        this.expectImpl("to.have.attribute", expectedText, expectedValue, message, commonOptions);
    }

    @Override
    public void hasClass(String text, LocatorAssertions.HasClassOptions options) {
        ExpectedTextValue expected = new ExpectedTextValue();
        expected.string = text;
        this.expectImpl("to.have.class", expected, (Object)text, "Locator expected to have class", Utils.convertType(options, FrameExpectOptions.class));
    }

    @Override
    public void hasClass(Pattern pattern, LocatorAssertions.HasClassOptions options) {
        ExpectedTextValue expected = LocatorAssertionsImpl.expectedRegex(pattern);
        this.expectImpl("to.have.class", expected, (Object)pattern, "Locator expected to have class matching regex", Utils.convertType(options, FrameExpectOptions.class));
    }

    @Override
    public void hasClass(String[] strings, LocatorAssertions.HasClassOptions options) {
        ArrayList<ExpectedTextValue> list = new ArrayList<ExpectedTextValue>();
        for (String text : strings) {
            ExpectedTextValue expected = new ExpectedTextValue();
            expected.string = text;
            list.add(expected);
        }
        this.expectImpl("to.have.class.array", list, (Object)strings, "Locator expected to have class", Utils.convertType(options, FrameExpectOptions.class));
    }

    @Override
    public void hasClass(Pattern[] patterns, LocatorAssertions.HasClassOptions options) {
        ArrayList<ExpectedTextValue> list = new ArrayList<ExpectedTextValue>();
        for (Pattern pattern : patterns) {
            ExpectedTextValue expected = LocatorAssertionsImpl.expectedRegex(pattern);
            list.add(expected);
        }
        this.expectImpl("to.have.class.array", list, (Object)patterns, "Locator expected to have class matching regex", Utils.convertType(options, FrameExpectOptions.class));
    }

    @Override
    public void hasCount(int count, LocatorAssertions.HasCountOptions options) {
        if (options == null) {
            options = new LocatorAssertions.HasCountOptions();
        }
        FrameExpectOptions commonOptions = Utils.convertType(options, FrameExpectOptions.class);
        commonOptions.expectedNumber = count;
        List<ExpectedTextValue> expectedText = null;
        this.expectImpl("to.have.count", expectedText, (Object)count, "Locator expected to have count", commonOptions);
    }

    @Override
    public void hasCSS(String name, String value, LocatorAssertions.HasCSSOptions options) {
        ExpectedTextValue expected = new ExpectedTextValue();
        expected.string = value;
        this.hasCSS(name, expected, value, options);
    }

    @Override
    public void hasCSS(String name, Pattern pattern, LocatorAssertions.HasCSSOptions options) {
        ExpectedTextValue expected = LocatorAssertionsImpl.expectedRegex(pattern);
        this.hasCSS(name, expected, pattern, options);
    }

    private void hasCSS(String name, ExpectedTextValue expectedText, Object expectedValue, LocatorAssertions.HasCSSOptions options) {
        if (options == null) {
            options = new LocatorAssertions.HasCSSOptions();
        }
        FrameExpectOptions commonOptions = Utils.convertType(options, FrameExpectOptions.class);
        commonOptions.expressionArg = name;
        String message = "Locator expected to have CSS property '" + name + "'";
        if (expectedValue instanceof Pattern) {
            message = message + " matching regex";
        }
        this.expectImpl("to.have.css", expectedText, expectedValue, message, commonOptions);
    }

    @Override
    public void hasId(String id, LocatorAssertions.HasIdOptions options) {
        ExpectedTextValue expected = new ExpectedTextValue();
        expected.string = id;
        this.expectImpl("to.have.id", expected, (Object)id, "Locator expected to have ID", Utils.convertType(options, FrameExpectOptions.class));
    }

    @Override
    public void hasId(Pattern pattern, LocatorAssertions.HasIdOptions options) {
        ExpectedTextValue expected = LocatorAssertionsImpl.expectedRegex(pattern);
        this.expectImpl("to.have.id", expected, (Object)pattern, "Locator expected to have ID matching regex", Utils.convertType(options, FrameExpectOptions.class));
    }

    @Override
    public void hasJSProperty(String name, Object value, LocatorAssertions.HasJSPropertyOptions options) {
        if (options == null) {
            options = new LocatorAssertions.HasJSPropertyOptions();
        }
        FrameExpectOptions commonOptions = Utils.convertType(options, FrameExpectOptions.class);
        commonOptions.expressionArg = name;
        commonOptions.expectedValue = Serialization.serializeArgument(value);
        List<ExpectedTextValue> list = null;
        this.expectImpl("to.have.property", list, value, "Locator expected to have JavaScript property '" + name + "'", commonOptions);
    }

    @Override
    public void hasText(String text, LocatorAssertions.HasTextOptions options) {
        ExpectedTextValue expected = new ExpectedTextValue();
        expected.string = text;
        expected.ignoreCase = LocatorAssertionsImpl.shouldIgnoreCase(options);
        expected.matchSubstring = false;
        expected.normalizeWhiteSpace = true;
        this.expectImpl("to.have.text", expected, (Object)text, "Locator expected to have text", Utils.convertType(options, FrameExpectOptions.class));
    }

    @Override
    public void hasText(Pattern pattern, LocatorAssertions.HasTextOptions options) {
        ExpectedTextValue expected = LocatorAssertionsImpl.expectedRegex(pattern);
        expected.ignoreCase = LocatorAssertionsImpl.shouldIgnoreCase(options);
        expected.matchSubstring = true;
        expected.normalizeWhiteSpace = true;
        this.expectImpl("to.have.text", expected, (Object)pattern, "Locator expected to have text matching regex", Utils.convertType(options, FrameExpectOptions.class));
    }

    @Override
    public void hasText(String[] strings, LocatorAssertions.HasTextOptions options) {
        ArrayList<ExpectedTextValue> list = new ArrayList<ExpectedTextValue>();
        for (String text : strings) {
            ExpectedTextValue expected = new ExpectedTextValue();
            expected.string = text;
            expected.ignoreCase = LocatorAssertionsImpl.shouldIgnoreCase(options);
            expected.matchSubstring = false;
            expected.normalizeWhiteSpace = true;
            list.add(expected);
        }
        this.expectImpl("to.have.text.array", list, (Object)strings, "Locator expected to have text", Utils.convertType(options, FrameExpectOptions.class));
    }

    @Override
    public void hasText(Pattern[] patterns, LocatorAssertions.HasTextOptions options) {
        ArrayList<ExpectedTextValue> list = new ArrayList<ExpectedTextValue>();
        for (Pattern pattern : patterns) {
            ExpectedTextValue expected = LocatorAssertionsImpl.expectedRegex(pattern);
            expected.ignoreCase = LocatorAssertionsImpl.shouldIgnoreCase(options);
            expected.matchSubstring = true;
            expected.normalizeWhiteSpace = true;
            list.add(expected);
        }
        this.expectImpl("to.have.text.array", list, (Object)patterns, "Locator expected to have text matching regex", Utils.convertType(options, FrameExpectOptions.class));
    }

    @Override
    public void hasValue(String value, LocatorAssertions.HasValueOptions options) {
        ExpectedTextValue expected = new ExpectedTextValue();
        expected.string = value;
        this.expectImpl("to.have.value", expected, (Object)value, "Locator expected to have value", Utils.convertType(options, FrameExpectOptions.class));
    }

    @Override
    public void hasValue(Pattern pattern, LocatorAssertions.HasValueOptions options) {
        ExpectedTextValue expected = LocatorAssertionsImpl.expectedRegex(pattern);
        this.expectImpl("to.have.value", expected, (Object)pattern, "Locator expected to have value matching regex", Utils.convertType(options, FrameExpectOptions.class));
    }

    @Override
    public void hasValues(String[] values, LocatorAssertions.HasValuesOptions options) {
        ArrayList<ExpectedTextValue> list = new ArrayList<ExpectedTextValue>();
        for (String text : values) {
            ExpectedTextValue expected = new ExpectedTextValue();
            expected.string = text;
            list.add(expected);
        }
        this.expectImpl("to.have.values", list, (Object)values, "Locator expected to have values", Utils.convertType(options, FrameExpectOptions.class));
    }

    @Override
    public void hasValues(Pattern[] patterns, LocatorAssertions.HasValuesOptions options) {
        ArrayList<ExpectedTextValue> list = new ArrayList<ExpectedTextValue>();
        for (Pattern pattern : patterns) {
            ExpectedTextValue expected = LocatorAssertionsImpl.expectedRegex(pattern);
            expected.matchSubstring = true;
            list.add(expected);
        }
        this.expectImpl("to.have.values", list, (Object)patterns, "Locator expected to have values matching regex", Utils.convertType(options, FrameExpectOptions.class));
    }

    @Override
    public void isChecked(LocatorAssertions.IsCheckedOptions options) {
        String expression = options != null && options.checked != null && options.checked == false ? "to.be.unchecked" : "to.be.checked";
        this.expectTrue(expression, "Locator expected to be checked", Utils.convertType(options, FrameExpectOptions.class));
    }

    @Override
    public void isDisabled(LocatorAssertions.IsDisabledOptions options) {
        this.expectTrue("to.be.disabled", "Locator expected to be disabled", Utils.convertType(options, FrameExpectOptions.class));
    }

    @Override
    public void isEditable(LocatorAssertions.IsEditableOptions options) {
        this.expectTrue("to.be.editable", "Locator expected to be editable", Utils.convertType(options, FrameExpectOptions.class));
    }

    @Override
    public void isEmpty(LocatorAssertions.IsEmptyOptions options) {
        this.expectTrue("to.be.empty", "Locator expected to be empty", Utils.convertType(options, FrameExpectOptions.class));
    }

    @Override
    public void isEnabled(LocatorAssertions.IsEnabledOptions options) {
        this.expectTrue("to.be.enabled", "Locator expected to be enabled", Utils.convertType(options, FrameExpectOptions.class));
    }

    @Override
    public void isFocused(LocatorAssertions.IsFocusedOptions options) {
        this.expectTrue("to.be.focused", "Locator expected to be focused", Utils.convertType(options, FrameExpectOptions.class));
    }

    @Override
    public void isHidden(LocatorAssertions.IsHiddenOptions options) {
        this.expectTrue("to.be.hidden", "Locator expected to be hidden", Utils.convertType(options, FrameExpectOptions.class));
    }

    @Override
    public void isVisible(LocatorAssertions.IsVisibleOptions options) {
        this.expectTrue("to.be.visible", "Locator expected to be visible", Utils.convertType(options, FrameExpectOptions.class));
    }

    private void expectTrue(String expression, String message, FrameExpectOptions options) {
        List<ExpectedTextValue> expectedText = null;
        this.expectImpl(expression, expectedText, null, message, options);
    }

    @Override
    public LocatorAssertions not() {
        return new LocatorAssertionsImpl((Locator)this.actualLocator, !this.isNot);
    }

    private static Boolean shouldIgnoreCase(Object options) {
        if (options == null) {
            return null;
        }
        try {
            Field fromField = options.getClass().getDeclaredField("ignoreCase");
            Object value = fromField.get(options);
            return (Boolean)value;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return null;
        }
    }
}

