/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.impl.ReaderThread;
import com.microsoft.playwright.impl.Serialization;
import com.microsoft.playwright.impl.Transport;
import com.microsoft.playwright.impl.WriterThread;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class PipeTransport
implements Transport {
    private final BlockingQueue<JsonObject> incoming = new ArrayBlockingQueue<JsonObject>(1000);
    private final BlockingQueue<String> outgoing = new ArrayBlockingQueue<String>(1000);
    private final ReaderThread readerThread;
    private final WriterThread writerThread;
    private boolean isClosed;

    PipeTransport(InputStream input, OutputStream output) {
        DataInputStream in = new DataInputStream(new BufferedInputStream(input));
        this.readerThread = new ReaderThread(in, this.incoming);
        this.readerThread.start();
        this.writerThread = new WriterThread(output, this.outgoing);
        this.writerThread.start();
    }

    @Override
    public void send(JsonObject message) {
        if (this.isClosed) {
            throw new PlaywrightException("Playwright connection closed");
        }
        try {
            this.outgoing.put(Serialization.gson().toJson((JsonElement)message));
        }
        catch (InterruptedException e) {
            throw new PlaywrightException("Failed to send message", e);
        }
    }

    @Override
    public JsonObject poll(Duration timeout) {
        if (this.isClosed) {
            throw new PlaywrightException("Playwright connection closed");
        }
        try {
            JsonObject message = this.incoming.poll(timeout.toMillis(), TimeUnit.MILLISECONDS);
            if (message == null && this.readerThread.exception != null) {
                try {
                    this.close();
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                }
                throw new PlaywrightException("Failed to read message from driver, pipe closed.", this.readerThread.exception);
            }
            return message;
        }
        catch (InterruptedException e) {
            throw new PlaywrightException("Failed to read message", e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.readerThread.isClosing = true;
        this.writerThread.out.close();
        this.writerThread.interrupt();
    }
}

