/*
 * Decompiled with CFR 0.152.
 */
package flex.tools.debugger.cli;

import flash.tools.debugger.InProgressException;
import flash.tools.debugger.Isolate;
import flash.tools.debugger.NoResponseException;
import flash.tools.debugger.Session;
import flash.tools.debugger.SourceFile;
import flash.tools.debugger.SwfInfo;
import flash.util.IntMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;

public class FileInfoCache
implements Comparator<SourceFile> {
    Session m_session;
    IntMap m_byInt = new IntMap();
    HashMap<Integer, IntMap> m_isolateState = new HashMap();
    SourceFile[] m_files = null;
    SourceFile[] m_isolateFiles = null;
    SwfInfo m_swfFilter = null;
    int m_swfsLoaded = 0;
    boolean m_dirty = false;
    int lastActiveIsolate = 1;

    private IntMap getIsolateState(int n) {
        IntMap intMap = null;
        if (!this.m_isolateState.containsKey(n)) {
            intMap = new IntMap();
            this.m_isolateState.put(n, intMap);
        } else {
            intMap = this.m_isolateState.get(n);
        }
        return intMap;
    }

    public void bind(Session session) {
        this.setSession(session);
    }

    public void unbind() {
        this.m_session = null;
    }

    public SourceFile getFile(int n) {
        return this.getFile(n, 1);
    }

    public SourceFile getFile(int n, int n2) {
        this.populate();
        if (n2 == 1) {
            return (SourceFile)this.m_byInt.get(n);
        }
        return (SourceFile)this.getIsolateState(n2).get(n);
    }

    public SourceFile[] getFileList() {
        this.populate();
        return this.m_files;
    }

    public SourceFile[] getFileList(int n) {
        this.populate();
        if (n == 1) {
            Object[] objectArray = this.m_byInt.valuesToArray(new Object[this.m_byInt.size()]);
            return (SourceFile[])Arrays.copyOf(objectArray, objectArray.length, SourceFile[].class);
        }
        if (n != this.lastActiveIsolate) {
            this.buildIsolateFiles(n);
        }
        return this.m_isolateFiles;
    }

    private void buildIsolateFiles(int n) {
        SwfInfo[] swfInfoArray = this.getSwfs(n);
        boolean bl = true;
        ArrayList<SourceFile> arrayList = new ArrayList<SourceFile>();
        for (int i = 0; i < swfInfoArray.length; ++i) {
            if (swfInfoArray[i] == null) continue;
            bl = this.loadSwfFiles(arrayList, swfInfoArray[i]) ? bl : false;
        }
        ArrayList<SourceFile> arrayList2 = this.trimFileList(arrayList);
        this.m_isolateFiles = arrayList2.toArray(new SourceFile[arrayList2.size()]);
        Arrays.sort(this.m_isolateFiles, this);
    }

    public Iterator<?> getAllFiles(int n) {
        this.populate();
        if (n == 1) {
            return this.m_byInt.iterator();
        }
        return this.getIsolateState(n).iterator();
    }

    public SwfInfo getSwfFilter() {
        return this.m_swfFilter;
    }

    public boolean isSwfFilterOn() {
        return this.m_swfFilter != null;
    }

    public void setDirty() {
        this.m_dirty = true;
    }

    void setSession(Session session) {
        this.m_session = session;
        this.m_swfFilter = null;
        this.clear();
    }

    SwfInfo[] getAllSwfs() {
        ArrayList<SwfInfo> arrayList = new ArrayList<SwfInfo>();
        for (Isolate isolate : this.m_session.getWorkers()) {
            SwfInfo[] swfInfoArray = new SwfInfo[]{};
            try {
                swfInfoArray = this.m_session.getWorkerSession(isolate.getId()).getSwfs();
            }
            catch (NoResponseException noResponseException) {
                swfInfoArray = new SwfInfo[]{};
            }
            for (SwfInfo swfInfo : swfInfoArray) {
                arrayList.add(swfInfo);
            }
        }
        return arrayList.toArray(new SwfInfo[0]);
    }

    void populate() {
        if (this.m_session != null && (this.m_dirty || this.getAllSwfs().length > this.m_swfsLoaded)) {
            this.reloadCache();
        }
    }

    void reloadCache() {
        this.clear();
        this.loadCache();
        this.m_dirty = false;
    }

    void clear() {
        this.m_byInt.clear();
        this.m_isolateState.clear();
        this.m_files = null;
    }

    public boolean inFileList(SourceFile sourceFile) {
        boolean bl = false;
        SourceFile[] sourceFileArray = this.getFileList();
        for (int i = 0; i < sourceFileArray.length && !bl; ++i) {
            if (sourceFileArray[i] != sourceFile) continue;
            bl = true;
        }
        return bl;
    }

    void loadCache() {
        boolean bl = true;
        ArrayList<SourceFile> arrayList = new ArrayList<SourceFile>();
        SwfInfo[] swfInfoArray = this.getAllSwfs();
        for (int i = 0; i < swfInfoArray.length; ++i) {
            if (swfInfoArray[i] == null) continue;
            bl = this.loadSwfFiles(arrayList, swfInfoArray[i]) ? bl : false;
        }
        ArrayList<SourceFile> arrayList2 = this.trimFileList(arrayList);
        this.m_files = arrayList2.toArray(new SourceFile[arrayList2.size()]);
        Arrays.sort(this.m_files, this);
        if (bl) {
            this.m_swfsLoaded = swfInfoArray.length;
        }
    }

    boolean loadSwfFiles(ArrayList<SourceFile> arrayList, SwfInfo swfInfo) {
        boolean bl = true;
        try {
            SourceFile[] sourceFileArray = swfInfo.getSourceList(this.m_session);
            arrayList.ensureCapacity(arrayList.size() + sourceFileArray.length);
            for (int i = 0; i < sourceFileArray.length; ++i) {
                this.putFile(sourceFileArray[i], swfInfo.getIsolateId());
                arrayList.add(sourceFileArray[i]);
            }
        }
        catch (InProgressException inProgressException) {
            bl = false;
        }
        return bl;
    }

    ArrayList<SourceFile> trimFileList(ArrayList<SourceFile> arrayList) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<SourceFile> arrayList2 = new ArrayList<SourceFile>();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            boolean bl = false;
            SourceFile sourceFile = arrayList.get(i);
            String string = sourceFile.getRawName();
            if (this.m_swfFilter == null) {
                if (hashMap.get(string) == null) {
                    bl = true;
                }
            } else {
                bl = this.m_swfFilter.containsSource(sourceFile);
            }
            if (!bl) continue;
            hashMap.put(string, string);
            arrayList2.add(sourceFile);
        }
        return arrayList2;
    }

    void putFile(SourceFile sourceFile, int n) {
        int n2 = sourceFile.getId();
        if (n == 1) {
            this.m_byInt.put(n2, sourceFile);
        } else {
            this.getIsolateState(n).put(n2, sourceFile);
        }
    }

    public boolean setSwfFilter(String string) {
        boolean bl = false;
        if (string == null) {
            this.m_swfFilter = null;
            bl = true;
        } else {
            SwfInfo[] swfInfoArray = this.getAllSwfs();
            for (int i = 0; i < swfInfoArray.length; ++i) {
                SwfInfo swfInfo = swfInfoArray[i];
                if (swfInfo == null || !FileInfoCache.nameOfSwf(swfInfo).equalsIgnoreCase(string)) continue;
                bl = true;
                this.m_swfFilter = swfInfo;
                break;
            }
        }
        if (bl) {
            this.reloadCache();
        }
        return bl;
    }

    public SwfInfo[] getSwfs(int n) {
        return this.getSwfsIsolate(n);
    }

    public SwfInfo[] getSwfsIsolate(int n) {
        SwfInfo[] swfInfoArray = null;
        try {
            swfInfoArray = this.m_session.getWorkerSession(n).getSwfs();
        }
        catch (NoResponseException noResponseException) {
            swfInfoArray = new SwfInfo[]{};
        }
        return swfInfoArray;
    }

    public SwfInfo swfForFile(SourceFile sourceFile, int n) {
        int n2 = sourceFile.getId();
        SwfInfo swfInfo = null;
        SwfInfo[] swfInfoArray = this.getSwfs(n);
        for (int i = 0; i < swfInfoArray.length && swfInfo == null; ++i) {
            if (swfInfoArray[i] == null || !swfInfoArray[i].containsSource(sourceFile)) continue;
            swfInfo = swfInfoArray[i];
        }
        return swfInfo;
    }

    public static String nameOfSwf(SwfInfo swfInfo) {
        int n = -1;
        String string = swfInfo.getUrl();
        n = swfInfo.getUrl().lastIndexOf(47);
        if (n > -1) {
            string = swfInfo.getUrl().substring(n + 1);
        }
        if ((n = swfInfo.getUrl().lastIndexOf(92)) > -1) {
            string = swfInfo.getUrl().substring(n + 1);
        } else {
            n = swfInfo.getPath().lastIndexOf(92);
            if (n > -1) {
                string = swfInfo.getPath().substring(n + 1);
            } else {
                n = swfInfo.getPath().lastIndexOf(47);
                if (n > -1) {
                    string = swfInfo.getPath().substring(n + 1);
                }
            }
        }
        n = string.lastIndexOf(63);
        string = n > -1 ? string.substring(0, n) : string;
        return string;
    }

    public static String shortNameOfSwf(SwfInfo swfInfo) {
        String string = FileInfoCache.nameOfSwf(swfInfo);
        int n = -1;
        n = string.lastIndexOf(47);
        if (n > -1) {
            string = string.substring(n + 1);
        } else {
            n = string.lastIndexOf(92);
            if (n > -1) {
                string = string.substring(n + 1);
            }
        }
        return string;
    }

    public SourceFile similarFileInSwf(SwfInfo swfInfo, SourceFile sourceFile) throws InProgressException {
        SourceFile sourceFile2 = null;
        SourceFile[] sourceFileArray = swfInfo.getSourceList(this.m_session);
        if (!swfInfo.isProcessingComplete()) {
            throw new InProgressException();
        }
        for (int i = 0; i < sourceFileArray.length; ++i) {
            if (!this.filesMatch(sourceFile, sourceFileArray[i])) continue;
            sourceFile2 = sourceFileArray[i];
        }
        return sourceFile2;
    }

    @Override
    public int compare(SourceFile sourceFile, SourceFile sourceFile2) {
        String string = sourceFile.getName();
        String string2 = sourceFile2.getName();
        return string.compareTo(string2);
    }

    public boolean filesMatch(SourceFile sourceFile, SourceFile sourceFile2) {
        boolean bl = true;
        if (sourceFile == null || sourceFile2 == null) {
            bl = false;
        } else if (sourceFile.getPackageName().compareTo(sourceFile2.getPackageName()) != 0) {
            bl = false;
        } else if (sourceFile.getName().compareTo(sourceFile2.getName()) != 0) {
            bl = false;
        } else if (sourceFile.getLineCount() != sourceFile2.getLineCount()) {
            bl = false;
        }
        return bl;
    }

    public SourceFile[] getFiles(String string) {
        return this.getFiles(string, -1);
    }

    public SourceFile[] getFiles(String string, int n) {
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = string.startsWith("*") && string.length() > 1;
        boolean bl6 = string.endsWith("*");
        boolean bl7 = bl = string.indexOf(46) > -1;
        if (bl5 && bl6) {
            string = string.substring(1, string.length() - 1);
            bl3 = true;
        } else if (bl5) {
            string = string.substring(1);
            bl4 = true;
        } else if (bl6) {
            string = string.substring(0, string.length() - 1);
            bl2 = true;
        } else if (bl) {
            bl3 = true;
        } else {
            bl2 = true;
        }
        SourceFile[] sourceFileArray = n > -1 ? this.getFileList(n) : this.getFileList();
        ArrayList<SourceFile> arrayList = new ArrayList<SourceFile>();
        int n2 = sourceFileArray.length;
        int n3 = -1;
        Object object = string.startsWith(".") ? string : "." + string;
        for (int i = 0; i < n2; ++i) {
            SourceFile sourceFile = sourceFileArray[i];
            boolean bl8 = bl && sourceFile.getFullPath().matches(".*[/\\\\].*");
            String string2 = bl8 ? sourceFile.getFullPath() : sourceFile.getName();
            String string3 = bl && bl8 ? object : string;
            string3 = string3.replace('/', '.');
            string3 = string3.replace('\\', '.');
            string2 = string2.replace('/', '.');
            if ((string2 = string2.replace('\\', '.')).equals(string3)) {
                n3 = i;
                break;
            }
            if (bl2 && string2.startsWith(string3)) {
                arrayList.add(sourceFile);
                continue;
            }
            if (bl4 && string2.endsWith(string3)) {
                arrayList.add(sourceFile);
                continue;
            }
            if (!bl3 || !string2.contains(string3)) continue;
            arrayList.add(sourceFile);
        }
        if (n3 > -1) {
            arrayList.clear();
            arrayList.add(sourceFileArray[n3]);
        }
        SourceFile[] sourceFileArray2 = arrayList.toArray(new SourceFile[arrayList.size()]);
        Arrays.sort(sourceFileArray2, this);
        return sourceFileArray2;
    }
}

