/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.abc;

import java.io.File;
import java.util.Collection;
import org.apache.royale.abc.ABCEmitter;
import org.apache.royale.abc.ABCParser;
import org.apache.royale.abc.diagnostics.AbstractDiagnosticVisitor;
import org.apache.royale.abc.graph.IBasicBlock;
import org.apache.royale.abc.graph.IFlowgraph;
import org.apache.royale.abc.instructionlist.InstructionList;
import org.apache.royale.abc.optimize.DeadCodeFilter;
import org.apache.royale.abc.optimize.PeepholeOptimizerMethodBodyVisitor;
import org.apache.royale.abc.semantics.ClassInfo;
import org.apache.royale.abc.semantics.InstanceInfo;
import org.apache.royale.abc.semantics.Instruction;
import org.apache.royale.abc.semantics.Label;
import org.apache.royale.abc.semantics.Metadata;
import org.apache.royale.abc.semantics.MethodBodyInfo;
import org.apache.royale.abc.semantics.MethodInfo;
import org.apache.royale.abc.semantics.Name;
import org.apache.royale.abc.semantics.Namespace;
import org.apache.royale.abc.semantics.Nsset;
import org.apache.royale.abc.visitors.DelegatingClassVisitor;
import org.apache.royale.abc.visitors.DelegatingMetadataVisitor;
import org.apache.royale.abc.visitors.DelegatingMethodBodyVisitor;
import org.apache.royale.abc.visitors.DelegatingMethodVisitor;
import org.apache.royale.abc.visitors.DelegatingScriptVisitor;
import org.apache.royale.abc.visitors.DelegatingTraitVisitor;
import org.apache.royale.abc.visitors.DelegatingTraitsVisitor;
import org.apache.royale.abc.visitors.IABCVisitor;
import org.apache.royale.abc.visitors.IClassVisitor;
import org.apache.royale.abc.visitors.IMetadataVisitor;
import org.apache.royale.abc.visitors.IMethodBodyVisitor;
import org.apache.royale.abc.visitors.IMethodVisitor;
import org.apache.royale.abc.visitors.IScriptVisitor;
import org.apache.royale.abc.visitors.ITraitVisitor;
import org.apache.royale.abc.visitors.ITraitsVisitor;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.UnreachableBlockProblem;

public class ABCLinker {
    public static byte[] linkABC(Iterable<byte[]> inputABCs, int majorVersion, int minorVersion, ABCLinkerSettings settings) throws Exception {
        ABCEmitter emitter = new ABCEmitter();
        emitter.setAllowBadJumps(true);
        emitter.visit(majorVersion, minorVersion);
        for (byte[] inputABC : inputABCs) {
            ABCParser abcParser = new ABCParser(inputABC);
            abcParser.parseABC(new LinkingVisitor(emitter, settings));
        }
        emitter.visitEnd();
        return emitter.emit();
    }

    private static class LinkingVisitor
    implements IABCVisitor {
        private final ABCEmitter delegate;
        private final ABCLinkerSettings settings;

        public LinkingVisitor(ABCEmitter delegate, ABCLinkerSettings linkSettings) {
            this.delegate = delegate;
            this.settings = linkSettings;
        }

        @Override
        public void visit(int major_version, int minor_version) {
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public IScriptVisitor visitScript() {
            IScriptVisitor sv = this.delegate.visitScript();
            if (this.settings.shouldStripMetadata()) {
                sv = new MetadataStrippingScriptVisitor(sv, this.settings.meta_names, this.settings.stripGotoDefinitionHelp, this.settings.stripFileAttributeFromGotoDefinitionHelp);
            }
            return sv;
        }

        @Override
        public IClassVisitor visitClass(InstanceInfo iinfo, ClassInfo cinfo) {
            IClassVisitor cv = this.delegate.visitClass(iinfo, cinfo);
            if (this.settings.shouldStripMetadata()) {
                cv = new MetadataStrippingClassVisitor(cv, this.settings.meta_names, this.settings.stripGotoDefinitionHelp, this.settings.stripFileAttributeFromGotoDefinitionHelp);
            }
            return cv;
        }

        @Override
        public IMethodVisitor visitMethod(MethodInfo minfo) {
            IMethodVisitor mv = this.delegate.visitMethod(minfo);
            if (this.settings.optimize) {
                mv = new OptimizingMethodVisitor(mv, this.settings.problems, this.settings.removeDeadCode);
            }
            if (this.settings.stripDebug) {
                mv = new DebugStrippingMethodVisitor(mv);
            }
            return mv;
        }

        @Override
        public void visitPooledInt(Integer i) {
        }

        @Override
        public void visitPooledUInt(Long l) {
        }

        @Override
        public void visitPooledDouble(Double d) {
        }

        @Override
        public void visitPooledString(String s) {
        }

        @Override
        public void visitPooledNamespace(Namespace ns) {
            if (this.settings.enableInlining) {
                ns.setMergePrivateNamespaces(true);
            }
        }

        @Override
        public void visitPooledNsSet(Nsset nss) {
        }

        @Override
        public void visitPooledName(Name n) {
        }

        @Override
        public void visitPooledMetadata(Metadata md) {
        }
    }

    private static class MetadataStrippingTraitsVisitor
    extends DelegatingTraitsVisitor {
        private Collection<String> meta_names;
        private boolean stripGotoDefinitionHelp;
        private boolean stripFileAttribute;

        MetadataStrippingTraitsVisitor(ITraitsVisitor d, Collection<String> meta_names, boolean stripGotoDefinitionHelp, boolean stripFileAttribute) {
            super(d);
            this.meta_names = meta_names;
            this.stripGotoDefinitionHelp = stripGotoDefinitionHelp;
            this.stripFileAttribute = stripFileAttribute;
        }

        @Override
        public ITraitVisitor visitSlotTrait(int kind, Name name, int slot_id, Name slot_type, Object slot_value) {
            return new MetadataStrippingTraitVisitor(super.visitSlotTrait(kind, name, slot_id, slot_type, slot_value), this.meta_names, this.stripGotoDefinitionHelp, this.stripFileAttribute);
        }

        @Override
        public ITraitVisitor visitClassTrait(int kind, Name name, int slot_id, ClassInfo clazz) {
            return new MetadataStrippingTraitVisitor(super.visitClassTrait(kind, name, slot_id, clazz), this.meta_names, this.stripGotoDefinitionHelp, this.stripFileAttribute);
        }

        @Override
        public ITraitVisitor visitMethodTrait(int kind, Name name, int disp_id, MethodInfo method) {
            return new MetadataStrippingTraitVisitor(super.visitMethodTrait(kind, name, disp_id, method), this.meta_names, this.stripGotoDefinitionHelp, this.stripFileAttribute);
        }
    }

    private static class MetadataStrippingVisitor
    extends DelegatingMetadataVisitor {
        private static final String GO_TO_DEFINITION_HELP = "__go_to_definition_help";
        private static final String GO_TO_DEFINITION_CTOR_HELP = "__go_to_ctor_definition_help";
        private static final String GO_TO_DEFINITION_HELP_FILE = "file";
        private Collection<String> metaNames;
        private boolean stripGotoDefinitionHelp;
        private boolean stripFileAttribute;

        static Metadata stripFileAttributeFromGotoDefinitionHelp(Metadata metadata) {
            String name = metadata.getName();
            if (GO_TO_DEFINITION_HELP.equals(name) || GO_TO_DEFINITION_CTOR_HELP.equals(name)) {
                metadata = MetadataStrippingVisitor.removeKey(metadata, GO_TO_DEFINITION_HELP_FILE);
            }
            return metadata;
        }

        static Metadata removeKey(Metadata metadata, String key) {
            assert (metadata != null);
            assert (key != null);
            String[] keys = metadata.getKeys();
            for (int i = 0; i < keys.length; ++i) {
                if (!key.equals(keys[i])) continue;
                String[] values = metadata.getValues();
                String[] newKeys = new String[keys.length - 1];
                String[] newValues = new String[keys.length - 1];
                if (i > 0) {
                    System.arraycopy(keys, 0, newKeys, 0, i);
                    System.arraycopy(values, 0, newValues, 0, i);
                }
                if (i < keys.length - 1) {
                    System.arraycopy(keys, i + 1, newKeys, i, keys.length - i - 1);
                    System.arraycopy(values, i + 1, newValues, i, keys.length - i - 1);
                }
                metadata = new Metadata(metadata.getName(), newKeys, newValues);
                break;
            }
            return metadata;
        }

        MetadataStrippingVisitor(IMetadataVisitor d, Collection<String> meta_names, boolean stripGotoDefinitionHelp, boolean stripFileAttribute) {
            super(d);
            this.metaNames = meta_names;
            this.stripGotoDefinitionHelp = stripGotoDefinitionHelp;
            this.stripFileAttribute = stripFileAttribute;
        }

        @Override
        public void visit(Metadata md) {
            if (this.shouldKeep(md)) {
                if (!this.stripGotoDefinitionHelp && this.stripFileAttribute) {
                    md = MetadataStrippingVisitor.stripFileAttributeFromGotoDefinitionHelp(md);
                }
                super.visit(md);
            }
        }

        boolean shouldKeep(Metadata md) {
            if (this.metaNames == null) {
                if (GO_TO_DEFINITION_HELP.equals(md.getName()) || GO_TO_DEFINITION_CTOR_HELP.equals(md.getName())) {
                    return !this.stripGotoDefinitionHelp;
                }
                return true;
            }
            return this.metaNames.contains(md.getName());
        }
    }

    private static class MetadataStrippingTraitVisitor
    extends DelegatingTraitVisitor {
        private Collection<String> meta_names;
        private boolean stripGotoDefinitionHelp;
        private boolean stripFileAttribute;

        MetadataStrippingTraitVisitor(ITraitVisitor d, Collection<String> meta_names, boolean stripGotoDefinitionHelp, boolean stripFileAttribute) {
            super(d);
            this.meta_names = meta_names;
            this.stripGotoDefinitionHelp = stripGotoDefinitionHelp;
            this.stripFileAttribute = stripFileAttribute;
        }

        @Override
        public IMetadataVisitor visitMetadata(int count) {
            return new MetadataStrippingVisitor(super.visitMetadata(count), this.meta_names, this.stripGotoDefinitionHelp, this.stripFileAttribute);
        }
    }

    private static class MetadataStrippingClassVisitor
    extends DelegatingClassVisitor {
        private Collection<String> meta_names;
        private boolean stripGotoDefinitionHelp;
        private boolean stripFileAttribute;

        MetadataStrippingClassVisitor(IClassVisitor d, Collection<String> meta_names, boolean stripGotoDefinitionHelp, boolean stripFileAttribute) {
            super(d);
            this.meta_names = meta_names;
            this.stripGotoDefinitionHelp = stripGotoDefinitionHelp;
            this.stripFileAttribute = stripFileAttribute;
        }

        @Override
        public ITraitsVisitor visitClassTraits() {
            return new MetadataStrippingTraitsVisitor(super.visitClassTraits(), this.meta_names, this.stripGotoDefinitionHelp, this.stripFileAttribute);
        }

        @Override
        public ITraitsVisitor visitInstanceTraits() {
            return new MetadataStrippingTraitsVisitor(super.visitInstanceTraits(), this.meta_names, this.stripGotoDefinitionHelp, this.stripFileAttribute);
        }
    }

    private static class MetadataStrippingScriptVisitor
    extends DelegatingScriptVisitor {
        private Collection<String> meta_names;
        private boolean stripGotoDefinitionHelp;
        private boolean stripFileAttribute;

        MetadataStrippingScriptVisitor(IScriptVisitor d, Collection<String> meta_names, boolean stripGotoDefinitionHelp, boolean stripFileAttribute) {
            super(d);
            this.meta_names = meta_names;
            this.stripGotoDefinitionHelp = stripGotoDefinitionHelp;
            this.stripFileAttribute = stripFileAttribute;
        }

        @Override
        public ITraitsVisitor visitTraits() {
            return new MetadataStrippingTraitsVisitor(super.visitTraits(), this.meta_names, this.stripGotoDefinitionHelp, this.stripFileAttribute);
        }
    }

    private static class OptimizingMethodVisitor
    extends DelegatingMethodVisitor {
        final Collection<ICompilerProblem> problems;
        final boolean removeDeadCode;

        public OptimizingMethodVisitor(IMethodVisitor delegate, Collection<ICompilerProblem> problems, boolean removeDeadCode) {
            super(delegate);
            this.problems = problems;
            this.removeDeadCode = removeDeadCode;
        }

        @Override
        public IMethodBodyVisitor visitBody(MethodBodyInfo mbi) {
            IMethodBodyVisitor delegate = super.visitBody(mbi);
            if (this.removeDeadCode) {
                AbstractDiagnosticVisitor diagnostics = new AbstractDiagnosticVisitor(){

                    @Override
                    public void unreachableBlock(MethodBodyInfo methodBodyInfo, IFlowgraph cfg, IBasicBlock block) {
                        String fileName;
                        if (OptimizingMethodVisitor.this.problems != null && (fileName = cfg.findSourcePath(block)) != null && new File(fileName).isFile()) {
                            OptimizingMethodVisitor.this.problems.add(new UnreachableBlockProblem(fileName, cfg.findLineNumber(block)));
                        }
                    }
                };
                delegate = new DeadCodeFilter(mbi, delegate, diagnostics);
            }
            return new PeepholeOptimizerMethodBodyVisitor(delegate);
        }
    }

    private static class DebugStrippingMethodVisitor
    extends DelegatingMethodVisitor {
        public DebugStrippingMethodVisitor(IMethodVisitor delegate) {
            super(delegate);
        }

        @Override
        public IMethodBodyVisitor visitBody(MethodBodyInfo mbi) {
            return new DebugStrippingMethodBodyVisitor(super.visitBody(mbi));
        }
    }

    private static final class DebugStrippingMethodBodyVisitor
    extends DelegatingMethodBodyVisitor {
        private boolean strippedLastInstruction;

        public DebugStrippingMethodBodyVisitor(IMethodBodyVisitor delegate) {
            super(delegate);
        }

        private boolean stripInstruction(int opcode) {
            switch (opcode) {
                case 239: 
                case 240: 
                case 241: {
                    this.strippedLastInstruction = true;
                    break;
                }
                default: {
                    this.strippedLastInstruction = false;
                }
            }
            return this.strippedLastInstruction;
        }

        @Override
        public void visitInstructionList(InstructionList new_list) {
            InstructionList strippedInstructionList = new InstructionList(new_list.size());
            for (Instruction inst : new_list.getInstructions()) {
                if (this.stripInstruction(inst.getOpcode())) continue;
                strippedInstructionList.addInstruction(inst);
            }
            super.visitInstructionList(strippedInstructionList);
        }

        @Override
        public void visitInstruction(int opcode) {
            if (this.stripInstruction(opcode)) {
                return;
            }
            super.visitInstruction(opcode);
        }

        @Override
        public void visitInstruction(int opcode, int immediate_operand) {
            if (this.stripInstruction(opcode)) {
                return;
            }
            super.visitInstruction(opcode, immediate_operand);
        }

        @Override
        public void visitInstruction(int opcode, Object[] operands) {
            if (this.stripInstruction(opcode)) {
                return;
            }
            super.visitInstruction(opcode, operands);
        }

        @Override
        public void visitInstruction(int opcode, Object single_operand) {
            if (this.stripInstruction(opcode)) {
                return;
            }
            super.visitInstruction(opcode, single_operand);
        }

        @Override
        public void visitInstruction(Instruction instruction) {
            if (this.stripInstruction(instruction.getOpcode())) {
                return;
            }
            super.visitInstruction(instruction);
        }

        @Override
        public void labelCurrent(Label l) {
            if (this.strippedLastInstruction && !l.targetMustBeExecutable()) {
                super.labelNext(l);
            } else {
                super.labelCurrent(l);
            }
        }
    }

    public static class ABCLinkerSettings {
        private boolean optimize = false;
        private boolean enableInlining = false;
        private boolean stripDebug = false;
        private boolean stripFileAttributeFromGotoDefinitionHelp = false;
        private boolean stripGotoDefinitionHelp = false;
        private boolean removeDeadCode = false;
        private Collection<String> meta_names = null;
        private int minorVersion = 16;
        private int majorVersion = 46;
        private Collection<ICompilerProblem> problems;

        public void setOptimize(boolean b) {
            this.optimize = b;
        }

        public void setEnableInlining(boolean b) {
            this.enableInlining = b;
        }

        public void setStripDebugOpcodes(boolean b) {
            this.stripDebug = b;
        }

        public void setKeepMetadata(Collection<String> metadata_names) {
            this.meta_names = metadata_names;
        }

        boolean shouldStripMetadata() {
            return this.meta_names != null || this.stripGotoDefinitionHelp || this.stripFileAttributeFromGotoDefinitionHelp;
        }

        public void setTargetABCVersion(int major, int minor) {
            this.majorVersion = major;
            this.minorVersion = minor;
        }

        public void setStripGotoDefinitionHelp(boolean stripGotoDefinitionHelp) {
            this.stripGotoDefinitionHelp = stripGotoDefinitionHelp;
        }

        public void setStripFileAttributeFromGotoDefinitionHelp(boolean stripFileAttributeFromGotoDefinitionHelp) {
            this.stripFileAttributeFromGotoDefinitionHelp = stripFileAttributeFromGotoDefinitionHelp;
        }

        public void setRemoveDeadCode(boolean removeDeadCode) {
            this.removeDeadCode = removeDeadCode;
        }

        public void setProblemsCollection(Collection<ICompilerProblem> problems) {
            this.problems = problems;
        }
    }
}

