/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.config.impl;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.foundation.common.config.PaaSResourceUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class PaaSPropertiesLoaderUtils
extends PropertiesLoaderUtils {
    public static Properties loadMergedProperties(String locationPattern) throws IOException {
        Properties prop = new Properties();
        return PaaSPropertiesLoaderUtils.fillMergedProperties(prop, locationPattern);
    }

    public static Properties fillMergedProperties(Properties prop, String locationPattern) throws IOException {
        if (StringUtils.isEmpty((CharSequence)locationPattern)) {
            throw new RuntimeException("Resource path must not be null or empty");
        }
        String suffix = ".properties";
        if (!locationPattern.endsWith(suffix)) {
            throw new RuntimeException("Resource path must ends with " + suffix);
        }
        String prefix = locationPattern.substring(0, locationPattern.length() - suffix.length());
        List<Resource> resList = PaaSResourceUtils.getResources(locationPattern, prefix + ".*" + suffix);
        PaaSResourceUtils.sortProperties(resList);
        PaaSPropertiesLoaderUtils.fillAllProperties(prop, resList);
        return prop;
    }

    public static void fillAllProperties(Properties prop, List<Resource> resList) throws IOException {
        for (Resource res : resList) {
            PaaSPropertiesLoaderUtils.fillProperties((Properties)prop, (Resource)res);
        }
    }
}

