/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.publish;

import io.micrometer.core.instrument.Meter;
import java.util.List;
import org.apache.servicecomb.foundation.metrics.publish.DefaultTagFinder;
import org.apache.servicecomb.foundation.metrics.publish.MeasurementGroupConfig;
import org.apache.servicecomb.foundation.metrics.publish.MeasurementNode;
import org.apache.servicecomb.foundation.metrics.publish.MeasurementTree;
import org.apache.servicecomb.metrics.core.meter.ThreadPoolMonitorPublishModelFactory;
import org.apache.servicecomb.metrics.core.publish.PublishUtils;
import org.apache.servicecomb.metrics.core.publish.model.DefaultPublishModel;
import org.apache.servicecomb.metrics.core.publish.model.invocation.OperationPerfGroups;
import org.apache.servicecomb.swagger.invocation.InvocationType;

public class PublishModelFactory {
    private final MeasurementTree tree;

    public PublishModelFactory(List<Meter> meters) {
        this.tree = this.createMeasurementTree(meters);
    }

    protected MeasurementTree createMeasurementTree(List<Meter> meters) {
        MeasurementGroupConfig groupConfig = this.createMeasurementGroupConfig();
        MeasurementTree tree = new MeasurementTree();
        tree.from(meters.iterator(), groupConfig);
        return tree;
    }

    public MeasurementTree getTree() {
        return this.tree;
    }

    protected MeasurementGroupConfig createMeasurementGroupConfig() {
        MeasurementGroupConfig groupConfig = new MeasurementGroupConfig();
        groupConfig.addGroup("servicecomb.invocation", new Object[]{"role", "transport", "operation", "status", "type", new DefaultTagFinder("stage", true)});
        groupConfig.addGroup("os", new Object[]{"type", new DefaultTagFinder("interface", true), new DefaultTagFinder("statistic", true)});
        groupConfig.addGroup("servicecomb.vertx.endpoints", new Object[]{"type", "address", "statistic"});
        groupConfig.addGroup("servicecomb.threadpool", new Object[]{"id", "stage"});
        return groupConfig;
    }

    protected OperationPerfGroups generateOperationPerfGroups(MeasurementTree tree, String invocationTypeName) {
        MeasurementNode node = tree.findChild(new String[]{"servicecomb.invocation", invocationTypeName});
        if (node == null) {
            return null;
        }
        OperationPerfGroups groups = new OperationPerfGroups();
        for (MeasurementNode transportNode : node.getChildren().values()) {
            for (MeasurementNode operationNode : transportNode.getChildren().values()) {
                for (MeasurementNode statusNode : operationNode.getChildren().values()) {
                    PublishUtils.addOperationPerfGroups(groups, transportNode.getName(), operationNode.getName(), statusNode);
                }
            }
        }
        return groups;
    }

    public DefaultPublishModel createDefaultPublishModel() {
        DefaultPublishModel model = new DefaultPublishModel();
        model.getConsumer().setOperationPerfGroups(this.generateOperationPerfGroups(this.tree, InvocationType.CONSUMER.name()));
        model.getProducer().setOperationPerfGroups(this.generateOperationPerfGroups(this.tree, InvocationType.PROVIDER.name()));
        model.getEdge().setOperationPerfGroups(this.generateOperationPerfGroups(this.tree, "EDGE"));
        model.setThreadPools(ThreadPoolMonitorPublishModelFactory.create(this.tree));
        return model;
    }
}

