/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.Part;
import org.apache.servicecomb.foundation.common.utils.json.JavaxServletPartDeserializer;
import org.apache.servicecomb.foundation.common.utils.json.JavaxServletPartSerializer;

public final class JsonUtils {
    public static final ObjectMapper OBJ_MAPPER = new ObjectMapper();

    private JsonUtils() {
    }

    public static <T> T readValue(byte[] src, Class<T> valueType) throws IOException {
        return (T)OBJ_MAPPER.readValue(src, valueType);
    }

    public static <T> T readValue(InputStream is, Class<T> valueType) throws IOException {
        return (T)OBJ_MAPPER.readValue(is, valueType);
    }

    public static <T> T readValue(InputStream is, JavaType valueType) throws IOException {
        return (T)OBJ_MAPPER.readValue(is, valueType);
    }

    public static byte[] writeValueAsBytes(Object value) throws JsonProcessingException {
        return OBJ_MAPPER.writeValueAsBytes(value);
    }

    public static String writeValueAsString(Object value) throws JsonProcessingException {
        return OBJ_MAPPER.writeValueAsString(value);
    }

    public static <T> T convertValue(Object fromValue, Class<T> toValueType) {
        return (T)OBJ_MAPPER.convertValue(fromValue, toValueType);
    }

    public static void writeValue(OutputStream out, Object value) throws IOException {
        OBJ_MAPPER.writeValue(out, value);
    }

    static {
        OBJ_MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        OBJ_MAPPER.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        SimpleModule partDeserializeModule = new SimpleModule("partDeserializeModule", new Version(0, 0, 1, null, "javax.servlet", "javax.servlet-api"));
        partDeserializeModule.addSerializer(Part.class, (JsonSerializer)new JavaxServletPartSerializer());
        partDeserializeModule.addDeserializer(Part.class, (JsonDeserializer)new JavaxServletPartDeserializer());
        OBJ_MAPPER.registerModule((Module)partDeserializeModule);
    }
}

