/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.assertj.core.api.AbstractTemporalAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldBeAfter;
import org.assertj.core.error.ShouldBeAfterOrEqualsTo;
import org.assertj.core.error.ShouldBeBefore;
import org.assertj.core.error.ShouldBeBeforeOrEqualsTo;
import org.assertj.core.error.ShouldBeEqualIgnoringHours;
import org.assertj.core.error.ShouldBeEqualIgnoringMinutes;
import org.assertj.core.error.ShouldBeEqualIgnoringNanos;
import org.assertj.core.error.ShouldBeEqualIgnoringSeconds;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.Preconditions;

public abstract class AbstractZonedDateTimeAssert<SELF extends AbstractZonedDateTimeAssert<SELF>>
extends AbstractTemporalAssert<SELF, ZonedDateTime> {
    public static final String NULL_DATE_TIME_PARAMETER_MESSAGE = "The ZonedDateTime to compare actual with should not be null";

    private static void assertDateTimeParameterIsNotNull(ZonedDateTime dateTime) {
        Preconditions.checkArgument(dateTime != null, NULL_DATE_TIME_PARAMETER_MESSAGE, new Object[0]);
    }

    public SELF isBefore(ZonedDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractZonedDateTimeAssert.assertDateTimeParameterIsNotNull(other);
        if (!((ZonedDateTime)this.actual).isBefore(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeBefore.shouldBeBefore(this.actual, other));
        }
        return (SELF)((AbstractZonedDateTimeAssert)this.myself);
    }

    public SELF isBefore(String dateTimeAsString) {
        AbstractZonedDateTimeAssert.assertDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return this.isBefore(this.parse(dateTimeAsString));
    }

    public SELF isBeforeOrEqualTo(ZonedDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractZonedDateTimeAssert.assertDateTimeParameterIsNotNull(other);
        if (((ZonedDateTime)this.actual).isAfter(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeBeforeOrEqualsTo.shouldBeBeforeOrEqualsTo(this.actual, other));
        }
        return (SELF)((AbstractZonedDateTimeAssert)this.myself);
    }

    public SELF isBeforeOrEqualTo(String dateTimeAsString) {
        AbstractZonedDateTimeAssert.assertDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return this.isBeforeOrEqualTo(this.parse(dateTimeAsString));
    }

    public SELF isAfterOrEqualTo(ZonedDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractZonedDateTimeAssert.assertDateTimeParameterIsNotNull(other);
        if (((ZonedDateTime)this.actual).isBefore(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeAfterOrEqualsTo.shouldBeAfterOrEqualsTo(this.actual, other));
        }
        return (SELF)((AbstractZonedDateTimeAssert)this.myself);
    }

    public SELF isAfterOrEqualTo(String dateTimeAsString) {
        AbstractZonedDateTimeAssert.assertDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return this.isAfterOrEqualTo(this.parse(dateTimeAsString));
    }

    public SELF isAfter(ZonedDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractZonedDateTimeAssert.assertDateTimeParameterIsNotNull(other);
        if (!((ZonedDateTime)this.actual).isAfter(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeAfter.shouldBeAfter(this.actual, other));
        }
        return (SELF)((AbstractZonedDateTimeAssert)this.myself);
    }

    public SELF isAfter(String dateTimeAsString) {
        AbstractZonedDateTimeAssert.assertDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return this.isAfter(this.parse(dateTimeAsString));
    }

    public SELF isEqualToIgnoringNanos(ZonedDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractZonedDateTimeAssert.assertDateTimeParameterIsNotNull(other);
        ZonedDateTime otherInActualTimeZone = this.sameInstantInActualTimeZone(other);
        if (!AbstractZonedDateTimeAssert.areEqualIgnoringNanos((ZonedDateTime)this.actual, otherInActualTimeZone)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringNanos.shouldBeEqualIgnoringNanos(this.actual, otherInActualTimeZone));
        }
        return (SELF)((AbstractZonedDateTimeAssert)this.myself);
    }

    public SELF isEqualToIgnoringSeconds(ZonedDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractZonedDateTimeAssert.assertDateTimeParameterIsNotNull(other);
        ZonedDateTime otherInActualTimeZone = this.sameInstantInActualTimeZone(other);
        if (!AbstractZonedDateTimeAssert.areEqualIgnoringSeconds((ZonedDateTime)this.actual, otherInActualTimeZone)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringSeconds.shouldBeEqualIgnoringSeconds(this.actual, otherInActualTimeZone));
        }
        return (SELF)((AbstractZonedDateTimeAssert)this.myself);
    }

    public SELF isEqualToIgnoringMinutes(ZonedDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractZonedDateTimeAssert.assertDateTimeParameterIsNotNull(other);
        ZonedDateTime otherInActualTimeZone = this.sameInstantInActualTimeZone(other);
        if (!AbstractZonedDateTimeAssert.areEqualIgnoringMinutes((ZonedDateTime)this.actual, otherInActualTimeZone)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringMinutes.shouldBeEqualIgnoringMinutes(this.actual, otherInActualTimeZone));
        }
        return (SELF)((AbstractZonedDateTimeAssert)this.myself);
    }

    public SELF isEqualToIgnoringHours(ZonedDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractZonedDateTimeAssert.assertDateTimeParameterIsNotNull(other);
        ZonedDateTime otherInActualTimeZone = this.sameInstantInActualTimeZone(other);
        if (!AbstractZonedDateTimeAssert.haveSameYearMonthAndDayOfMonth((ZonedDateTime)this.actual, otherInActualTimeZone)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringHours.shouldBeEqualIgnoringHours(this.actual, otherInActualTimeZone));
        }
        return (SELF)((AbstractZonedDateTimeAssert)this.myself);
    }

    public SELF isEqualTo(ZonedDateTime expected) {
        return (SELF)((AbstractZonedDateTimeAssert)super.isEqualTo(this.sameInstantInActualTimeZone(expected)));
    }

    public SELF isEqualTo(String dateTimeAsString) {
        AbstractZonedDateTimeAssert.assertDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return (SELF)((AbstractZonedDateTimeAssert)super.isEqualTo(this.parse(dateTimeAsString)));
    }

    public SELF isNotEqualTo(ZonedDateTime expected) {
        return (SELF)((AbstractZonedDateTimeAssert)super.isNotEqualTo(this.sameInstantInActualTimeZone(expected)));
    }

    public SELF isNotEqualTo(String dateTimeAsString) {
        AbstractZonedDateTimeAssert.assertDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return (SELF)((AbstractZonedDateTimeAssert)super.isNotEqualTo(this.parse(dateTimeAsString)));
    }

    public SELF isIn(ZonedDateTime ... expected) {
        return (SELF)((AbstractZonedDateTimeAssert)this.isIn((Object[])this.changeToActualTimeZone(expected)));
    }

    public SELF isIn(String ... dateTimesAsString) {
        this.checkIsNotNullAndNotEmpty(dateTimesAsString);
        return this.isIn(this.convertToDateTimeArray(dateTimesAsString));
    }

    public SELF isNotIn(ZonedDateTime ... expected) {
        return (SELF)((AbstractZonedDateTimeAssert)this.isNotIn((Object[])this.changeToActualTimeZone(expected)));
    }

    public SELF isNotIn(String ... dateTimesAsString) {
        this.checkIsNotNullAndNotEmpty(dateTimesAsString);
        return this.isNotIn(this.convertToDateTimeArray(dateTimesAsString));
    }

    public SELF isBetween(ZonedDateTime startInclusive, ZonedDateTime endInclusive) {
        this.comparables.assertIsBetween(this.info, (Comparable)this.actual, startInclusive, endInclusive, true, true);
        return (SELF)((AbstractZonedDateTimeAssert)this.myself);
    }

    public SELF isBetween(String startInclusive, String endInclusive) {
        return this.isBetween(this.parse(startInclusive), this.parse(endInclusive));
    }

    public SELF isStrictlyBetween(ZonedDateTime startExclusive, ZonedDateTime endExclusive) {
        this.comparables.assertIsBetween(this.info, (Comparable)this.actual, startExclusive, endExclusive, false, false);
        return (SELF)((AbstractZonedDateTimeAssert)this.myself);
    }

    public SELF isStrictlyBetween(String startExclusive, String endExclusive) {
        return this.isStrictlyBetween(this.parse(startExclusive), this.parse(endExclusive));
    }

    private ZonedDateTime[] convertToDateTimeArray(String ... dateTimesAsString) {
        ZonedDateTime[] dates = new ZonedDateTime[dateTimesAsString.length];
        for (int i = 0; i < dateTimesAsString.length; ++i) {
            dates[i] = this.parse(dateTimesAsString[i]);
        }
        return dates;
    }

    private ZonedDateTime[] changeToActualTimeZone(ZonedDateTime ... dateTimes) {
        ZonedDateTime[] dates = new ZonedDateTime[dateTimes.length];
        for (int i = 0; i < dateTimes.length; ++i) {
            dates[i] = this.sameInstantInActualTimeZone(dateTimes[i]);
        }
        return dates;
    }

    private void checkIsNotNullAndNotEmpty(Object[] values) {
        Preconditions.checkArgument(values != null, "The given ZonedDateTime array should not be null", new Object[0]);
        Preconditions.checkArgument(values.length > 0, "The given ZonedDateTime array should not be empty", new Object[0]);
    }

    @Override
    protected ZonedDateTime parse(String dateTimeAsString) {
        ZonedDateTime zonedDateTime = ZonedDateTime.parse(dateTimeAsString, DateTimeFormatter.ISO_DATE_TIME);
        return this.sameInstantInActualTimeZone(zonedDateTime);
    }

    private ZonedDateTime sameInstantInActualTimeZone(ZonedDateTime zonedDateTime) {
        if (zonedDateTime == null) {
            return null;
        }
        if (this.actual == null) {
            return zonedDateTime;
        }
        return zonedDateTime.withZoneSameInstant(((ZonedDateTime)this.actual).getZone());
    }

    private static void assertDateTimeAsStringParameterIsNotNull(String dateTimeAsString) {
        Preconditions.checkArgument(dateTimeAsString != null, "The String representing the ZonedDateTime to compare actual with should not be null", new Object[0]);
    }

    private static boolean areEqualIgnoringNanos(ZonedDateTime actual, ZonedDateTime other) {
        return AbstractZonedDateTimeAssert.areEqualIgnoringSeconds(actual, other) && actual.getSecond() == other.getSecond();
    }

    private static boolean areEqualIgnoringSeconds(ZonedDateTime actual, ZonedDateTime other) {
        return AbstractZonedDateTimeAssert.areEqualIgnoringMinutes(actual, other) && actual.getMinute() == other.getMinute();
    }

    private static boolean areEqualIgnoringMinutes(ZonedDateTime actual, ZonedDateTime other) {
        return AbstractZonedDateTimeAssert.haveSameYearMonthAndDayOfMonth(actual, other) && actual.getHour() == other.getHour();
    }

    private static boolean haveSameYearMonthAndDayOfMonth(ZonedDateTime actual, ZonedDateTime other) {
        return AbstractZonedDateTimeAssert.haveSameYearAndMonth(actual, other) && actual.getDayOfMonth() == other.getDayOfMonth();
    }

    private static boolean haveSameYearAndMonth(ZonedDateTime actual, ZonedDateTime other) {
        return AbstractZonedDateTimeAssert.haveSameYear(actual, other) && actual.getMonth() == other.getMonth();
    }

    private static boolean haveSameYear(ZonedDateTime actual, ZonedDateTime other) {
        return actual.getYear() == other.getYear();
    }

    protected AbstractZonedDateTimeAssert(ZonedDateTime actual, Class<?> selfType) {
        super(actual, selfType);
    }
}

