/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.importer.support.internal.aop;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.osgi.service.ServiceUnavailableException;
import org.springframework.osgi.service.importer.DefaultOsgiServiceDependency;
import org.springframework.osgi.service.importer.OsgiServiceDependency;
import org.springframework.osgi.service.importer.OsgiServiceLifecycleListener;
import org.springframework.osgi.service.importer.ServiceProxyDestroyedException;
import org.springframework.osgi.service.importer.event.OsgiServiceDependencyWaitEndedEvent;
import org.springframework.osgi.service.importer.event.OsgiServiceDependencyWaitStartingEvent;
import org.springframework.osgi.service.importer.event.OsgiServiceDependencyWaitTimedOutEvent;
import org.springframework.osgi.service.importer.support.OsgiServiceProxyFactoryBean;
import org.springframework.osgi.service.importer.support.internal.aop.ServiceInvoker;
import org.springframework.osgi.service.importer.support.internal.aop.SwappingServiceReferenceProxy;
import org.springframework.osgi.service.importer.support.internal.dependency.ImporterStateListener;
import org.springframework.osgi.service.importer.support.internal.support.DefaultRetryCallback;
import org.springframework.osgi.service.importer.support.internal.support.RetryCallback;
import org.springframework.osgi.service.importer.support.internal.support.RetryTemplate;
import org.springframework.osgi.service.importer.support.internal.support.ServiceWrapper;
import org.springframework.osgi.service.importer.support.internal.util.OsgiServiceBindingUtils;
import org.springframework.osgi.util.OsgiListenerUtils;
import org.springframework.osgi.util.OsgiServiceReferenceUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class ServiceDynamicInterceptor
extends ServiceInvoker
implements InitializingBean,
ApplicationEventPublisherAware {
    private static final int hashCode = ServiceDynamicInterceptor.class.hashCode() * 13;
    private static final Log PUBLIC_LOGGER = LogFactory.getLog((Class)OsgiServiceProxyFactoryBean.class);
    private final BundleContext bundleContext;
    private final String filterClassName;
    private final Filter filter;
    private final ClassLoader classLoader;
    private final SwappingServiceReferenceProxy referenceDelegate;
    private final ServiceListener listener;
    private boolean serviceRequiredAtStartup = true;
    private boolean isDuringDestruction = false;
    private boolean destroyed = false;
    private final Object lock = new Object();
    private ServiceWrapper wrapper;
    private final RetryTemplate retryTemplate = new EventSenderRetryTemplate();
    private final RetryCallback retryCallback = new ServiceLookUpCallback();
    private Object eventSource;
    private String sourceName;
    private OsgiServiceLifecycleListener[] listeners = new OsgiServiceLifecycleListener[0];
    private Object proxy;
    private ApplicationEventPublisher applicationEventPublisher;
    private OsgiServiceDependency dependency;
    private List stateListeners = Collections.EMPTY_LIST;

    public ServiceDynamicInterceptor(BundleContext context, String filterClassName, Filter filter, ClassLoader classLoader) {
        this.bundleContext = context;
        this.filterClassName = filterClassName;
        this.filter = filter;
        this.classLoader = classLoader;
        this.referenceDelegate = new SwappingServiceReferenceProxy();
        this.listener = new Listener();
    }

    public Object getTarget() {
        Object target = this.lookupService();
        if (target == null) {
            throw new ServiceUnavailableException(this.filter);
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object lookupService() {
        Object object = this.lock;
        synchronized (object) {
            return this.retryTemplate.execute(this.retryCallback);
        }
    }

    private void publishEvent(ApplicationEvent event) {
        if (this.applicationEventPublisher != null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Publishing event through publisher " + this.applicationEventPublisher));
            }
            try {
                this.applicationEventPublisher.publishEvent(event);
            }
            catch (IllegalStateException ise) {
                this.log.debug((Object)("Event " + event + " not published as the publisher is not initialized - usually this is caused by eager initialization of the importers by post processing"), (Throwable)ise);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"No application event publisher set; no events will be published");
        }
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.proxy);
        Assert.notNull((Object)this.eventSource);
        boolean debug = this.log.isDebugEnabled();
        this.dependency = new DefaultOsgiServiceDependency(this.sourceName, this.filter, this.serviceRequiredAtStartup);
        if (debug) {
            this.log.debug((Object)("Adding OSGi mandatoryListeners for services matching [" + this.filter + "]"));
        }
        OsgiListenerUtils.addSingleServiceListener(this.bundleContext, this.listener, this.filter);
        if (this.serviceRequiredAtStartup) {
            if (debug) {
                this.log.debug((Object)("1..x cardinality - looking for service [" + this.filter + "] at startup..."));
            }
            PUBLIC_LOGGER.info((Object)("Looking for mandatory OSGi service dependency for bean [" + this.sourceName + "] matching filter " + this.filter));
            Object target = this.getTarget();
            if (debug) {
                this.log.debug((Object)("Service retrieved " + target));
            }
            PUBLIC_LOGGER.info((Object)("Found mandatory OSGi service for bean [" + this.sourceName + "]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        OsgiListenerUtils.removeServiceListener(this.bundleContext, this.listener);
        Object object = this.lock;
        synchronized (object) {
            ServiceReference ref;
            this.destroyed = true;
            this.isDuringDestruction = true;
            if (this.wrapper != null && (ref = this.wrapper.getReference()) != null) {
                this.listener.serviceChanged(new ServiceEvent(4, ref));
            }
            this.isDuringDestruction = false;
            this.lock.notifyAll();
        }
    }

    public ServiceReference getServiceReference() {
        return this.referenceDelegate;
    }

    public void setRetryTimeout(long timeout) {
        this.retryTemplate.reset(timeout);
    }

    public RetryTemplate getRetryTemplate() {
        return this.retryTemplate;
    }

    public OsgiServiceLifecycleListener[] getListeners() {
        return this.listeners;
    }

    public void setListeners(OsgiServiceLifecycleListener[] listeners) {
        this.listeners = listeners;
    }

    public void setServiceImporter(Object importer) {
        this.eventSource = importer;
    }

    public void setServiceImporterName(String name) {
        this.sourceName = name;
    }

    public void setRequiredAtStartup(boolean requiredAtStartup) {
        this.serviceRequiredAtStartup = requiredAtStartup;
    }

    public void setProxy(Object proxy) {
        this.proxy = proxy;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setStateListeners(List stateListeners) {
        this.stateListeners = stateListeners;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ServiceDynamicInterceptor) {
            ServiceDynamicInterceptor oth = (ServiceDynamicInterceptor)other;
            return this.serviceRequiredAtStartup == oth.serviceRequiredAtStartup && ObjectUtils.nullSafeEquals((Object)this.wrapper, (Object)oth.wrapper) && ObjectUtils.nullSafeEquals((Object)this.filter, (Object)oth.filter) && ObjectUtils.nullSafeEquals((Object)this.retryTemplate, (Object)oth.retryTemplate);
        }
        return false;
    }

    public int hashCode() {
        return hashCode;
    }

    private class Listener
    implements ServiceListener {
        private Listener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void serviceChanged(ServiceEvent event) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(ServiceDynamicInterceptor.this.classLoader);
                ServiceReference ref = event.getServiceReference();
                long serviceId = (Long)ref.getProperty("service.id");
                Integer rank = (Integer)ref.getProperty("service.ranking");
                int ranking = rank == null ? 0 : rank;
                boolean debug = ServiceDynamicInterceptor.this.log.isDebugEnabled();
                boolean publicDebug = PUBLIC_LOGGER.isDebugEnabled();
                switch (event.getType()) {
                    case 1: 
                    case 2: {
                        boolean servicePresent = false;
                        Object object = ServiceDynamicInterceptor.this.lock;
                        synchronized (object) {
                            servicePresent = ServiceDynamicInterceptor.this.wrapper != null && ServiceDynamicInterceptor.this.wrapper.isServiceAlive();
                        }
                        if (!this.updateWrapperIfNecessary(ref, serviceId, ranking)) return;
                        OsgiServiceBindingUtils.callListenersBind(ServiceDynamicInterceptor.this.bundleContext, ServiceDynamicInterceptor.this.proxy, ref, ServiceDynamicInterceptor.this.listeners);
                        if (servicePresent) return;
                        this.notifySatisfiedStateListeners();
                        return;
                    }
                    case 4: {
                        boolean serviceRemoved = false;
                        ServiceWrapper oldWrapper = ServiceDynamicInterceptor.this.wrapper;
                        Object object = ServiceDynamicInterceptor.this.lock;
                        synchronized (object) {
                            if (ServiceDynamicInterceptor.this.wrapper != null && serviceId == ServiceDynamicInterceptor.this.wrapper.getServiceId()) {
                                serviceRemoved = true;
                                ServiceDynamicInterceptor.this.wrapper = null;
                            }
                        }
                        ServiceReference newReference = null;
                        boolean isDestroyed = false;
                        Object object2 = ServiceDynamicInterceptor.this.lock;
                        synchronized (object2) {
                            isDestroyed = ServiceDynamicInterceptor.this.destroyed;
                        }
                        if (!isDestroyed && (newReference = OsgiServiceReferenceUtils.getServiceReference(ServiceDynamicInterceptor.this.bundleContext, ServiceDynamicInterceptor.this.filterClassName, ServiceDynamicInterceptor.this.filter == null ? null : ServiceDynamicInterceptor.this.filter.toString())) != null) {
                            this.serviceChanged(new ServiceEvent(2, newReference));
                        }
                        if (newReference != null || !serviceRemoved) return;
                        object2 = ServiceDynamicInterceptor.this.lock;
                        synchronized (object2) {
                            ServiceDynamicInterceptor.this.wrapper = oldWrapper;
                        }
                        OsgiServiceBindingUtils.callListenersUnbind(ServiceDynamicInterceptor.this.bundleContext, ServiceDynamicInterceptor.this.proxy, ref, ServiceDynamicInterceptor.this.listeners);
                        object2 = ServiceDynamicInterceptor.this.lock;
                        synchronized (object2) {
                            ServiceDynamicInterceptor.this.wrapper = null;
                        }
                        if (debug || publicDebug) {
                            String message = "Service reference [" + ref + "] was unregistered";
                            message = serviceRemoved ? message + " and unbound from the service proxy" : message + " but did not affect the service proxy";
                            if (debug) {
                                ServiceDynamicInterceptor.this.log.debug((Object)message);
                            }
                            if (publicDebug) {
                                PUBLIC_LOGGER.debug((Object)message);
                            }
                        }
                        this.notifyUnsatisfiedStateListeners();
                        return;
                    }
                    default: {
                        throw new IllegalArgumentException("unsupported event type");
                    }
                }
            }
            catch (Throwable e) {
                ServiceDynamicInterceptor.this.log.fatal((Object)"Exception during service event handling", e);
                return;
            }
            finally {
                Thread.currentThread().setContextClassLoader(tccl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifySatisfiedStateListeners() {
            List list = ServiceDynamicInterceptor.this.stateListeners;
            synchronized (list) {
                Iterator iterator = ServiceDynamicInterceptor.this.stateListeners.iterator();
                while (iterator.hasNext()) {
                    ImporterStateListener stateListener = (ImporterStateListener)iterator.next();
                    stateListener.importerSatisfied(ServiceDynamicInterceptor.this.eventSource, ServiceDynamicInterceptor.this.dependency);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyUnsatisfiedStateListeners() {
            List list = ServiceDynamicInterceptor.this.stateListeners;
            synchronized (list) {
                Iterator iterator = ServiceDynamicInterceptor.this.stateListeners.iterator();
                while (iterator.hasNext()) {
                    ImporterStateListener stateListener = (ImporterStateListener)iterator.next();
                    stateListener.importerUnsatisfied(ServiceDynamicInterceptor.this.eventSource, ServiceDynamicInterceptor.this.dependency);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean updateWrapperIfNecessary(ServiceReference ref, long serviceId, int serviceRanking) {
            boolean updated = false;
            try {
                Object object = ServiceDynamicInterceptor.this.lock;
                synchronized (object) {
                    if (ServiceDynamicInterceptor.this.wrapper != null && ServiceDynamicInterceptor.this.wrapper.isServiceAlive()) {
                        if (serviceRanking > ServiceDynamicInterceptor.this.wrapper.getServiceRanking()) {
                            updated = true;
                            this.updateReferenceHolders(ref);
                        }
                        if (serviceRanking == ServiceDynamicInterceptor.this.wrapper.getServiceRanking() && serviceId < ServiceDynamicInterceptor.this.wrapper.getServiceId()) {
                            updated = true;
                            this.updateReferenceHolders(ref);
                        }
                    } else {
                        updated = true;
                        this.updateReferenceHolders(ref);
                    }
                    ServiceDynamicInterceptor.this.lock.notifyAll();
                    boolean bl = updated;
                    return bl;
                }
            }
            finally {
                boolean debug = ServiceDynamicInterceptor.this.log.isDebugEnabled();
                boolean publicDebug = PUBLIC_LOGGER.isDebugEnabled();
                if (debug || publicDebug) {
                    String message = "Service reference [" + ref + "]";
                    message = updated ? message + " bound to proxy" : message + " not bound to proxy";
                    if (debug) {
                        ServiceDynamicInterceptor.this.log.debug((Object)message);
                    }
                    if (publicDebug) {
                        PUBLIC_LOGGER.debug((Object)message);
                    }
                }
            }
        }

        private void updateReferenceHolders(ServiceReference ref) {
            ServiceDynamicInterceptor.this.wrapper = new ServiceWrapper(ref, ServiceDynamicInterceptor.this.bundleContext);
            ServiceDynamicInterceptor.this.referenceDelegate.swapDelegates(ref);
        }
    }

    private class ServiceLookUpCallback
    extends DefaultRetryCallback {
        private ServiceLookUpCallback() {
        }

        public Object doWithRetry() {
            if (ServiceDynamicInterceptor.this.destroyed && !ServiceDynamicInterceptor.this.isDuringDestruction) {
                throw new ServiceProxyDestroyedException();
            }
            return ServiceDynamicInterceptor.this.wrapper != null ? ServiceDynamicInterceptor.this.wrapper.getService() : null;
        }
    }

    private class EventSenderRetryTemplate
    extends RetryTemplate {
        public EventSenderRetryTemplate(long waitTime) {
            super(waitTime, ServiceDynamicInterceptor.this.lock);
        }

        public EventSenderRetryTemplate() {
            super(ServiceDynamicInterceptor.this.lock);
        }

        protected void callbackFailed(long stop2) {
            ServiceDynamicInterceptor.this.publishEvent(new OsgiServiceDependencyWaitTimedOutEvent(ServiceDynamicInterceptor.this.eventSource, ServiceDynamicInterceptor.this.dependency, stop2));
        }

        protected void callbackSucceeded(long stop2) {
            ServiceDynamicInterceptor.this.publishEvent(new OsgiServiceDependencyWaitEndedEvent(ServiceDynamicInterceptor.this.eventSource, ServiceDynamicInterceptor.this.dependency, stop2));
        }

        protected void onMissingTarget() {
            ServiceDynamicInterceptor.this.publishEvent(new OsgiServiceDependencyWaitStartingEvent(ServiceDynamicInterceptor.this.eventSource, ServiceDynamicInterceptor.this.dependency, this.getWaitTime()));
        }
    }
}

