/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.util.internal;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.core.CollectionFactory;
import org.springframework.core.ConcurrentMap;
import org.springframework.core.JdkVersion;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public abstract class ClassUtils {
    public static final int INCLUDE_INTERFACES = 1;
    public static final int INCLUDE_CLASS_HIERARCHY = 2;
    public static final int INCLUDE_ALL_CLASSES = 3;
    private static final boolean backportConcurrentAvailable = org.springframework.util.ClassUtils.isPresent((String)"edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap", (ClassLoader)CollectionFactory.class.getClassLoader());
    public static final List knownNonOsgiLoaders;
    public static final Set knownNonOsgiLoadersSet;
    static /* synthetic */ Class class$org$osgi$framework$Bundle;
    static /* synthetic */ Class class$java$lang$Object;

    public static ClassLoader getFwkClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return (class$org$osgi$framework$Bundle == null ? (class$org$osgi$framework$Bundle = ClassUtils.class$("org.osgi.framework.Bundle")) : class$org$osgi$framework$Bundle).getClassLoader();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addNonOsgiClassLoader(ClassLoader classLoader, List list, Map map2) {
        while (classLoader != null) {
            List list2 = list;
            synchronized (list2) {
                if (!map2.containsKey(classLoader)) {
                    list.add(classLoader);
                    map2.put(classLoader, Boolean.TRUE);
                }
            }
            classLoader = classLoader.getParent();
        }
    }

    public static Class[] getClassHierarchy(Class clazz, int mode) {
        Class[] classes = null;
        if (clazz != null && ClassUtils.isModeValid(mode)) {
            LinkedHashSet composingClasses = new LinkedHashSet();
            boolean includeClasses = ClassUtils.includesMode(mode, 2);
            boolean includeInterfaces = ClassUtils.includesMode(mode, 1);
            Class clz = clazz;
            do {
                if (includeClasses) {
                    composingClasses.add(clz);
                }
                if (!includeInterfaces) continue;
                CollectionUtils.mergeArrayIntoCollection((Object)ClassUtils.getAllInterfaces(clz), composingClasses);
            } while ((clz = clz.getSuperclass()) != null && clz != (class$java$lang$Object == null ? ClassUtils.class$("java.lang.Object") : class$java$lang$Object));
            classes = composingClasses.toArray(new Class[composingClasses.size()]);
        }
        return classes == null ? new Class[]{} : classes;
    }

    public static Class[] getVisibleClassHierarchy(Class clazz, int mode, ClassLoader loader) {
        if (clazz == null) {
            return new Class[0];
        }
        return ClassUtils.getVisibleClasses(ClassUtils.getClassHierarchy(clazz, mode), ClassUtils.getClassLoader(clazz));
    }

    public static Class[] getVisibleClassHierarchy(Class clazz, int mode, Bundle bundle) {
        return ClassUtils.getVisibleClasses(ClassUtils.getClassHierarchy(clazz, mode), bundle);
    }

    public static Class[] getVisibleClasses(Class[] classes, ClassLoader classLoader) {
        return ClassUtils.getVisibleClasses(classes, new ClassLoaderBridge(classLoader));
    }

    public static Class[] getVisibleClasses(Class[] classes, Bundle bundle) {
        return ClassUtils.getVisibleClasses(classes, new ClassLoaderBridge(bundle));
    }

    private static Class[] getVisibleClasses(Class[] classes, ClassLoaderBridge loader) {
        if (ObjectUtils.isEmpty((Object[])classes)) {
            return classes;
        }
        LinkedHashSet classSet = new LinkedHashSet(classes.length);
        CollectionUtils.mergeArrayIntoCollection((Object)classes, classSet);
        Iterator iter = classSet.iterator();
        while (iter.hasNext()) {
            Class clzz = (Class)iter.next();
            if (loader.canSee(clzz.getName())) continue;
            iter.remove();
        }
        return classSet.toArray(new Class[classSet.size()]);
    }

    public static Class[] getAllInterfaces(Class clazz) {
        Assert.notNull((Object)clazz);
        return ClassUtils.getAllInterfaces(clazz, new LinkedHashSet(8));
    }

    private static Class[] getAllInterfaces(Class clazz, Set interfaces) {
        Class<?>[] intfs = clazz.getInterfaces();
        CollectionUtils.mergeArrayIntoCollection(intfs, (Collection)interfaces);
        for (int i = 0; i < intfs.length; ++i) {
            ClassUtils.getAllInterfaces(intfs[i], interfaces);
        }
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    public static boolean isPresent(String className, Bundle bundle) {
        Assert.hasText((String)className);
        Assert.notNull((Object)bundle);
        try {
            bundle.loadClass(className);
            return true;
        }
        catch (Exception cnfe) {
            return false;
        }
    }

    public static ClassLoader getClassLoader(Class clazz) {
        Assert.notNull((Object)clazz);
        ClassLoader loader = clazz.getClassLoader();
        return loader == null ? ClassLoader.getSystemClassLoader() : loader;
    }

    private static boolean includesMode(int testedMode, int mode) {
        return (testedMode & mode) == mode;
    }

    private static boolean isModeValid(int mode) {
        return mode >= 1 && mode <= 3;
    }

    public static String[] toStringArray(Class[] array) {
        if (ObjectUtils.isEmpty((Object[])array)) {
            return new String[0];
        }
        String[] strings = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            strings[i] = array[i].getName();
        }
        return strings;
    }

    public static boolean concurrentLibAvailable() {
        return backportConcurrentAvailable || JdkVersion.isAtLeastJava15();
    }

    public static boolean containsUnrelatedClasses(Class[] classes) {
        if (ObjectUtils.isEmpty((Object[])classes)) {
            return false;
        }
        Class clazz = null;
        for (int i = 0; i < classes.length; ++i) {
            if (classes[i].isInterface()) continue;
            if (clazz == null) {
                clazz = classes[i];
                continue;
            }
            if (clazz.isAssignableFrom(classes[i])) {
                clazz = classes[i];
                continue;
            }
            if (classes[i].isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public static Class[] removeParents(Class[] classes) {
        boolean dirty;
        if (ObjectUtils.isEmpty((Object[])classes)) {
            return new Class[0];
        }
        ArrayList<Class> clazz = new ArrayList<Class>(classes.length);
        for (int i = 0; i < classes.length; ++i) {
            clazz.add(classes[i]);
        }
        while (clazz.remove(null)) {
        }
        do {
            dirty = false;
            block3: for (int i = 0; i < clazz.size(); ++i) {
                Class currentClass = (Class)clazz.get(i);
                for (int j = 0; j < clazz.size(); ++j) {
                    if (i == j || !currentClass.isAssignableFrom((Class)clazz.get(j))) continue;
                    clazz.remove(i);
                    --i;
                    dirty = true;
                    continue block3;
                }
            }
        } while (dirty);
        return clazz.toArray(new Class[clazz.size()]);
    }

    public static void configureFactoryForClass(ProxyFactory factory, Class[] classes) {
        if (ObjectUtils.isEmpty((Object[])classes)) {
            return;
        }
        for (int i = 0; i < classes.length; ++i) {
            Class clazz = classes[i];
            if (clazz.isInterface()) {
                factory.addInterface(clazz);
                continue;
            }
            factory.setTargetClass(clazz);
            factory.setProxyTargetClass(true);
        }
    }

    public static Class[] loadClasses(String[] classNames, ClassLoader classLoader) {
        if (ObjectUtils.isEmpty((Object[])classNames)) {
            return new Class[0];
        }
        Assert.notNull((Object)classLoader, (String)"classLoader is required");
        LinkedHashSet classes = new LinkedHashSet(classNames.length);
        for (int i = 0; i < classNames.length; ++i) {
            try {
                classes.add(classLoader.loadClass(classNames[i]));
                continue;
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
        }
        return classes.toArray(new Class[classes.size()]);
    }

    public static Class[] excludeClassesWithModifier(Class[] classes, int modifier) {
        if (ObjectUtils.isEmpty((Object[])classes)) {
            return new Class[0];
        }
        LinkedHashSet<Class> clazzes = new LinkedHashSet<Class>(classes.length);
        for (int i = 0; i < classes.length; ++i) {
            if ((modifier & classes[i].getModifiers()) != 0) continue;
            clazzes.add(classes[i]);
        }
        return clazzes.toArray(new Class[clazzes.size()]);
    }

    public static Class getParticularClass(Class[] classes) {
        for (int i = 0; i < classes.length; ++i) {
            Class clazz = classes[i];
            ClassLoader loader = clazz.getClassLoader();
            if (loader == null || knownNonOsgiLoadersSet.contains(loader)) continue;
            return clazz;
        }
        return classes[0];
    }

    static {
        ConcurrentMap lookupMap = CollectionFactory.createConcurrentMap((int)8);
        final List lookupList = Collections.synchronizedList(new ArrayList());
        AccessController.doPrivileged(new PrivilegedAction((Map)lookupMap){
            private final /* synthetic */ Map val$lookupMap;
            {
                this.val$lookupMap = map2;
            }

            public Object run() {
                ClassLoader classLoader = ClassUtils.getFwkClassLoader();
                ClassUtils.addNonOsgiClassLoader(classLoader, lookupList, this.val$lookupMap);
                classLoader = ClassLoader.getSystemClassLoader();
                ClassUtils.addNonOsgiClassLoader(classLoader, lookupList, this.val$lookupMap);
                return null;
            }
        });
        knownNonOsgiLoaders = Collections.unmodifiableList(lookupList);
        knownNonOsgiLoadersSet = new ReadOnlySetFromMap((Map)lookupMap);
    }

    private static class ClassLoaderBridge {
        private final Bundle bundle;
        private final ClassLoader classLoader;

        public ClassLoaderBridge(Bundle bundle) {
            Assert.notNull((Object)bundle);
            this.bundle = bundle;
            this.classLoader = null;
        }

        public ClassLoaderBridge(ClassLoader classLoader) {
            Assert.notNull((Object)classLoader);
            this.classLoader = classLoader;
            this.bundle = null;
        }

        public Class loadClass(String className) throws ClassNotFoundException {
            return this.bundle == null ? this.classLoader.loadClass(className) : this.bundle.loadClass(className);
        }

        public boolean canSee(String className) {
            return this.bundle == null ? org.springframework.util.ClassUtils.isPresent((String)className, (ClassLoader)this.classLoader) : ClassUtils.isPresent(className, this.bundle);
        }
    }

    private static class ReadOnlySetFromMap
    implements Set {
        private final Set keys;

        public ReadOnlySetFromMap(Map lookupMap) {
            this.keys = lookupMap.keySet();
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Object o) {
            return this.keys.contains(o);
        }

        public boolean containsAll(Collection c) {
            return this.keys.containsAll(c);
        }

        public boolean isEmpty() {
            return this.keys.isEmpty();
        }

        public Iterator iterator() {
            return this.keys.iterator();
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.keys.size();
        }

        public Object[] toArray() {
            return this.keys.toArray();
        }

        public Object[] toArray(Object[] array) {
            return this.keys.toArray(array);
        }

        public String toString() {
            return this.keys.toString();
        }

        public int hashCode() {
            return ((Object)this.keys).hashCode();
        }

        public boolean equals(Object o) {
            return o == this || ((Object)this.keys).equals(o);
        }
    }
}

