/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.service.log;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.knopflerfish.service.log.LogService;
import org.knopflerfish.service.log.LogUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class LogRef
implements ServiceListener,
LogService {
    private static final String LOG_CLASS_OSGI = org.osgi.service.log.LogService.class.getName();
    private static final String LOG_CLASS_KF = LogService.class.getName();
    private static final String logServiceFilter = "(|(objectClass=" + LOG_CLASS_KF + ")(objectClass=" + LOG_CLASS_OSGI + "))";
    private static SimpleDateFormat simpleDateFormat = null;
    private BundleContext bc;
    private ServiceReference logSR;
    private org.osgi.service.log.LogService log;
    private boolean useOut;
    private long bundleId;
    private boolean doWarnIfClosed;

    public LogRef(BundleContext bc, boolean out) {
        this.init(bc, out);
    }

    public LogRef(BundleContext bc) {
        boolean b = false;
        try {
            b = "true".equals(System.getProperty("org.knopflerfish.log.out"));
        }
        catch (Throwable t) {
            System.err.println("get system property failed: " + t);
            t.printStackTrace();
        }
        this.init(bc, b);
    }

    private void init(BundleContext bc, boolean out) {
        this.bc = bc;
        this.useOut = out;
        this.bundleId = bc.getBundle().getBundleId();
        try {
            bc.addServiceListener((ServiceListener)this, logServiceFilter);
        }
        catch (InvalidSyntaxException e) {
            this.error("Failed to register log service listener (filter=" + logServiceFilter + ")", e);
        }
    }

    public void serviceChanged(ServiceEvent evt) {
        if (evt.getServiceReference() == this.logSR && evt.getType() == 4) {
            this.ungetLogService();
        }
    }

    private synchronized void ungetLogService() {
        this.doWarnIfClosed = this.doDebug();
        if (this.log != null) {
            this.bc.ungetService(this.logSR);
            this.logSR = null;
            this.log = null;
        }
    }

    public void close() {
        this.ungetLogService();
        this.bc.removeServiceListener((ServiceListener)this);
        this.bc = null;
    }

    protected synchronized void doLog(String msg, int level, ServiceReference sr, Throwable e) {
        if (this.bc != null && this.log == null) {
            this.logSR = this.bc.getServiceReference(LOG_CLASS_KF);
            if (this.logSR == null) {
                this.logSR = this.bc.getServiceReference(LOG_CLASS_OSGI);
            }
            if (this.logSR != null) {
                this.log = (org.osgi.service.log.LogService)this.bc.getService(this.logSR);
            }
            if (this.log == null) {
                this.logSR = null;
            }
        }
        if (this.log != null) {
            this.log.log(sr, level, msg, e);
        } else if (this.useOut || this.doWarnIfClosed) {
            if (this.bc == null) {
                System.err.println("WARNING! Bundle #" + this.bundleId + " called closed LogRef object");
            }
            System.out.print(LogUtil.fromLevel(level, 8));
            System.out.print(" ");
            if (simpleDateFormat == null) {
                simpleDateFormat = new SimpleDateFormat("yyyyMMdd HH:mm:ss");
            }
            System.out.print(simpleDateFormat.format(new Date()));
            System.out.print(" ");
            System.out.print(this.getBundleName());
            System.out.print(" - ");
            if (sr != null) {
                System.out.print("[");
                System.out.print(sr);
                System.out.print("] ");
            }
            System.out.print(msg);
            if (e != null) {
                System.out.print(" (");
                System.out.print(e);
                System.out.print(")");
                System.out.println();
                e.printStackTrace();
            }
            System.out.println();
        }
    }

    @Override
    public int getLogLevel() {
        if (this.log != null && this.log instanceof LogService) {
            return ((LogService)this.log).getLogLevel();
        }
        return 4;
    }

    public boolean doDebug() {
        return this.getLogLevel() >= 4;
    }

    public boolean doWarn() {
        return this.getLogLevel() >= 2;
    }

    public boolean doInfo() {
        return this.getLogLevel() >= 3;
    }

    public boolean doError() {
        return this.getLogLevel() >= 1;
    }

    public void debug(String msg) {
        this.doLog(msg, 4, null, null);
    }

    public void debug(String msg, ServiceReference sr) {
        this.doLog(msg, 4, sr, null);
    }

    public void debug(String msg, Throwable e) {
        this.doLog(msg, 4, null, e);
    }

    public void debug(String msg, ServiceReference sr, Throwable e) {
        this.doLog(msg, 4, sr, e);
    }

    public void info(String msg) {
        this.doLog(msg, 3, null, null);
    }

    public void info(String msg, ServiceReference sr) {
        this.doLog(msg, 3, sr, null);
    }

    public void info(String msg, Throwable e) {
        this.doLog(msg, 3, null, e);
    }

    public void info(String msg, ServiceReference sr, Throwable e) {
        this.doLog(msg, 3, sr, e);
    }

    public void warn(String msg) {
        this.doLog(msg, 2, null, null);
    }

    public void warn(String msg, ServiceReference sr) {
        this.doLog(msg, 2, sr, null);
    }

    public void warn(String msg, Throwable e) {
        this.doLog(msg, 2, null, e);
    }

    public void warn(String msg, ServiceReference sr, Throwable e) {
        this.doLog(msg, 2, sr, e);
    }

    public void error(String msg) {
        this.doLog(msg, 1, null, null);
    }

    public void error(String msg, ServiceReference sr) {
        this.doLog(msg, 1, sr, null);
    }

    public void error(String msg, Throwable e) {
        this.doLog(msg, 1, null, e);
    }

    public void error(String msg, ServiceReference sr, Throwable e) {
        this.doLog(msg, 1, sr, e);
    }

    @Override
    public void log(int level, String message) {
        this.doLog(message, level, null, null);
    }

    @Override
    public void log(int level, String message, Throwable exception) {
        this.doLog(message, level, null, exception);
    }

    @Override
    public void log(ServiceReference sr, int level, String message) {
        this.doLog(message, level, sr, null);
    }

    @Override
    public void log(ServiceReference sr, int level, String message, Throwable exception) {
        this.doLog(message, level, sr, exception);
    }

    private String getBundleName() {
        StringBuffer bundleName = new StringBuffer(24);
        if (bundleName.length() <= 0) {
            bundleName.append("bid#");
            bundleName.append(String.valueOf(this.bundleId));
        }
        if (bundleName.length() < 12) {
            bundleName.append("            ");
            bundleName.setLength(12);
        }
        return bundleName.toString();
    }
}

