/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.commands.impl;

import java.util.List;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="shell", name="echo", description="Echoes or prints arguments to STDOUT.")
@Service
public class EchoAction
implements Action {
    @Option(name="-n", aliases={}, description="Do not print the trailing newline character", required=false, multiValued=false)
    private boolean noTrailingNewline = false;
    @Argument(index=0, name="arguments", description="Arguments to display separated by whitespaces", required=false, multiValued=true)
    private List<String> args;

    public Object execute() throws Exception {
        if (this.args != null) {
            boolean first = true;
            for (String arg : this.args) {
                if (first) {
                    first = false;
                } else {
                    System.out.print(" ");
                }
                System.out.print(arg);
            }
        }
        if (!this.noTrailingNewline) {
            System.out.println();
        }
        return null;
    }
}

