/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface NamedFactory<T>
extends Factory<T> {
    public String getName();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Utils {
        public static <T> List<String> getNameList(Collection<NamedFactory<T>> factories) {
            if (factories == null || factories.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<String> names = new ArrayList<String>(factories.size());
            for (NamedFactory<T> f : factories) {
                names.add(f.getName());
            }
            return names;
        }

        public static <T> T create(List<NamedFactory<T>> factories, String name) {
            if (factories != null) {
                for (NamedFactory<T> f : factories) {
                    if (!f.getName().equals(name)) continue;
                    return f.create();
                }
            }
            return null;
        }

        public static <T> String getNames(List<NamedFactory<T>> factories) {
            StringBuilder sb = new StringBuilder();
            for (NamedFactory<T> f : factories) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(f.getName());
            }
            return sb.toString();
        }

        public static <T> NamedFactory<T> remove(List<NamedFactory<T>> factories, String name) {
            for (NamedFactory<T> f : factories) {
                if (!f.getName().equals(name)) continue;
                factories.remove(f);
                return f;
            }
            return null;
        }

        public static <T> NamedFactory<T> get(List<NamedFactory<T>> factories, String name) {
            for (NamedFactory<T> f : factories) {
                if (!f.getName().equals(name)) continue;
                return f;
            }
            return null;
        }
    }
}

