/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JSonSchemaHelper {
    private static final Pattern PATTERN = Pattern.compile("\"(.+?)\"|\\[(.+)\\]");
    private static final String QUOT = "&quot;";

    private JSonSchemaHelper() {
    }

    public static List<Map<String, String>> parseJsonSchema(String group, String json, boolean parseProperties) {
        String[] lines;
        ArrayList<Map<String, String>> answer = new ArrayList<Map<String, String>>();
        if (json == null) {
            return answer;
        }
        boolean found = false;
        for (String line : lines = json.split("\n")) {
            if (!found) {
                String s = line.trim();
                found = s.startsWith("\"" + group + "\":") && s.endsWith("{");
                continue;
            }
            if (line.equals("  },") || line.equals("  }")) break;
            line = line.replaceAll("\"\\\\\"\"", "\"&quot;\"");
            LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
            Matcher matcher = PATTERN.matcher(line);
            String key = parseProperties ? "name" : null;
            while (matcher.find()) {
                if (key == null) {
                    key = matcher.group(1);
                    continue;
                }
                String value = matcher.group(1);
                if (value == null) {
                    value = matcher.group(2);
                    value = value.replaceAll("\"", "");
                    value = value.replaceAll(", ", ",");
                }
                if (value != null) {
                    value = value.trim();
                    value = value.replaceAll(QUOT, "\"");
                    value = JSonSchemaHelper.decodeJson(value);
                }
                row.put(key, value);
                key = null;
            }
            if (row.isEmpty()) continue;
            answer.add(row);
        }
        return answer;
    }

    private static String decodeJson(String value) {
        if ("\\\\".equals(value)) {
            value = "\\";
        }
        return value;
    }

    public static boolean isComponentLenientProperties(List<Map<String, String>> rows) {
        for (Map<String, String> row : rows) {
            if (!row.containsKey("lenientProperties")) continue;
            return "true".equals(row.get("lenientProperties"));
        }
        return false;
    }

    public static boolean isPropertyRequired(List<Map<String, String>> rows, String name) {
        for (Map<String, String> row : rows) {
            boolean required = false;
            boolean found = false;
            if (row.containsKey("name")) {
                found = name.equals(row.get("name"));
            }
            if (row.containsKey("required")) {
                required = "true".equals(row.get("required"));
            }
            if (!found) continue;
            return required;
        }
        return false;
    }

    public static String getPropertyKind(List<Map<String, String>> rows, String name) {
        for (Map<String, String> row : rows) {
            String kind = null;
            boolean found = false;
            if (row.containsKey("name")) {
                found = name.equals(row.get("name"));
            }
            if (row.containsKey("kind")) {
                kind = row.get("kind");
            }
            if (!found) continue;
            return kind;
        }
        return null;
    }

    public static boolean isPropertyBoolean(List<Map<String, String>> rows, String name) {
        for (Map<String, String> row : rows) {
            String type = null;
            boolean found = false;
            if (row.containsKey("name")) {
                found = name.equals(row.get("name"));
            }
            if (row.containsKey("type")) {
                type = row.get("type");
            }
            if (!found) continue;
            return "boolean".equals(type);
        }
        return false;
    }

    public static boolean isPropertyInteger(List<Map<String, String>> rows, String name) {
        for (Map<String, String> row : rows) {
            String type = null;
            boolean found = false;
            if (row.containsKey("name")) {
                found = name.equals(row.get("name"));
            }
            if (row.containsKey("type")) {
                type = row.get("type");
            }
            if (!found) continue;
            return "integer".equals(type);
        }
        return false;
    }

    public static boolean isPropertyNumber(List<Map<String, String>> rows, String name) {
        for (Map<String, String> row : rows) {
            String type = null;
            boolean found = false;
            if (row.containsKey("name")) {
                found = name.equals(row.get("name"));
            }
            if (row.containsKey("type")) {
                type = row.get("type");
            }
            if (!found) continue;
            return "number".equals(type);
        }
        return false;
    }

    public static boolean isPropertyObject(List<Map<String, String>> rows, String name) {
        for (Map<String, String> row : rows) {
            String type = null;
            boolean found = false;
            if (row.containsKey("name")) {
                found = name.equals(row.get("name"));
            }
            if (row.containsKey("type")) {
                type = row.get("type");
            }
            if (!found) continue;
            return "object".equals(type);
        }
        return false;
    }

    public static String getPropertyDefaultValue(List<Map<String, String>> rows, String name) {
        for (Map<String, String> row : rows) {
            String defaultValue = null;
            boolean found = false;
            if (row.containsKey("name")) {
                found = name.equals(row.get("name"));
            }
            if (row.containsKey("defaultValue")) {
                defaultValue = row.get("defaultValue");
            }
            if (!found) continue;
            return defaultValue;
        }
        return null;
    }

    public static String stripOptionalPrefixFromName(List<Map<String, String>> rows, String name) {
        for (Map<String, String> row : rows) {
            String optionalPrefix = null;
            boolean found = false;
            if (row.containsKey("optionalPrefix")) {
                optionalPrefix = row.get("optionalPrefix");
            }
            if (row.containsKey("name")) {
                if (optionalPrefix != null && name.startsWith(optionalPrefix)) {
                    name = name.substring(optionalPrefix.length());
                    return JSonSchemaHelper.stripOptionalPrefixFromName(rows, name);
                }
                found = name.equals(row.get("name"));
            }
            if (!found) continue;
            return name;
        }
        return name;
    }

    public static String getPropertyEnum(List<Map<String, String>> rows, String name) {
        for (Map<String, String> row : rows) {
            String enums = null;
            boolean found = false;
            if (row.containsKey("name")) {
                found = name.equals(row.get("name"));
            }
            if (row.containsKey("enum")) {
                enums = row.get("enum");
            }
            if (!found) continue;
            return enums;
        }
        return null;
    }

    public static String getPropertyPrefix(List<Map<String, String>> rows, String name) {
        for (Map<String, String> row : rows) {
            String prefix = null;
            boolean found = false;
            if (row.containsKey("name")) {
                found = name.equals(row.get("name"));
            }
            if (row.containsKey("prefix")) {
                prefix = row.get("prefix");
            }
            if (!found) continue;
            return prefix;
        }
        return null;
    }

    public static boolean isPropertyMultiValue(List<Map<String, String>> rows, String name) {
        for (Map<String, String> row : rows) {
            boolean multiValue = false;
            boolean found = false;
            if (row.containsKey("name")) {
                found = name.equals(row.get("name"));
            }
            if (row.containsKey("multiValue")) {
                multiValue = "true".equals(row.get("multiValue"));
            }
            if (!found) continue;
            return multiValue;
        }
        return false;
    }

    public static String getPropertyNameFromNameWithPrefix(List<Map<String, String>> rows, String name) {
        for (Map<String, String> row : rows) {
            String propertyName = null;
            boolean found = false;
            if (row.containsKey("name")) {
                propertyName = row.get("name");
            }
            if (row.containsKey("prefix")) {
                String preifx = row.get("prefix");
                found = name.startsWith(preifx);
            }
            if (!found) continue;
            return propertyName;
        }
        return null;
    }

    public static Map<String, String> getRow(List<Map<String, String>> rows, String key) {
        for (Map<String, String> row : rows) {
            if (!key.equals(row.get("name"))) continue;
            return row;
        }
        return null;
    }

    public static Set<String> getNames(List<Map<String, String>> rows) {
        LinkedHashSet<String> answer = new LinkedHashSet<String>();
        for (Map<String, String> row : rows) {
            if (!row.containsKey("name")) continue;
            answer.add(row.get("name"));
        }
        return answer;
    }
}

