/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.spi.IdAware;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.CamelLogger;

public class CamelLogProcessor
implements AsyncProcessor,
IdAware {
    private String id;
    private CamelLogger log;
    private ExchangeFormatter formatter = new ToStringExchangeFormatter();

    public CamelLogProcessor() {
        this(new CamelLogger(CamelLogProcessor.class.getName()));
    }

    public CamelLogProcessor(CamelLogger log) {
        this.log = log;
    }

    public CamelLogProcessor(CamelLogger log, ExchangeFormatter formatter) {
        this(log);
        this.formatter = formatter;
    }

    public String toString() {
        return "Logger[" + this.log + "]";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (this.log.shouldLog()) {
            this.log.log(this.formatter.format(exchange));
        }
        callback.done(true);
        return true;
    }

    public void process(Exchange exchange, Throwable exception) {
        if (this.log.shouldLog()) {
            this.log.log(this.formatter.format(exchange), exception);
        }
    }

    public void process(Exchange exchange, String message) {
        if (this.log.shouldLog()) {
            this.log.log(this.formatter.format(exchange) + message);
        }
    }

    public CamelLogger getLogger() {
        return this.log;
    }

    public void setLogName(String logName) {
        this.log.setLogName(logName);
    }

    public void setLevel(LoggingLevel level) {
        this.log.setLevel(level);
    }

    public void setMarker(String marker) {
        this.log.setMarker(marker);
    }

    static class ToStringExchangeFormatter
    implements ExchangeFormatter {
        ToStringExchangeFormatter() {
        }

        @Override
        public String format(Exchange exchange) {
            return exchange.toString();
        }
    }
}

