/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import java.security.Principal;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;
import org.ops4j.lang.NullArgumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpServiceRequestWrapper
extends HttpServletRequestWrapper {
    protected static final String JETTY_REQUEST_ATTR_NAME = "org.ops4j.pax.web.service.internal.jettyRequest";
    private static final Logger LOG = LoggerFactory.getLogger(HttpServiceRequestWrapper.class);
    private final Request request;
    private final HttpServletRequest originalRequest;

    HttpServiceRequestWrapper(HttpServletRequest servletRequest) {
        super(servletRequest);
        this.originalRequest = servletRequest;
        if (servletRequest instanceof Request) {
            this.request = (Request)servletRequest;
        } else {
            Object requestAttrValue = servletRequest.getAttribute(JETTY_REQUEST_ATTR_NAME);
            if (requestAttrValue != null && requestAttrValue instanceof Request) {
                this.request = (Request)requestAttrValue;
            } else {
                this.request = null;
                LOG.debug("HttpService specific authentication is disabled because the ServletRequest object cannot be used, and org.ops4j.pax.web.service.internal.jettyRequest attribute is not set. Expected to be an instance of " + Request.class.getName() + " but got " + this.originalRequest.getClass().getName() + ".");
            }
        }
    }

    public void setAttribute(String name, Object value) {
        if ("org.osgi.service.http.authentication.type".equals(name)) {
            this.handleAuthenticationType(value);
        } else if ("org.osgi.service.http.authentication.remote.user".equals(name)) {
            this.handleRemoteUser(value);
        }
        super.setAttribute(name, value);
    }

    private void handleAuthenticationType(Object authenticationType) {
        if (this.request != null) {
            if (authenticationType != null && !(authenticationType instanceof String)) {
                String message = "Attribute org.osgi.service.http.authentication.type expected to be a String but was an [" + authenticationType.getClass() + "]";
                LOG.error(message);
                throw new IllegalArgumentException(message);
            }
            this.getOsgiAuth().setAuthMethod((String)authenticationType);
        } else {
            LOG.warn("Authentication type cannot be set to " + authenticationType + ". HttpService specific authentication is disabled because the ServletRequest object cannot be used: " + "Expected to be an instance of " + Request.class.getName() + " but got " + this.originalRequest.getClass().getName() + ".");
        }
    }

    private void handleRemoteUser(Object remoteUser) {
        if (this.request != null) {
            User userPrincipal = null;
            if (remoteUser != null) {
                if (!(remoteUser instanceof String)) {
                    String message = "Attribute org.osgi.service.http.authentication.remote.user expected to be a String but was an [" + remoteUser.getClass() + "]";
                    LOG.error(message);
                    throw new IllegalArgumentException(message);
                }
                userPrincipal = new User((String)remoteUser);
            }
            this.getOsgiAuth().setUserPrincipal(userPrincipal);
        } else {
            LOG.warn("Remote user cannot be set to " + remoteUser + ". HttpService specific authentication is disabled because the ServletRequest object cannot be used: " + "Expected to be an instance of " + Request.class.getName() + " but got " + this.originalRequest.getClass().getName() + ".");
        }
    }

    private OsgiAuth getOsgiAuth() {
        OsgiAuth auth;
        if (this.request.getAuthentication() instanceof OsgiAuth) {
            auth = (OsgiAuth)this.request.getAuthentication();
        } else {
            auth = new OsgiAuth();
            this.request.setAuthentication((Authentication)auth);
        }
        return auth;
    }

    private static class User
    implements Principal {
        private final String name;

        public User(String userName) {
            NullArgumentException.validateNotNull(userName, "User name");
            this.name = userName;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public boolean equals(Object other) {
            if (other == null || !(other instanceof User)) {
                return false;
            }
            User otherAsUser = (User)other;
            return this.name.equals(otherAsUser.name);
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    private static class OsgiAuth
    implements Authentication.User,
    UserIdentity {
        private Principal userPrincipal;
        private String authMethod;

        private OsgiAuth() {
        }

        public Subject getSubject() {
            return null;
        }

        public Principal getUserPrincipal() {
            return this.userPrincipal;
        }

        public void setUserPrincipal(Principal userPrincipal) {
            this.userPrincipal = userPrincipal;
        }

        public boolean isUserInRole(String role, UserIdentity.Scope scope) {
            return false;
        }

        public String getAuthMethod() {
            return this.authMethod;
        }

        public void setAuthMethod(String authMethod) {
            this.authMethod = authMethod;
        }

        public UserIdentity getUserIdentity() {
            return this;
        }

        public boolean isUserInRole(UserIdentity.Scope scope, String role) {
            return this.isUserInRole(role, scope);
        }

        public void logout() {
        }
    }
}

